/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.Connection;
import java.text.Format;
import java.util.Map;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;

public class NLSUtils {
    public static final String NLS_LANG = "NLS_LANG";
    public static final String NLS_TERR = "NLS_TERR";
    public static final String NLS_SORT = "NLS_SORT";
    public static final String NLS_COMP = "NLS_COMP";
    public static final String NLS_DATE_LANG = "NLS_DATE_LANG";
    public static final String NLS_DATE_FORM = "NLS_DATE_FORM";
    public static final String NLS_TS_FORM = "NLS_TS_FORM";
    public static final String NLS_TS_TZ_FORM = "NLS_TS_TZ_FORM";
    public static final String NLS_DEC_SEP = "NLS_DEC_SEP";
    public static final String NLS_GRP_SEP = "NLS_GRP_SEP";
    public static final String NLS_CURR = "NLS_CURR";
    public static final String NLS_ISO_CURR = "NLS_ISO_CURR";
    public static final String NLS_LENGTH = "NLS_LENGTH";

    public static void setNlsFromPrefs(Connection connection) {
        NLSProvider.getProvider(connection).setNlsFromPrefs();
    }

    public static Object getValue(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).getValue(object);
    }

    public static Object getValue(Connection connection, Object object, FormatType formatType) {
        if (formatType == null) {
            return NLSProvider.getProvider(connection).getValue(object);
        }
        return NLSProvider.getProvider(connection).getValue(object, formatType);
    }

    public static void updateDefaults(Connection connection, Map<String, String> map) {
        NLSProvider.getProvider(connection).updateDefaults(map);
    }

    public static void populateNLS(Connection connection) {
        NLSProvider.getProvider(connection).populateNLS();
    }

    public static Format getFormat(Connection connection, int n, FormatType formatType) {
        return NLSProvider.getProvider(connection).getFormat(n, formatType);
    }

    public static String getDateFormat(Connection connection, FormatType formatType) {
        return NLSProvider.getProvider(connection).getDateFormat(formatType);
    }

    public static String getTimeStampWithTimeZoneFormat(Connection connection, FormatType formatType) {
        return NLSProvider.getProvider(connection).getTimeStampWithTimeZoneFormat(formatType);
    }

    public static String getTimeStampFormat(Connection connection, FormatType formatType) {
        return NLSProvider.getProvider(connection).getTimeStampFormat(formatType);
    }

    public static Format getFormat(Connection connection, int n) {
        return NLSProvider.getProvider(connection).getFormat(n);
    }

    public static String getDateFormat(Connection connection) {
        return NLSUtils.getDateFormat(connection, FormatType.PREFERRED);
    }

    public static String getTimeStampWithTimeZoneFormat(Connection connection) {
        return NLSUtils.getTimeStampWithTimeZoneFormat(connection, FormatType.PREFERRED);
    }

    public static String getTimeStampFormat(Connection connection) {
        return NLSUtils.getTimeStampFormat(connection, FormatType.PREFERRED);
    }

    public static char getDecimalSeparator(Connection connection) {
        return NLSProvider.getProvider(connection).getDecimalSeparator();
    }

    public static String toSql(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).getSQL(object);
    }

    public static String format(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).format(object);
    }

    public static String getDBCharset(Connection connection) {
        return NLSProvider.getProvider(connection).getDBCharset();
    }

    public static TimeZone getDatabaseTimeZone(Connection connection) {
        return NLSProvider.getProvider(connection).getDatabaseTimeZone();
    }

    public static TimeZone getSessionTimeZone(Connection connection) {
        return NLSProvider.getProvider(connection).getSessionTimeZone();
    }

    public static String getNullDisplay(Connection connection) {
        return NLSProvider.getProvider(connection).getNullDisplay();
    }

    public static String yieldNullDisplay(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).yieldNullDisplay(object);
    }

    public static boolean isNullOrEquiv(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).isNullOrEquiv(object);
    }

    public static boolean isNullDisplay(Connection connection, Object object) {
        return NLSProvider.getProvider(connection).isNullDisplay(object);
    }

    public static void setNullDisplay(Connection connection, String string) {
        NLSProvider.getProvider(connection).setNullDisplay(string);
    }
}

