/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;

public final class JDBCProxyUtil {
    private static final String PROXY_REGISTRY_CLASS = "oracle.dbtools.raptor.proxy.ProxyRegistry";
    private static final String PROXY_REGISTRY_UNWRAP = "unwrap";
    private static final String PROXY_REGISTRY_PROXY_FOR = "jdbcProxyFor";
    private static JDBCProxyUtil INSTANCE = null;
    private ClassLoader classLoader = null;
    private Class<?> proxyRegistryClass = null;
    private Method unwrapMethod = null;
    private Method jdbcProxyForMethod = null;
    private ClassLoader classLoaderHint = null;

    private JDBCProxyUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JDBCProxyUtil getInstance(ClassLoader classLoader) {
        if (INSTANCE == null) {
            Class<JDBCProxyUtil> clazz = JDBCProxyUtil.class;
            // MONITORENTER : oracle.dbtools.raptor.utils.JDBCProxyUtil.class
            if (INSTANCE == null) {
                INSTANCE = new JDBCProxyUtil();
            }
            // MONITOREXIT : clazz
        }
        INSTANCE.suggestClassLoader(classLoader);
        return INSTANCE;
    }

    public static JDBCProxyUtil getInstance() {
        return JDBCProxyUtil.getInstance(null);
    }

    public Connection jdbcProxyFor(Connection connection, Properties properties) {
        if (connection != null) {
            try {
                Method method = this.jdbcProxyForMethod;
                if (method == null) {
                    Class<?> clazz = this.proxyRegistryClass != null ? this.proxyRegistryClass : this.loadClass(PROXY_REGISTRY_CLASS, connection.getClass().getClassLoader());
                    this.proxyRegistryClass = clazz;
                    this.jdbcProxyForMethod = method = clazz.getMethod(PROXY_REGISTRY_PROXY_FOR, Connection.class, Properties.class);
                }
                connection = (Connection)method.invoke(null, connection, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connection;
    }

    public <T> T unwrap(T object) {
        if (object != null) {
            try {
                Method method = this.unwrapMethod;
                if (method == null) {
                    Class<?> clazz = this.proxyRegistryClass != null ? this.proxyRegistryClass : this.loadClass(PROXY_REGISTRY_CLASS, object.getClass().getClassLoader());
                    this.proxyRegistryClass = clazz;
                    this.unwrapMethod = method = clazz.getMethod(PROXY_REGISTRY_UNWRAP, Object.class);
                }
                object = method.invoke(null, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private Class<?> loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.classLoader != null) {
            clazz = this.classLoader.loadClass(string);
        }
        if (clazz == null && this.classLoaderHint != null) {
            try {
                clazz = this.classLoaderHint.loadClass(string);
                this.setClassLoader(this.classLoaderHint);
            }
            catch (Exception exception) {
                this.suggestClassLoader(null);
            }
        }
        if (clazz == null && classLoader != null) {
            clazz = classLoader.loadClass(string);
            this.setClassLoader(classLoader);
        }
        return clazz;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.suggestClassLoader(null);
    }

    public synchronized void suggestClassLoader(ClassLoader classLoader) {
        this.classLoaderHint = classLoader != null && this.classLoader == null ? classLoader : null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

