/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraINTERVALDSFormat;
import oracle.dbtools.raptor.nls.OraINTERVALYMFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.i18n.util.OraLocaleInfo;
import oracle.jdbc.OracleConnection;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleNLSProvider
extends DefaultNLSProvider {
    private static final String NLS_COMP = "NLS_COMP";
    private static final String NLS_SORT = "NLS_SORT";
    private static final String NLS_LENGTH_SEMANTICS = "NLS_LENGTH_SEMANTICS";
    private static final String NLS_ISO_CURRENCY = "NLS_ISO_CURRENCY";
    private static final String NLS_CURRENCY = "NLS_CURRENCY";
    private static final String NLS_DATE_LANGUAGE = "NLS_DATE_LANGUAGE";
    private static final String SESSION_TIMEZONE_OFFSET = "SESSION_TIMEZONE_OFFSET";
    private static final String SESSION_TIMEZONE = "SESSION_TIMEZONE";
    private static final String NLS_DATE_FORMAT = "NLS_DATE_FORMAT";
    private static final String NLS_NUMERIC_CHARACTERS = "NLS_NUMERIC_CHARACTERS";
    private static final String NLS_CHARACTERSET = "NLS_CHARACTERSET";
    private static final String NLS_TIMESTAMP_TZ_FORMAT = "NLS_TIMESTAMP_TZ_FORMAT";
    private static final String DB_TIMEZONE = "DB_TIMEZONE";
    private static final String NLS_TERRITORY = "NLS_TERRITORY";
    private static final String NLS_LANGUAGE = "NLS_LANGUAGE";
    private static final String NLS_TIMESTAMP_FORMAT = "NLS_TIMESTAMP_FORMAT";
    private static final String GENERIC_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZR";
    private static final String GENERIC_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    private static final String GENERIC_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String LOADER_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
    private static final String LOADER_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    private static final String LOADER_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String ALTER_SESSION = "alter session set {0}=''{1}''";
    private static final Logger LOGGER = Logger.getLogger(OracleNLSProvider.class.getName());
    private Map<String, String> nlsMappings = null;
    private Map<String, String> s_defaults = new HashMap<String, String>();

    public OracleNLSProvider(Connection connection) {
        super(connection);
    }

    private boolean apply(String string, String string2) {
        boolean bl = false;
        String string3 = this.getDefault(string);
        if (this.requiresSetting(string, string2)) {
            String string4 = this.getAlterSession(string2, string3);
            DBUtil dBUtil = DBUtil.getInstance(this.getConnection());
            dBUtil.setRaiseError(false);
            dBUtil.execute(string4, new HashMap());
            bl = true;
        }
        return bl;
    }

    private boolean apply(TimeZone timeZone) {
        try {
            String string = timeZone.getID();
            if (string != null) {
                if (string.length() > 3 && (string.startsWith("GMT+") || string.startsWith("GMT-"))) {
                    string = string.substring(3);
                }
                ((OracleConnection)this.getConnection()).setSessionTimeZone(string);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    @Override
    public String format(Object object) {
        String string;
        String string2 = this.yieldNullDisplay(object);
        if (string2 != null) {
            string = string2;
        } else if (object instanceof BigDecimal) {
            string = this.formatBigDecimal((BigDecimal)object);
        } else if (object instanceof DATE) {
            string = this.formatDate((DATE)object);
        } else if (object instanceof java.util.Date) {
            try {
                object = new DATE(object);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            string = this.formatDate((DATE)object);
        } else {
            string = object instanceof NUMBER ? this.formatNUMBER((NUMBER)object) : (object instanceof BINARY_DOUBLE ? this.formatBINARY_DOUBLE((BINARY_DOUBLE)object) : (object instanceof BINARY_FLOAT ? this.formatBINARY_FLOAT((BINARY_FLOAT)object) : (object instanceof TIMESTAMP ? this.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPLTZ ? this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof TIMESTAMPTZ ? this.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof INTERVALYM ? this.formatINTERVALYM((INTERVALYM)object) : (object instanceof INTERVALDS ? this.formatINTERVALDS((INTERVALDS)object) : super.format(object))))))));
        }
        return string;
    }

    private String formatBigDecimal(BigDecimal bigDecimal) {
        String string = this.yieldNullDisplay(bigDecimal);
        if (string == null && (string = bigDecimal.toPlainString()).indexOf(46) != -1) {
            char c = this.getDecimalSeparator();
            string = bigDecimal.toPlainString();
            if (c != '.') {
                string = string.replace('.', c);
            }
        }
        return string;
    }

    public String formatDate(DATE dATE) {
        String string = this.yieldNullDisplay(dATE);
        if (string == null) {
            OraDATEFormat oraDATEFormat;
            try {
                oraDATEFormat = this.getOraDATEFormat();
            }
            catch (ParseException parseException) {
                oraDATEFormat = null;
            }
            string = oraDATEFormat == null ? dATE.stringValue() : oraDATEFormat.format(dATE);
        }
        return string;
    }

    private String formatNUMBER(NUMBER nUMBER) {
        String string = this.yieldNullDisplay(nUMBER);
        if (string == null && (string = nUMBER.stringValue()).indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(nUMBER.bigDecimalValue());
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private String formatBINARY_DOUBLE(BINARY_DOUBLE bINARY_DOUBLE) {
        String string = this.yieldNullDisplay(bINARY_DOUBLE);
        if (string == null && (string = bINARY_DOUBLE.stringValue()).indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(this.getBigDecimal(bINARY_DOUBLE));
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private String formatBINARY_FLOAT(BINARY_FLOAT bINARY_FLOAT) {
        String string = this.yieldNullDisplay(bINARY_FLOAT);
        if (string == null && (string = bINARY_FLOAT.stringValue()).indexOf(46) != -1) {
            try {
                string = this.formatBigDecimal(this.getBigDecimal(bINARY_FLOAT));
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return string;
    }

    private BigDecimal getBigDecimal(BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        return bINARY_FLOAT != null ? new BigDecimal(bINARY_FLOAT.stringValue()) : null;
    }

    private BigDecimal getBigDecimal(BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        return bINARY_DOUBLE != null ? new BigDecimal(bINARY_DOUBLE.stringValue()) : null;
    }

    private String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
        String string = this.yieldNullDisplay(tIMESTAMP);
        if (string == null) {
            try {
                OraTIMESTAMPFormat oraTIMESTAMPFormat = this.getOraTIMESTAMPFormat();
                string = oraTIMESTAMPFormat.format(tIMESTAMP);
            }
            catch (ParseException parseException) {
                Map<String, String> map = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.18") + map.get(NLS_TIMESTAMP_FORMAT));
            }
        }
        return string;
    }

    private String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
        String string = null;
        try {
            OraTIMESTAMPLTZFormat oraTIMESTAMPLTZFormat = this.getOraTIMESTAMPLTZFormat();
            string = oraTIMESTAMPLTZFormat.format(tIMESTAMPLTZ);
        }
        catch (ParseException parseException) {
            Map<String, String> map = this.getNLSMap();
            LOGGER.severe(Messages.getString("OracleNLSProvider.19") + map.get(NLS_TIMESTAMP_FORMAT));
        }
        return string;
    }

    private String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
        String string = this.yieldNullDisplay(tIMESTAMPTZ);
        if (string == null) {
            try {
                OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = this.getOraTIMESTAMPTZFormat();
                string = oraTIMESTAMPTZFormat.format(tIMESTAMPTZ);
            }
            catch (ParseException parseException) {
                Map<String, String> map = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.20") + map.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return string;
    }

    private String formatLoaderDATE(DATE dATE) {
        String string = this.yieldNullDisplay(dATE);
        if (string == null) {
            try {
                OraDATEFormat oraDATEFormat = this.getOraDATEFormat(this.getDateFormat(FormatType.LOADER));
                string = oraDATEFormat.format(dATE);
            }
            catch (ParseException parseException) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD HH24:MI:SS");
            }
        }
        return string;
    }

    private String formatLoaderTIMESTAMP(TIMESTAMP tIMESTAMP) {
        String string = this.yieldNullDisplay(tIMESTAMP);
        if (string == null) {
            try {
                OraTIMESTAMPFormat oraTIMESTAMPFormat = this.getOraTIMESTAMPFormat(this.getTimeStampFormat(FormatType.LOADER));
                string = oraTIMESTAMPFormat.format(tIMESTAMP);
            }
            catch (ParseException parseException) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + "YYYY-MM-DD HH24:MI:SS.FF");
            }
        }
        return string;
    }

    private String formatLoaderTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
        String string = this.yieldNullDisplay(tIMESTAMPTZ);
        if (string == null) {
            try {
                OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = this.getOraTIMESTAMPTZFormat(this.getTimeStampWithTimeZoneFormat(FormatType.LOADER));
                string = oraTIMESTAMPTZFormat.format(tIMESTAMPTZ);
            }
            catch (ParseException parseException) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + LOADER_TIMESTAMP_TZ_FORMAT);
            }
        }
        return string;
    }

    private String formatLoaderTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
        String string = this.yieldNullDisplay(tIMESTAMPLTZ);
        if (string == null) {
            try {
                OraTIMESTAMPLTZFormat oraTIMESTAMPLTZFormat = this.getOraTIMESTAMPLTZFormat(this.getTimeStampWithTimeZoneFormat(FormatType.LOADER));
                string = oraTIMESTAMPLTZFormat.format(tIMESTAMPLTZ);
            }
            catch (ParseException parseException) {
                LOGGER.severe(Messages.getString("OracleNLSProvider.19") + LOADER_TIMESTAMP_TZ_FORMAT);
            }
        }
        return string;
    }

    private String formatINTERVALYM(INTERVALYM iNTERVALYM) {
        String string = this.yieldNullDisplay(iNTERVALYM);
        if (string == null) {
            try {
                OraINTERVALYMFormat oraINTERVALYMFormat = this.getOraINTERVALYMFormat();
                string = oraINTERVALYMFormat.format(iNTERVALYM);
            }
            catch (ParseException parseException) {
                Map<String, String> map = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.22") + map.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return string;
    }

    private String formatINTERVALDS(INTERVALDS iNTERVALDS) {
        String string = this.yieldNullDisplay(iNTERVALDS);
        if (string == null) {
            try {
                OraINTERVALDSFormat oraINTERVALDSFormat = this.getOraINTERVALDSFormat();
                string = oraINTERVALDSFormat.format(iNTERVALDS);
            }
            catch (ParseException parseException) {
                Map<String, String> map = this.getNLSMap();
                LOGGER.severe(Messages.getString("OracleNLSProvider.23") + map.get(NLS_TIMESTAMP_TZ_FORMAT));
            }
        }
        return string;
    }

    public Number parseNumber(String string) {
        Number number = null;
        if (string != null) {
            char c = this.getDecimalSeparator();
            number = string.indexOf(c) != -1 ? new BigDecimal(string.replace(c, '.')) : new BigInteger(string);
        }
        return number;
    }

    @Override
    public String getDBCharset() {
        return this.getNLSMap().get(NLS_CHARACTERSET);
    }

    public String getDBLanguage() {
        return this.getNLSMap().get(NLS_LANGUAGE);
    }

    public String getDBTerritory() {
        return this.getNLSMap().get(NLS_TERRITORY);
    }

    public String getDBTimeZone() {
        return this.getNLSMap().get(DB_TIMEZONE);
    }

    @Override
    public char getDecimalSeparator() {
        String string = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return string.substring(0, 1).charAt(0);
    }

    @Override
    public char getGroupSeparator() {
        String string = this.getNLSMap().get(NLS_NUMERIC_CHARACTERS);
        return string.substring(1, 2).charAt(0);
    }

    @Override
    public String getDateFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_DATE_FORMAT);
            }
            case GENERIC: {
                return "YYYY-MM-DD HH24:MI:SS";
            }
            case LOADER: {
                return "YYYY-MM-DD HH24:MI:SS";
            }
        }
        return super.getDateFormat(formatType);
    }

    @Override
    public String getTimeStampWithTimeZoneFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_TIMESTAMP_TZ_FORMAT);
            }
            case GENERIC: {
                return GENERIC_TIMESTAMP_TZ_FORMAT;
            }
            case LOADER: {
                return LOADER_TIMESTAMP_TZ_FORMAT;
            }
        }
        return super.getTimeStampWithTimeZoneFormat(formatType);
    }

    @Override
    public String getTimeStampFormat(FormatType formatType) {
        switch (formatType) {
            case PREFERRED: {
                return this.getNLSMap().get(NLS_TIMESTAMP_FORMAT);
            }
            case GENERIC: {
                return "YYYY-MM-DD HH24:MI:SS.FF";
            }
            case LOADER: {
                return "YYYY-MM-DD HH24:MI:SS.FF";
            }
        }
        return super.getTimeStampFormat(formatType);
    }

    public String getDBDateLanguage() {
        return this.getNLSMap().get(NLS_DATE_LANGUAGE);
    }

    private Map<String, String> getNLSMap() {
        if (this.nlsMappings == null) {
            this.populateNLS();
        }
        return this.nlsMappings;
    }

    public OraDATEFormat getOraDATEFormat(String string) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraDATEFormat(string, OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat(String string) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraTIMESTAMPFormat(string, OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat(String string) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraTIMESTAMPLTZFormat(string, OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)), this.getTimeZone(map.get(DB_TIMEZONE)), this.getSessionTimeZone());
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat(String string) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraTIMESTAMPTZFormat(string, OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
    }

    public OraDATEFormat getOraDATEFormat(FormatType formatType) throws ParseException {
        return this.getOraDATEFormat(this.getDateFormat(formatType));
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat(FormatType formatType) throws ParseException {
        return this.getOraTIMESTAMPFormat(this.getTimeStampFormat(formatType));
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat(FormatType formatType) throws ParseException {
        return this.getOraTIMESTAMPLTZFormat(this.getTimeStampFormat(formatType));
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat(FormatType formatType) throws ParseException {
        return this.getOraTIMESTAMPTZFormat(this.getTimeStampWithTimeZoneFormat(formatType));
    }

    public OraINTERVALYMFormat getOraINTERVALYMFormat(FormatType formatType) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraINTERVALYMFormat(OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
    }

    public OraINTERVALDSFormat getOraINTERVALDSFormat(FormatType formatType) throws ParseException {
        Map<String, String> map = this.getNLSMap();
        return new OraINTERVALDSFormat(OraLocaleInfo.getInstance((String)map.get(NLS_LANGUAGE), (String)map.get(NLS_TERRITORY)));
    }

    public OraDATEFormat getOraDATEFormat() throws ParseException {
        return this.getOraDATEFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPFormat getOraTIMESTAMPFormat() throws ParseException {
        return this.getOraTIMESTAMPFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPLTZFormat getOraTIMESTAMPLTZFormat() throws ParseException {
        return this.getOraTIMESTAMPLTZFormat(FormatType.PREFERRED);
    }

    public OraTIMESTAMPTZFormat getOraTIMESTAMPTZFormat() throws ParseException {
        return this.getOraTIMESTAMPTZFormat(FormatType.PREFERRED);
    }

    public OraINTERVALYMFormat getOraINTERVALYMFormat() throws ParseException {
        return this.getOraINTERVALYMFormat(FormatType.PREFERRED);
    }

    public OraINTERVALDSFormat getOraINTERVALDSFormat() throws ParseException {
        return this.getOraINTERVALDSFormat(FormatType.PREFERRED);
    }

    public TimeZone getTimeZone(String string) throws ParseException {
        TimeZone timeZone;
        if (string != null) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-') {
                timeZone = TimeZone.getTimeZone("GMT" + string);
                if (timeZone == null) {
                    throw new ParseException(Messages.getString("OracleNLSProvider.48") + string + "", 0);
                }
            } else {
                timeZone = TimeZone.getTimeZone(string);
                if (timeZone == null) {
                    throw new ParseException(Messages.getString("OracleNLSProvider.49") + string + "", 0);
                }
            }
        } else {
            timeZone = null;
        }
        return timeZone;
    }

    @Override
    public TimeZone getDatabaseTimeZone() {
        try {
            return this.getTimeZone(this.getDBTimeZone());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public TimeZone getSessionTimeZone() {
        TimeZone timeZone = null;
        Map<String, String> map = this.getNLSMap();
        String string = map.get(SESSION_TIMEZONE);
        if (string != null) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-') {
                string = "GMT" + string;
            }
            if ((timeZone = TimeZone.getTimeZone(string)).getID().equals("GMT") && !string.equals("GMT")) {
                String string2 = "GMT" + map.get(SESSION_TIMEZONE_OFFSET);
                byte[] byArray = string2.getBytes();
                if (byArray[byArray.length - 1] == 0) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                timeZone = TimeZone.getTimeZone(string2);
            }
        } else {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    @Override
    @Deprecated
    public String getSQL(Object object) {
        return object.toString();
    }

    @Override
    public Format getFormat(int n, FormatType formatType) {
        try {
            switch (n) {
                case 91: {
                    return this.getOraDATEFormat(formatType);
                }
                case 93: {
                    return this.getOraTIMESTAMPFormat(formatType);
                }
                case -101: {
                    return this.getOraTIMESTAMPTZFormat(formatType);
                }
                case -102: {
                    return this.getOraTIMESTAMPLTZFormat(formatType);
                }
                case -103: {
                    return this.getOraINTERVALYMFormat(formatType);
                }
                case -104: {
                    return this.getOraINTERVALDSFormat(formatType);
                }
            }
        }
        catch (ParseException parseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parseException.getStackTrace()[0].toString(), parseException);
        }
        return null;
    }

    @Override
    public Object getValue(Object object, FormatType formatType) {
        Object object2;
        String string = this.yieldNullDisplay(object);
        try {
            object2 = string != null ? string : (object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof Timestamp ? this.formatTIMESTAMP(new TIMESTAMP((Timestamp)object)) : (object instanceof TIMESTAMP ? (formatType == FormatType.LOADER ? this.formatLoaderTIMESTAMP((TIMESTAMP)object) : this.formatTIMESTAMP((TIMESTAMP)object)) : (object instanceof TIMESTAMPTZ ? (formatType == FormatType.LOADER ? this.formatLoaderTIMESTAMPTZ((TIMESTAMPTZ)object) : this.formatTIMESTAMPTZ((TIMESTAMPTZ)object)) : (object instanceof TIMESTAMPLTZ ? (formatType == FormatType.LOADER ? this.formatLoaderTIMESTAMPLTZ((TIMESTAMPLTZ)object) : this.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object)) : (object instanceof DATE ? (formatType == FormatType.LOADER ? this.formatLoaderDATE((DATE)object) : this.formatDate((DATE)object)) : (object instanceof Date ? this.formatDate(new DATE((Date)object)) : (object instanceof NUMBER ? this.formatNUMBER((NUMBER)object) : (object instanceof BINARY_DOUBLE ? this.formatBINARY_DOUBLE((BINARY_DOUBLE)object) : (object instanceof BINARY_FLOAT ? this.formatBINARY_FLOAT((BINARY_FLOAT)object) : (object instanceof BigDecimal ? this.formatBigDecimal((BigDecimal)object) : (object instanceof INTERVALDS ? this.formatINTERVALDS((INTERVALDS)object) : (object instanceof INTERVALYM ? this.formatINTERVALYM((INTERVALYM)object) : (object instanceof Datum ? ((Datum)object).stringValue() : super.getValue(object, formatType))))))))))))))));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            object2 = "";
        }
        return object2;
    }

    private String getDefault(String string) {
        return this.s_defaults.get(string);
    }

    @Override
    public Object parse(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object parse(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initConnection() {
        this.setNlsFromPrefs();
        this.populateNLS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateNLS() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport(new MetaResource(this.getClass().getClassLoader(), "oracle/dbtools/raptor/utils/loadNLS.xml"));
            Query query = queryXMLSupport.getQuery("loadnls", this.getConnection());
            if (this.nlsMappings == null) {
                this.nlsMappings = new HashMap<String, String>();
            }
            statement = this.getConnection().prepareStatement(query.getSql());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                this.nlsMappings.put(resultSet.getString(1), resultSet.getString(2));
                LOGGER.fine(Messages.getString("OracleNLSProvider.28") + resultSet.getString(1) + "=" + resultSet.getString(2));
            }
        }
        catch (Exception exception) {
            LOGGER.severe(Messages.getString("OracleNLSProvider.30") + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean requiresSetting(String string, String string2) {
        String string3 = this.getDefault(string);
        String string4 = this.getNLSMap().get(string2);
        if (string2 != null && string3 != null && string4 != null) {
            LOGGER.fine(Messages.getString("OracleNLSProvider.31") + string2 + ":" + string3 + ":" + string4);
        }
        return string3 != null && !string3.equals("") && !string3.equals(string4);
    }

    @Override
    public void setNlsFromPrefs() {
        String string;
        String string2 = "";
        String string3 = this.getDefault("NLS_SKIP");
        if (Boolean.parseBoolean(string3)) {
            return;
        }
        DBUtil dBUtil = DBUtil.getInstance(this.getConnection());
        dBUtil.setRaiseError(false);
        Version version = DBUtil.getDbVersion(this.getConnection());
        Map<String, String> map = this.getNLSMap();
        boolean bl = this.apply("NLS_LANG", NLS_LANGUAGE);
        bl |= this.apply("NLS_TERR", NLS_TERRITORY);
        bl |= this.apply(NLS_SORT, NLS_SORT);
        if (this.requiresSetting(NLS_COMP, NLS_COMP)) {
            if (version.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.38"));
            } else if (version.compareTo(new Version("10.2")) < 0) {
                string2 = this.getAlterSession(NLS_COMP, "ANSI");
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.41"));
            } else {
                string = this.getDefault(NLS_COMP);
                string2 = this.getAlterSession(NLS_COMP, string);
            }
            dBUtil.execute(string2, new HashMap());
            bl = true;
        }
        bl |= this.apply("NLS_DATE_LANG", NLS_DATE_LANGUAGE);
        bl |= this.apply("NLS_DATE_FORM", NLS_DATE_FORMAT);
        bl |= this.apply("NLS_TS_FORM", NLS_TIMESTAMP_FORMAT);
        if (this.requiresSetting("NLS_TS_TZ_FORM", NLS_TIMESTAMP_TZ_FORMAT)) {
            string2 = this.getAlterSession(NLS_TIMESTAMP_TZ_FORMAT, this.getDefault("NLS_TS_TZ_FORM"));
            if (version.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_TIMESTAMP_TZ_FORMAT + Messages.getString("OracleNLSProvider.43"));
            } else {
                dBUtil.execute(string2, new HashMap());
                bl = true;
            }
        }
        string = map.get(NLS_NUMERIC_CHARACTERS);
        String string4 = this.getDefault("NLS_DEC_SEP");
        String string5 = this.getDefault("NLS_GRP_SEP");
        if (!(string == null || string4 == null || string5 == null || string4.equals("") || string5.equals("") || string.equals(string4 + string5) || string4.equals(string5))) {
            string2 = this.getAlterSession(NLS_NUMERIC_CHARACTERS, string4 + string5);
            dBUtil.execute(string2, new HashMap());
            bl = true;
        }
        bl |= this.apply("NLS_CURR", NLS_CURRENCY);
        bl |= this.apply("NLS_ISO_CURR", NLS_ISO_CURRENCY);
        if (this.requiresSetting("NLS_LENGTH", NLS_LENGTH_SEMANTICS)) {
            string2 = this.getAlterSession(NLS_LENGTH_SEMANTICS, this.getDefault("NLS_LENGTH"));
            if (version.compareTo(new Version("9")) < 0) {
                LOGGER.log(Level.INFO, NLS_COMP + Messages.getString("OracleNLSProvider.47"));
            } else {
                dBUtil.execute(string2, new HashMap());
                bl = true;
            }
        }
        if (bl |= this.apply(this.getSessionTimeZone())) {
            this.populateNLS();
        }
    }

    @Override
    public void updateDefaults(Map<String, String> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                this.s_defaults.put(string, map.get(string));
            }
        }
    }

    private String getAlterSession(String string, String string2) {
        if (string2 != null) {
            string2 = string2.replaceAll("'", "''");
        }
        return MessageFormat.format(ALTER_SESSION, string, string2);
    }
}

