/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;

public abstract class OraTemporalDatumFormat
extends Format
implements OraConstants {
    private OraSimpleDateFormatDelegate delegate;
    private Connection connection = null;
    private TimeZone sessionTimeZone;
    protected static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR_FIELD = 15;
    public static final int TIMEZONE_FIELD = 17;
    public static final int ALL_FIELD = 1000;
    public static final int CENTRY_FIELD = 1001;
    public static final int JULIAN_DAY_FIELD = 1002;
    public static final int QUARTER_OF_YEAR_FIELD = 1003;
    public static final int SECONDS_FIELD = 1004;
    public static final int TEXT_FIELD = 1005;
    public static final int ISO_YEAR_FIELD = 1006;
    public static final int ISO_WEEK_OF_YEAR_FIELD = 1007;

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public OraTemporalDatumFormat(String string, OraLocaleInfo oraLocaleInfo, TimeZone timeZone) throws ParseException {
        this.delegate = new OraSimpleDateFormatDelegate(string, oraLocaleInfo);
        this.sessionTimeZone = timeZone;
        this.applyPattern(string);
    }

    public final OraLocaleInfo getOraLocaleInfo() {
        return this.delegate.localeInfo;
    }

    public final Locale getLocale() {
        return this.delegate.localeInfo.getLocale();
    }

    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    protected final String getSavedPattern() {
        return this.delegate.savedPattern;
    }

    protected TimeZone getSessionTimeZone() {
        return this.sessionTimeZone;
    }

    protected abstract OraTemporalDatum getTemporalDatum(Calendar var1, int var2);

    @Override
    public Object clone() {
        OraTemporalDatumFormat oraTemporalDatumFormat = (OraTemporalDatumFormat)super.clone();
        oraTemporalDatumFormat.delegate = (OraSimpleDateFormatDelegate)this.delegate.clone();
        oraTemporalDatumFormat.connection = this.connection;
        return oraTemporalDatumFormat;
    }

    public void applyPattern(String string) throws ParseException {
        this.delegate.gdkApplyPattern(string);
        this.delegate.savedPattern = string;
    }

    public String toPattern() {
        return this.getSavedPattern();
    }

    protected String getLastPattern() {
        return this.delegate.toPattern();
    }

    public Calendar getCalendar() {
        return this.delegate.getCalendar();
    }

    protected void applyParsePattern(String string) throws ParseException {
        int n;
        int n2;
        String string2 = string.toUpperCase(Locale.US);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = -1;
        while ((n3 = string2.indexOf("SP", n3 + 1)) >= 0) {
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraSimpleDATEFormat.63"), n3);
        }
        n3 = -1;
        while ((n3 = string2.indexOf("TH", n3 + 1)) >= 0) {
            if (n3 > 2 && string2.substring(n3 - 3, n3 + 2).equals("MONTH")) continue;
            n2 = -1;
            n = 0;
            while ((n2 = string2.indexOf(34, n2 + 1)) < n3 && n2 != -1) {
                ++n;
            }
            if (n % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraSimpleDATEFormat.63"), n3);
        }
        this.delegate.gdkApplyPattern(stringBuffer.toString());
    }

    protected void applyFormatPattern(String string) throws ParseException {
        this.delegate.gdkApplyPattern(string);
    }

    public abstract Datum parse(String var1, ParsePosition var2);

    public Datum parse(String string) throws ParseException {
        return this.parse(string, new ParsePosition(0));
    }

    public final Datum parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    protected OraTemporalDatum parseTemporalDatum(String string, ParsePosition parsePosition, TimeZone timeZone, boolean bl) {
        if (string != null && string.length() > 0) {
            ParsePosition parsePosition2 = new ParsePosition(parsePosition.getIndex());
            this.prepareToParse(timeZone);
            Date date = this.delegate.parse(string, parsePosition);
            long l = date.getTime();
            int n = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
            TimeZone timeZone2 = bl ? this.delegate.reparseforTimeZone(string, parsePosition2) : timeZone;
            Calendar calendar = this.getDatumParseCalendar(l, timeZone2);
            return this.getTemporalDatum(calendar, n);
        }
        return null;
    }

    protected OraTemporalDatum parseTemporalDatum(String string, ParsePosition parsePosition, TimeZone timeZone) {
        return this.parseTemporalDatum(string, parsePosition, timeZone, false);
    }

    private void prepareToParse(TimeZone timeZone) {
        this.delegate.applyTimeZone(timeZone);
        this.delegate.applyTimeInMillis(new Date().getTime());
    }

    protected StringBuffer formatTemporalDatum(OraTemporalDatum oraTemporalDatum, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (oraTemporalDatum != null) {
            this.prepareToFormat(oraTemporalDatum.getTimeZone());
            return this.delegate.format(oraTemporalDatum.toTimestamp(), stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }

    private void prepareToFormat(TimeZone timeZone) {
        this.delegate.applyTimeZone(timeZone);
    }

    protected Calendar getDatumFormatCalendar(TimeZone timeZone) {
        Calendar calendar = (Calendar)this.delegate.shareCalendar().clone();
        calendar.clear();
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    protected Calendar getDatumParseCalendar(long l, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.US);
        calendar.setTimeInMillis(l);
        return calendar;
    }

    private class OraSimpleDateFormatDelegate
    extends OraSimpleDateFormat
    implements Cloneable {
        private static final int FIELD_NULL = Integer.MIN_VALUE;
        private static final int MILLISECONDS_PER_HOUR = 3600000;
        private static final int MILLISECONDS_PER_MINUTE = 60000;
        private OraLocaleInfo localeInfo;
        private String savedPattern;
        private OraDateFormatSymbols symbols;

        public OraSimpleDateFormatDelegate(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
            super(string, oraLocaleInfo);
            this.savedPattern = null;
            this.savedPattern = string;
            this.localeInfo = oraLocaleInfo;
            this.symbols = new OraDateFormatSymbols(oraLocaleInfo);
        }

        public Object clone() {
            OraSimpleDateFormatDelegate oraSimpleDateFormatDelegate = (OraSimpleDateFormatDelegate)super.clone();
            oraSimpleDateFormatDelegate.localeInfo = (OraLocaleInfo)this.localeInfo.clone();
            oraSimpleDateFormatDelegate.savedPattern = this.savedPattern;
            return oraSimpleDateFormatDelegate;
        }

        public Calendar shareCalendar() {
            return this.calendar;
        }

        public void applyTimeZone(TimeZone timeZone) {
            this.calendar.setTimeZone(timeZone);
        }

        public void applyTimeInMillis(long l) {
            this.calendar.setTimeInMillis(l);
        }

        public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.format(this.savedPattern, date, stringBuffer, fieldPosition);
        }

        public StringBuffer format(String string, Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            try {
                OraTemporalDatumFormat.this.applyFormatPattern(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.61"), parseException);
            }
            return super.format(date, stringBuffer, fieldPosition);
        }

        public Date parse(String string, ParsePosition parsePosition) {
            return this.parse(this.savedPattern, string, parsePosition);
        }

        public TimeZone reparseforTimeZone(String string, ParsePosition parsePosition) {
            return this.reparseforTimeZone(this.savedPattern, string, parsePosition);
        }

        public Date parse(String string, String string2, ParsePosition parsePosition) {
            try {
                OraTemporalDatumFormat.this.applyParsePattern(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.62"), parseException);
            }
            return super.parse(string2, parsePosition);
        }

        protected final void gdkApplyPattern(String string) throws ParseException {
            String string2;
            try {
                string2 = this.toPattern();
            }
            catch (NullPointerException nullPointerException) {
                string2 = null;
            }
            if (!OraTemporalDatumFormat.areEqual(string, string2)) {
                this.applyPattern(string);
            }
        }

        public TimeZone reparseforTimeZone(String string, String string2, ParsePosition parsePosition) {
            TimeZone timeZone = null;
            Pattern pattern = Pattern.compile("(([\"][^\"]*[\"])|.)*TZR");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string3 = string.substring(0, matcher.end() - 3) + "\"X\"TZR";
                try {
                    this.parse(string3, string2, parsePosition);
                }
                catch (Exception exception) {
                    ParsePosition parsePosition2 = new ParsePosition(parsePosition.getErrorIndex());
                    String string4 = this.getTimeZoneID(string2, string2.length(), parsePosition2);
                    timeZone = TimeZone.getTimeZone(string4);
                }
            }
            return timeZone;
        }

        private String getTimeZoneID(String string, int n, ParsePosition parsePosition) {
            String[] stringArray = TimeZone.getAvailableIDs();
            int n2 = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = stringArray[i].length();
                if (n2 + n3 > n || !string.regionMatches(true, n2, stringArray[i], 0, n3)) continue;
                parsePosition.setIndex(n2 + n3);
                return stringArray[i];
            }
            return null;
        }

        private String getTimeZoneAbbr(String string, int n, ParsePosition parsePosition) {
            int n2 = parsePosition.getIndex();
            if (n2 + 3 > n) {
                return null;
            }
            parsePosition.setIndex(n2 + 3);
            return string.substring(n2, n2 + 3);
        }

        private boolean setTimeZone(String string, String string2, Calendar calendar, Locale locale) {
            TimeZone timeZone;
            if (string != null) {
                timeZone = TimeZone.getTimeZone(string);
                calendar.setTimeZone(timeZone);
            } else {
                timeZone = calendar.getTimeZone();
            }
            if (string2 != null) {
                if (timeZone.getDisplayName(true, 0, locale).equals(string2) && !timeZone.inDaylightTime(calendar.getTime())) {
                    return false;
                }
                if (timeZone.getDisplayName(false, 0, locale).equals(string2) && timeZone.inDaylightTime(calendar.getTime())) {
                    return false;
                }
            }
            return true;
        }

        private int getTimeZoneOffset(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2) {
            int n3 = Integer.MIN_VALUE;
            int n4 = parsePosition.getIndex();
            boolean bl3 = false;
            if (n4 >= n) {
                return Integer.MIN_VALUE;
            }
            char c = string.charAt(n4);
            if (c == ':') {
                if (++n4 >= n) {
                    return Integer.MIN_VALUE;
                }
                parsePosition.setIndex(n4);
                c = string.charAt(n4);
                bl3 = true;
            }
            if (Character.isDigit(c) || n4 + 2 <= n && (c == '+' || c == '-')) {
                boolean bl4;
                n3 = 0;
                int n5 = 0;
                int n6 = 0;
                if (c == '-') {
                    bl4 = true;
                    ++n4;
                } else {
                    bl4 = false;
                    if (c == '+') {
                        ++n4;
                    }
                }
                parsePosition.setIndex(n4);
                n6 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2);
                if (n6 >= 0) {
                    if (bl3) {
                        n5 = n6;
                        int[] nArray = OraDateFormatPattern.FORMAT_ATTR[1];
                        if (bl4 && -n5 < nArray[1] || !bl4 && n5 > nArray[2]) {
                            return Integer.MIN_VALUE;
                        }
                        n3 = n5 * 60000;
                    } else {
                        int[] nArray = OraDateFormatPattern.FORMAT_ATTR[0];
                        if (bl4 && -n6 < nArray[1] || !bl4 && n6 > nArray[2]) {
                            return Integer.MIN_VALUE;
                        }
                        n3 = n6 * 3600000;
                        n4 = parsePosition.getIndex();
                        if (n4 < n && string.charAt(n4) == ':') {
                            parsePosition.setIndex(++n4);
                        }
                        if (n4 < n && string.charAt(n4) == '+') {
                            parsePosition.setIndex(++n4);
                        }
                        if (n4 < n && (n5 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2)) >= 0) {
                            nArray = OraDateFormatPattern.FORMAT_ATTR[1];
                            if (n5 < nArray[1] || n5 > nArray[2]) {
                                return Integer.MIN_VALUE;
                            }
                            n3 += n5 * 60000;
                        }
                    }
                }
                if (bl4) {
                    n3 = -n3;
                }
            }
            return n3;
        }

        private int toNumber(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2, boolean bl3) {
            int n3;
            int n4 = parsePosition.getIndex();
            char c = string.charAt(n4);
            if (!Character.isDigit(c)) {
                return -5058;
            }
            int n5 = Character.digit(c, 10);
            ++n4;
            for (n3 = 1; n3 < n2 && n4 < n; ++n3, ++n4) {
                c = string.charAt(n4);
                if (c == this.symbols.getGroupingSeparator()) {
                    if (bl) continue;
                    break;
                }
                if (!Character.isDigit(c)) break;
                n5 = n5 * 10 + Character.digit(c, 10);
            }
            if (bl2 && !bl3 && n3 != n2) {
                return -5062;
            }
            parsePosition.setIndex(n4);
            return n5;
        }
    }

    private static class OraDateFormatSymbols {
        private OraLocaleInfo localeInfo;

        public OraDateFormatSymbols(OraLocaleInfo oraLocaleInfo) {
            this.localeInfo = oraLocaleInfo;
        }

        public char getGroupingSeparator() {
            return this.localeInfo.getOraTerritory().getGroupSeparator().charAt(0);
        }
    }

    private static class OraDateFormatPattern {
        private static final int TZMAXMINUTE = 59;
        private static final int TZMAXHOUR = 14;
        private static final int TZMINMINUTE = -59;
        private static final int TZMINHOUR = -12;
        static final char TZH = '\u0000';
        static final char TZM = '\u0001';
        static final char TZD = '\u0002';
        static final char TZR = '\u0003';
        static final char ALPHA = '\u0080';
        static final char FNJUS = '@';
        static final char NEG = ' ';
        static final int FORMAT_ATTR_ERR = 0;
        static final int FORMAT_ATTR_LOW = 1;
        static final int FORMAT_ATTR_HIGH = 2;
        static final int FORMAT_ATTR_LEN = 3;
        static final int FORMAT_FIELD = 4;
        static final int[][] FORMAT_ATTR = new int[][]{{5074, -12, 14, 35, 8}, {5075, -59, 59, 2, 8}, {5057, 0, 12, 198, 8}, {5057, 0, 64, 224, 8}};

        private OraDateFormatPattern() {
        }
    }
}

