/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowPDBS
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    String sql = "SELECT CON_ID, NAME, OPEN_MODE, RESTRICTED FROM V$PDBS";

    @Override
    public String[] getShowAliases() {
        return new String[]{"PDBS"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        DBUtil dBUtil = DBUtil.getInstance(connection);
        ResultSet resultSet = null;
        boolean bl = false;
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        try {
            bl = connectionResolver.lock(scriptRunnerContext.getBaseConnection());
            if (bl) {
                if (DBUtil.checkVersion(connection, new Version("15"), new Version("12.0"))) {
                    resultSet = dBUtil.executeOracleQuery(this.sql, null);
                }
                if (resultSet != null && connection instanceof OracleConnection && resultSet.isBeforeFirst()) {
                    String string = (String)scriptRunnerContext.getProperty("script.runner.optional_show_header");
                    if (string != null && !string.equals("")) {
                        scriptRunnerContext.write(string);
                    }
                    SQLPLUSCmdFormatter sQLPLUSCmdFormatter = new SQLPLUSCmdFormatter(scriptRunnerContext);
                    sQLPLUSCmdFormatter.formatResults((BufferedOutputStream)scriptRunnerContext.getOutputStream(), resultSet, this.sql);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    DBUtil.closeResultSet(resultSet);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            if (bl) {
                try {
                    connectionResolver.unlock(scriptRunnerContext.getBaseConnection());
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

