/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowInternalErrors
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWINTERNALERROR = new String[]{"internalerrors"};

    @Override
    public String[] getShowAliases() {
        return SHOWINTERNALERROR;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowInternalError(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowInternalError(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            for (String string : new String[]{"sqldev.error", "sqldev.error.any.in", "script.runner.autocommit.errorFlag", "sqldev.last.err.message", "sqldev.last.err.message.forsqlcode"}) {
                if (scriptRunnerContext.getProperty(string) != null) {
                    scriptRunnerContext.write(string.toLowerCase() + " \"" + scriptRunnerContext.getProperty(string).toString() + "\"\n");
                    continue;
                }
                scriptRunnerContext.write(string.toLowerCase() + " \"\" \n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }
}

