/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowConname
implements IShowCommand {
    private static final String SHOWCONNAME = "con_name";
    private static final String[] BOTH = new String[]{"con_name", "con_id"};

    @Override
    public String[] getShowAliases() {
        return BOTH;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            if (ScriptUtils.eatOneWord(iSQLCommand.getSql()).trim().toUpperCase().startsWith(SHOWCONNAME.toUpperCase())) {
                return this.doConNameOrId(connection, scriptRunnerContext, iSQLCommand, false);
            }
            return this.doConNameOrId(connection, scriptRunnerContext, iSQLCommand, true);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doConNameOrId(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, boolean bl) {
        String string = "con_name ";
        if (bl) {
            string = "con_id ";
        }
        try {
            String string2 = null;
            scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
            String string3 = null;
            Connection connection2 = scriptRunnerContext.getCurrentConnection();
            DBUtil dBUtil = DBUtil.getInstance(connection2);
            if (DBUtil.getDbVersion(connection2).compareTo(new Version("12.1")) >= 0) {
                if (!bl) {
                    if (dBUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                        string3 = Messages.getString("SHOWCONNONCONSOLIDATED");
                        scriptRunnerContext.write(string + string3);
                    }
                    string2 = "SELECT substr(SYS_CONTEXT ('USERENV', 'CON_NAME'),1,30) CON_NAME from dual";
                } else {
                    string2 = "SELECT substr(SYS_CONTEXT ('USERENV', 'CON_ID'),1,30) CON_ID from dual";
                }
            } else {
                string3 = Messages.getString("SHOWCONVERSIONTOOLOW");
                scriptRunnerContext.write(string + string3);
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", "SP2-0614: Server version too low for this feature");
            }
            if (string3 == null) {
                ArrayList arrayList = new ArrayList();
                String string4 = dBUtil.executeReturnOneCol(string2, arrayList);
                if (string4 != null) {
                    scriptRunnerContext.write(string + string4 + "\n");
                } else {
                    scriptRunnerContext.write(string + Messages.getString("SHOWPARAMETERSNORESULTSET"));
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }
}

