/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowAutotrace
implements IShowCommand {
    private static final String[] SHOWAUTOTRACE = new String[]{"autot", "autotr", "autotra", "autotrac", "autotrace"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOTRACE;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowAutotrace(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAutotrace(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("AUTOTRACE_STATE");
        if (bl == null || bl.equals(Boolean.FALSE)) {
            scriptRunnerContext.write("autotrace OFF\n");
        } else {
            String string = "autotrace ON";
            String string2 = (String)scriptRunnerContext.getProperty("AUTOTRACE_TYPE");
            if (string2 != null) {
                if (string2.equals("EXPLAIN")) {
                    string = string + " EXPLAIN";
                } else if (string2.equals("ALL")) {
                    string = string + " EXPLAIN STATISTICS";
                } else if (string2.equals("STATISTICS")) {
                    string = string + " STATISTICS";
                }
            }
            scriptRunnerContext.write(string + "\n");
        }
        return true;
    }
}

