/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowAutocommit
implements IShowCommand {
    private static final String[] SHOWAUTOCOMMIT = new String[]{"auto", "autoc", "autoco", "autocom", "autocomm", "autocommi", "autocommit"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOCOMMIT;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowAutocommit(connection, scriptRunnerContext, iSQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAutocommit(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Long l = (Long)scriptRunnerContext.getProperty("script.runner.autocommit.setting");
        if (l == 1L || l == ScriptRunnerContext.AUTOCOMMITON) {
            scriptRunnerContext.write("autocommit IMMEDIATE\n");
        } else if (l == ScriptRunnerContext.AUTOCOMMITOFF) {
            scriptRunnerContext.write("autocommit OFF\n");
        } else {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("SHOWAUTOCOMMITEVERYN"), "AUTOCOMMIT ON", l));
        }
        return true;
    }
}

