/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.Service;

public class TransparentGateway
extends CommandListener {
    private Set<String> links;
    private static HashMap<Connection, Boolean> autoDbLinksAtConnection = new HashMap();

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        this.cleanLinks(connection, scriptRunnerContext);
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (!Boolean.TRUE.equals(autoDbLinksAtConnection.get(connection))) {
            return;
        }
        if (iSQLCommand.getStmtType() != SQLCommand.StmtType.G_C_SQL && iSQLCommand.getStmtType() != SQLCommand.StmtType.G_C_PLSQL) {
            return;
        }
        String string = iSQLCommand.getSql();
        if (string.indexOf(64) < 0) {
            return;
        }
        List<LexerToken> list = LexerToken.parse(string);
        boolean bl = false;
        int n = 0;
        for (LexerToken lexerToken : list) {
            String string2 = lexerToken.content;
            if ("@".equals(string2)) {
                bl = true;
                continue;
            }
            if (bl) {
                String string3 = string2.toUpperCase();
                if (string2.charAt(0) == '\"') {
                    string2 = string2.substring(1, string2.length() - 1);
                    string3 = Service.into2chars(string2);
                    string = iSQLCommand.getSql();
                    iSQLCommand.setSql(string.substring(0, lexerToken.begin + n) + string3 + string.substring(lexerToken.end + n));
                    n = string3.length() - (lexerToken.end - lexerToken.begin);
                }
                for (String string4 : DBUtil.getConnectionResolver().getConnNames()) {
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(string4);
                    String string5 = (String)properties.get("ConnName");
                    if (string5 == null) {
                        string5 = string4.substring(string4.indexOf("%23") + 3);
                    }
                    if (!string2.equalsIgnoreCase(string5)) continue;
                    try {
                        Object object;
                        Object object2;
                        Statement statement = connection.createStatement();
                        String string6 = "sid";
                        Object object3 = properties.get(string6);
                        if (object3 == null) {
                            string6 = "serviceName";
                            object3 = properties.get(string6);
                            string6 = "service_name";
                            if (object3 == null) {
                                return;
                            }
                        }
                        if ((object2 = properties.get("password")) == null) {
                            JPasswordField jPasswordField = new JPasswordField(10);
                            int n2 = JOptionPane.showConfirmDialog(null, jPasswordField, "Enter Password for " + string2, 2);
                            if (n2 < 0) {
                                return;
                            }
                            object2 = new String(jPasswordField.getPassword());
                        }
                        boolean bl2 = false;
                        Object object4 = properties.get("user");
                        Object object5 = properties.get("hostname");
                        Object object6 = properties.get("port");
                        String string7 = "select 'USER='||username||host from user_db_links where db_link like '" + string3 + ".%' or db_link = '" + string3 + "'";
                        String string8 = DBUtil.getInstance(connection).executeReturnOneCol(string7);
                        if (string8 != null) {
                            bl2 = true;
                            object = LexerToken.parse(string8);
                            String string9 = null;
                            String string10 = null;
                            String string11 = null;
                            String string12 = null;
                            Iterator<LexerToken> iterator = object.iterator();
                            while (iterator.hasNext()) {
                                LexerToken lexerToken2 = iterator.next();
                                if ("=".equals(lexerToken2.content)) continue;
                                if ("".equals(string9)) {
                                    string9 = lexerToken2.content;
                                    continue;
                                }
                                if ("".equals(string10)) {
                                    string10 = lexerToken2.content;
                                    continue;
                                }
                                if ("".equals(string11)) {
                                    string11 = lexerToken2.content;
                                    continue;
                                }
                                if ("".equals(string12)) {
                                    string12 = lexerToken2.content;
                                    continue;
                                }
                                if ("USER".equals(lexerToken2.content)) {
                                    string9 = "";
                                    continue;
                                }
                                if ("HOST".equals(lexerToken2.content)) {
                                    string10 = "";
                                    continue;
                                }
                                if ("PORT".equals(lexerToken2.content)) {
                                    string11 = "";
                                    continue;
                                }
                                if (!string6.toUpperCase().equals(lexerToken2.content)) continue;
                                string12 = "";
                            }
                            System.out.println(string9 + " " + string10 + " " + string11 + " " + string12 + " ");
                            if (!(object4.equals(string9) && object5.equals(string10) && object6.equals(string11) && object3.equals(string12))) {
                                scriptRunnerContext.write("Name conflict: Database link " + string3 + " already exists");
                            }
                        }
                        if (bl2) continue;
                        object = "CREATE DATABASE LINK " + string3 + " \n" + "CONNECT TO " + object4 + " IDENTIFIED BY " + object2 + " \n" + "USING '(DESCRIPTION =(ADDRESS_LIST =(ADDRESS = (PROTOCOL = TCP)(HOST = " + object5 + ")(PORT = " + object6 + ")))(CONNECT_DATA = (" + string6.toUpperCase() + " = " + object3 + "))) '";
                        statement.execute((String)object);
                        this.links.add(string3);
                        scriptRunnerContext.write("Temporary Database Link " + string3 + " created\n");
                    }
                    catch (Exception exception) {
                        scriptRunnerContext.write("CREATE DATABASE LINK failed: " + exception.getMessage());
                    }
                }
            }
            bl = false;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext != null && scriptRunnerContext.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        try {
            if (Boolean.TRUE.equals(autoDbLinksAtConnection.get(connection)) && connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.cleanLinks(connection, scriptRunnerContext);
    }

    private void cleanLinks(Connection connection, ScriptRunnerContext scriptRunnerContext) {
        if (this.links != null) {
            for (String string : this.links) {
                try {
                    Statement statement = connection.createStatement();
                    String string2 = "DROP DATABASE LINK " + string;
                    statement.execute(string2);
                    scriptRunnerContext.write("Temporary Database Link " + string + " dropped\n");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 2018) {
                        scriptRunnerContext.write(sQLException.getMessage() + ": most likely you have an open query result set (grid)");
                        continue;
                    }
                    scriptRunnerContext.write(sQLException.getMessage());
                }
                catch (Exception exception) {
                    scriptRunnerContext.write(exception.getMessage());
                }
            }
        }
        this.links = new HashSet<String>();
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        List<LexerToken> list;
        String string = iSQLCommand.getSql();
        if (string.length() < 50 && 2 < (list = LexerToken.parse(string)).size() && "set".equals(list.get((int)0).content.toLowerCase()) && list.get((int)1).content.toLowerCase().startsWith("autodblink")) {
            String string2 = list.get((int)2).content.toLowerCase();
            scriptRunnerContext.write("autodblink =" + string2);
            if ("on".equals(string2)) {
                autoDbLinksAtConnection.put(connection, Boolean.TRUE);
            } else if ("off".equals(string2)) {
                autoDbLinksAtConnection.put(connection, Boolean.FALSE);
            }
            return true;
        }
        return false;
    }
}

