/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetSQLFormat
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setsqlformat")) {
            String[] stringArray = iSQLCommand.getSQLOrig().split(" ");
            if (stringArray.length < 3 || stringArray.length == 3 && stringArray[2].equalsIgnoreCase("default")) {
                scriptRunnerContext.write(Messages.getString("SQLFORMATCLEARED"));
                scriptRunnerContext.putProperty("sql.format", null);
                return true;
            }
            String string = stringArray[2];
            if (FormatRegistry.getFormatter(string) == null) {
                scriptRunnerContext.write(Messages.getString("SQLFORMATBAD"));
            }
            scriptRunnerContext.putProperty("sql.format", stringArray[2]);
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = null;
        string = scriptRunnerContext.getProperties().containsKey("sql.format") && scriptRunnerContext.getProperties().get("sql.format") != null ? (String)scriptRunnerContext.getProperties().get("sql.format") : "Default";
        scriptRunnerContext.write("");
        scriptRunnerContext.write(MessageFormat.format(Messages.getString("SQLFORMAT"), string) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"sqlformat"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

