/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetConcat
extends CommandListener
implements IShowCommand {
    private static final String CONCAT = "set con";
    private static final String CONCAT_ON = "on";
    private static final String CONCAT_OFF = "off";
    private static final String[] aliases = new String[]{"concat", "conca", "conc", "con"};

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim().toLowerCase();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith(CONCAT) && !string.substring(string.lastIndexOf(" ")).trim().equals(CONCAT_OFF)) {
            Character c;
            String string2 = string.substring(string.lastIndexOf(" ")).trim();
            if (string.replaceFirst("set con[^\\s]*", "").trim().equals("")) {
                scriptRunnerContext.write(Messages.getString("NO_ESCAPE_VAL"));
                return true;
            }
            if (!string2.equals(CONCAT_ON)) {
                String string3 = this.validString(string2, scriptRunnerContext);
                if (string3 == null) {
                    return true;
                }
                c = Character.valueOf(string3.charAt(0));
            } else {
                c = Character.valueOf('.');
            }
            scriptRunnerContext.setSubstitutionTerminateChar(c);
            return true;
        }
        if (string.startsWith(CONCAT)) {
            scriptRunnerContext.setSubstitutionTerminateChar(null);
            return true;
        }
        return false;
    }

    public String validString(String string, ScriptRunnerContext scriptRunnerContext) {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            scriptRunnerContext.write(Messages.getString("NO_ESCAPE_VAL"));
            return null;
        }
        if (string2.equals("\"\"\"\"") || string2.equals("'\"'")) {
            return "\"";
        }
        if (string2.equals("''''") || string2.equals("\"'\"")) {
            return "'";
        }
        if ((string2 = this.removeQuotesString(string2)).length() > 1) {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("ONE_CHARACTER"), string2));
            return null;
        }
        if (string2.equals("") || string2.equals("\"") || string2.equals("'")) {
            scriptRunnerContext.write(Messages.getString("INVALID_ESCAPE"));
            return null;
        }
        if (string2.matches("^\\s") || string2.matches("^\\w") && !string2.startsWith("_") || string2.matches("^\\d")) {
            scriptRunnerContext.write(Messages.getString("NOT_ALHA_OR_WHITE"));
            return null;
        }
        return string2.substring(0, 1);
    }

    public String removeQuotesString(String string) {
        if (string.startsWith("'") && string.endsWith("'") && string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public String[] getShowAliases() {
        return aliases;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Character c = scriptRunnerContext.getSubstitutionTerminateChar();
        if (c != null) {
            String string = String.valueOf(c);
            String string2 = "concat \"{0}\" (hex {1})";
            scriptRunnerContext.write(MessageFormat.format(string2, string, String.format("%x", scriptRunnerContext.getEscapeChar())) + "\n");
        } else {
            scriptRunnerContext.write("concat OFF\n");
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

