/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.net.ns.NSProtocol;

public class PingCmd
extends CommandListener
implements IHelp {
    public static long UNKNOWN = -2L;
    public static long DOWN = -1L;
    private static Logger LOGGER = Logger.getLogger(PingCmd.class.getName());
    private static Class<? extends NSProtocol> s_protCls;

    @Override
    public String getCommand() {
        return "TNSPING";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (PingCmd.matches("tnsping", iSQLCommand.getSql())) {
            String string;
            String string2 = string = iSQLCommand.getSql().indexOf(" ") > 0 ? iSQLCommand.getSql().substring(iSQLCommand.getSql().indexOf(" ")).trim() : null;
            if (string != null) {
                scriptRunnerContext.write(" ping:" + PingCmd.ping(scriptRunnerContext, string) + "ms\n");
            } else {
                scriptRunnerContext.write(this.getHelp());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long ping(ScriptRunnerContext scriptRunnerContext, String string) {
        long l = UNKNOWN;
        String string2 = null;
        long l2 = System.currentTimeMillis();
        Properties properties = new Properties();
        properties.put("oracle.net.CONNECT_TIMEOUT", "2000");
        String string3 = null;
        String string4 = string;
        string3 = string4.indexOf("jdbc") == 0 ? string4.substring(string4.indexOf("@")) : string;
        NSProtocol nSProtocol = PingCmd.createProtocolInstance();
        if (nSProtocol != null) {
            try {
                try {
                    nSProtocol.connect(string3, properties);
                }
                catch (Exception exception) {
                    String string5 = exception.getLocalizedMessage();
                    int n = string5.indexOf("ORA-");
                    if (n > 0) {
                        string2 = string5 = string5.substring(n);
                        scriptRunnerContext.write(string5 + "\n");
                    }
                    l = DOWN;
                    throw exception;
                }
                l = System.currentTimeMillis() - l2;
            }
            catch (Exception exception) {
                LOGGER.finest(exception.getMessage());
            }
            finally {
                if (nSProtocol != null) {
                    try {
                        nSProtocol.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return l;
    }

    private static NSProtocol createProtocolInstance() {
        if (s_protCls == null) {
            try {
                s_protCls = Class.forName("oracle.net.ns.NSProtocolStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                s_protCls = NSProtocol.class;
            }
        }
        NSProtocol nSProtocol = null;
        if (s_protCls != null) {
            try {
                nSProtocol = s_protCls.newInstance();
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getMessage());
            }
        }
        return nSProtocol;
    }
}

