/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;

public class Column
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String CMD = "\\b(?i:co(?:l\\b|lu\\b|lum\\b|lumn\\b))";
    private static final String CLEAR = "\\b(?i:cl(?:e\\b|ea\\b|ear\\b))";
    private static final String ONOROFF = "\\b(?i:on)|(?i:off)\\b";
    private static final String ON = "\\b(?i:on)\\b";
    private static final String OFF = "\\b(?i:off)\\b";
    private static final String WRAPPED = "(?i:wr(?:a|ap|app|appe|apped))";
    private static final String WORD_WRAPPED = "(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))";
    private static final String TRUNCATED = "(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated))";
    private static final String WRAP = "\\b(?:(?i:wr(?:a|ap|app|appe|apped))|(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))|(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated)))\\b";
    private static final String PRINT = "(?i:pr(?:i|in|int))";
    private static final String NPRINT = "(?i:nopr(?:i|in|int))";
    private static final String PRNT = "\\b(?:(?i:pr(?:i|in|int))|(?i:nopr(?:i|in|int)))\\b";
    private static final String FORMAT = "\\b(?i:fo(?:r|rm|rma|rmat))\\b";
    private static final String HEADING = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b";
    private static final String LEFT = "(?i:l(?:|e|ef|eft))";
    private static final String CENTER = "(?i:c(?:|e|en|ent|ente|entr|enter|entre))";
    private static final String RIGHT = "(?i:r(?:|i|ig|igh|ight))";
    private static final String JUSTIFY = "\\b(?i:ju(?:s|st|sti|stif|stify))\\s+(?:(?i:l(?:|e|ef|eft))|(?i:c(?:|e|en|ent|ente|entr|enter|entre))|(?i:r(?:|i|ig|igh|ight)))\\b";
    private static final String NULL = "\\b(?i:nu(?:l|ll))\\b";
    private static final String NEWVAL = "\\b(?i:new_(?:v|va|val|value))\\b";
    private static final String HEADVAL_PTRN = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b\\s+('|\").+('|\")";
    private static final String FOLD_BEFORE = "\\b(?i:fold_b(?:|e|ef|efo|efor|efore))\\b";
    private static final String FOLD_AFTER = "\\b(?i:fold_a(?:|f|ft|fte|fter))\\b";
    private static final String[] SHOWCOLUMN = new String[]{"column"};

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        String[] stringArray = string.split("\\s+");
        if (stringArray[0].matches(CMD)) {
            HashMap<String, ArrayList<String>> hashMap = scriptRunnerContext.getStoredFormatCmds();
            if (stringArray.length <= 2) {
                if (stringArray.length == 1) {
                    this.printAllColumns(scriptRunnerContext, hashMap);
                } else {
                    this.printColumn(scriptRunnerContext, hashMap, stringArray[1].trim());
                }
            } else {
                this.addOrRemoveColumnCommand(scriptRunnerContext, string);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addOrRemoveColumnCommand(ScriptRunnerContext scriptRunnerContext, String string) {
        block41: {
            HashMap<String, ArrayList<String>> hashMap = scriptRunnerContext.getStoredFormatCmds();
            ArrayList<String> arrayList = new ArrayList<String>();
            Pattern pattern = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                arrayList.add(matcher.group());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            if (stringArray.length < 3) break block41;
            String string2 = stringArray[1].toLowerCase();
            ArrayList<Object> arrayList2 = null;
            arrayList2 = hashMap.get(string2) != null ? hashMap.get(string2) : new ArrayList();
            for (int i = 2; i < stringArray.length; ++i) {
                String string3;
                block40: {
                    Object object;
                    block47: {
                        block45: {
                            block46: {
                                block44: {
                                    block43: {
                                        block42: {
                                            string3 = "";
                                            if (!stringArray[i].matches(CLEAR)) break block42;
                                            if (hashMap.containsKey(string2)) {
                                                hashMap.remove(string2);
                                                arrayList2 = null;
                                                continue;
                                            }
                                            break block40;
                                        }
                                        if (!stringArray[i].matches(NEWVAL)) break block43;
                                        object = scriptRunnerContext.getColumnMap();
                                        object.put((String)string2.toUpperCase(), (String)stringArray[++i].toUpperCase());
                                        break block40;
                                    }
                                    if (!stringArray[i].matches(ONOROFF)) break block44;
                                    if (stringArray[i].matches(ON)) {
                                        this.removeItem(arrayList2, "off");
                                        break block40;
                                    } else if (stringArray[i].matches(OFF) && !((String)arrayList2.get(0)).equalsIgnoreCase(stringArray[i])) {
                                        arrayList2.add(0, stringArray[i]);
                                    }
                                    break block40;
                                }
                                if (!stringArray[i].matches(WRAP)) break block45;
                                if (arrayList2.contains("wrapped")) {
                                    this.removeItem(arrayList2, "wrapped");
                                } else if (arrayList2.contains("word_wrapped")) {
                                    this.removeItem(arrayList2, "word_wrapped");
                                } else if (arrayList2.contains("truncated")) {
                                    this.removeItem(arrayList2, "truncated");
                                }
                                if (!stringArray[i].matches(WRAPPED)) break block46;
                                string3 = "wrapped";
                                break block40;
                            }
                            if (stringArray[i].matches(WORD_WRAPPED)) {
                                string3 = "word_wrapped";
                                break block40;
                            } else if (stringArray[i].matches(TRUNCATED)) {
                                string3 = "truncated";
                            }
                            break block40;
                        }
                        if (!stringArray[i].matches(PRNT)) break block47;
                        if (arrayList2.contains("noprint")) {
                            this.removeItem(arrayList2, "noprint");
                        } else {
                            this.removeItem(arrayList2, "print");
                        }
                        if (stringArray[i].matches(PRINT)) {
                            string3 = "print";
                            break block40;
                        } else if (stringArray[i].matches(NPRINT)) {
                            string3 = "noprint";
                        }
                        break block40;
                    }
                    if (stringArray[i].matches(FORMAT) || stringArray[i].matches(HEADING) || i + 1 < stringArray.length && (stringArray[i] + " " + stringArray[i + 1]).matches(JUSTIFY) || stringArray[i].matches(NULL)) {
                        this.removeItem(arrayList2, stringArray[i]);
                        if (i == stringArray.length - 1) {
                            string3 = stringArray[i];
                        } else {
                            if (stringArray[i].matches(FORMAT)) {
                                object = stringArray[i + 1];
                                if (!((String)object).matches("(?i:a)\\d+") && !this.isValidColFormat((String)object)) {
                                    scriptRunnerContext.write(MessageFormat.format(Messages.getString("ILLEGAL_COLFORMAT"), object) + m_lineSeparator);
                                    return;
                                }
                                string3 = "format ";
                            } else if (stringArray[i].matches(HEADING)) {
                                string3 = "heading ";
                            } else if ((stringArray[i] + " " + stringArray[i + 1]).matches(JUSTIFY)) {
                                string3 = "justify ";
                            } else if (stringArray[i].matches(NULL)) {
                                string3 = "null ";
                            }
                            object = stringArray[++i];
                            if (string3.startsWith("justify")) {
                                if (((String)object).matches(LEFT)) {
                                    object = "left";
                                } else if (((String)object).matches(CENTER)) {
                                    object = "center";
                                } else if (((String)object).matches(RIGHT)) {
                                    object = "right";
                                }
                            }
                            object = ((String)object).replaceAll("['\"]", "");
                            string3 = string3 + (String)object;
                        }
                    } else {
                        if (!stringArray[i].matches(FOLD_AFTER) && !stringArray[i].matches(FOLD_BEFORE)) {
                            scriptRunnerContext.write(MessageFormat.format(Messages.getString("UNKNOWN_COLOPTION"), stringArray[i]) + m_lineSeparator);
                            return;
                        }
                        scriptRunnerContext.write(Messages.getString("FOLD_BEFORE_AFTER_NOTSUPPORTED") + m_lineSeparator);
                    }
                }
                if (string3.equals("")) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                arrayList2.add(string3);
            }
            if (arrayList2 != null) {
                hashMap.put(string2, arrayList2);
            }
        }
    }

    private void removeItem(ArrayList<String> arrayList, String string) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).startsWith(string.toLowerCase()) && !arrayList.get(i).equalsIgnoreCase(string)) continue;
                arrayList.remove(i);
                break;
            }
        }
    }

    private void printAllColumns(ScriptRunnerContext scriptRunnerContext, HashMap<String, ArrayList<String>> hashMap) {
        if (hashMap != null) {
            for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet()) {
                this.print(scriptRunnerContext, entry);
            }
        }
    }

    private void printColumn(ScriptRunnerContext scriptRunnerContext, HashMap<String, ArrayList<String>> hashMap, String string) {
        if (string.length() > 0) {
            for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet()) {
                if (!entry.getKey().equals(string)) continue;
                this.print(scriptRunnerContext, entry);
                return;
            }
            if (this.validColumnName(string)) {
                scriptRunnerContext.write(MessageFormat.format(Messages.getString("COLUMN_NOTDEFINED"), string) + m_lineSeparator + m_lineSeparator);
            } else {
                scriptRunnerContext.write(MessageFormat.format(Messages.getString("Column.0"), string) + m_lineSeparator);
            }
        }
    }

    private boolean validColumnName(String string) {
        return string.matches("[A-Za-z0-9]+") || string.matches("[A-Za-z_$#0-9]+");
    }

    private void print(ScriptRunnerContext scriptRunnerContext, Map.Entry<String, ArrayList<String>> entry) {
        if (scriptRunnerContext != null && entry != null) {
            String string = "";
            String string2 = "";
            String string3 = entry.getKey();
            ArrayList<String> arrayList = entry.getValue();
            boolean bl = scriptRunnerContext.getColumnMap().containsKey(string3.toUpperCase());
            if (arrayList.size() > 0 || bl) {
                String string4 = "";
                if (arrayList.size() > 0) {
                    string4 = arrayList.get(0);
                } else if (bl) {
                    string4 = "ON";
                }
                string = string4.equalsIgnoreCase("off") ? "COLUMN  '" + string3 + "'" + " OFF" + m_lineSeparator : "COLUMN  '" + string3 + "'" + " ON" + m_lineSeparator;
            }
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5 = arrayList.get(i);
                if (string5.equalsIgnoreCase("off")) continue;
                String[] stringArray = string5.split("\\s+");
                if (stringArray.length > 1) {
                    if (stringArray[0].equalsIgnoreCase("heading")) {
                        string = string + stringArray[0].toUpperCase().trim() + "  " + "'" + string5.replaceFirst(HEADING, "").trim() + "'";
                        string = string + m_lineSeparator;
                        continue;
                    }
                    if (stringArray[0].equalsIgnoreCase("justify")) {
                        string2 = string2 + stringArray[0].toUpperCase().trim() + " " + stringArray[1] + " ";
                        continue;
                    }
                    string = string + stringArray[0].toUpperCase().trim() + "  " + stringArray[1] + m_lineSeparator;
                    continue;
                }
                string2 = stringArray[0].equalsIgnoreCase("word_wrapped") ? string2 + "word_wrap " : (stringArray[0].equalsIgnoreCase("wrapped") ? string2 + "wrap " : (stringArray[0].equalsIgnoreCase("truncated") ? string2 + "truncate " : string2 + stringArray[0] + " "));
            }
            if (scriptRunnerContext.getColumnMap().containsKey(string3.toUpperCase())) {
                string = string + "NEW_VALUE  " + scriptRunnerContext.getColumnMap().get(string3.toUpperCase()) + m_lineSeparator;
            }
            if (!string.endsWith(m_lineSeparator)) {
                string = string + m_lineSeparator;
            }
            scriptRunnerContext.write(string);
        }
    }

    boolean isValidColFormat(String string) {
        boolean bl = true;
        String string2 = "";
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, '9');
        if (string.matches("(?i:x)+")) {
            try {
                Integer.parseInt(String.copyValueOf(cArray), 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string.matches("(?i:(?:tm)(?:|9|e)|rn|9+(d|v)9+)")) {
            return true;
        }
        try {
            String string3 = string.replaceAll("[^0-9\\.]", "");
            NUMBER nUMBER = new NUMBER((Object)string3);
            string2 = nUMBER.toFormattedText(string, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public String[] getShowAliases() {
        return SHOWCOLUMN;
    }

    @Override
    public boolean handleShow(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if ((scriptRunnerContext.getCurrentConnection() == null || scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) && scriptRunnerContext.getStoredFormatCmds() != null && scriptRunnerContext.getStoredFormatCmds().size() != 0) {
            String string = (String)scriptRunnerContext.getProperty("script.runner.optional_show_header");
            if (string != null && !string.equals("")) {
                scriptRunnerContext.write(string);
            }
            SQLCommand sQLCommand = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_COLUMN, SQLCommand.StmtResultType.G_R_NONE, false);
            sQLCommand.setOrigSQL("column");
            sQLCommand.setSql("column");
            return this.handleEvent(connection, scriptRunnerContext, sQLCommand);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

