/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;

public class Accept
extends CommandListener {
    private ScriptRunnerContext m_ctx = null;
    private Connection m_conn = null;

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        this.m_ctx = scriptRunnerContext;
        this.m_conn = connection;
        this.runAccept(iSQLCommand);
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    private void runAccept(ISQLCommand iSQLCommand) {
        boolean bl = false;
        String[] stringArray = iSQLCommand.getSQLOrig().trim().split("\\s+");
        if (stringArray.length == 1 && stringArray[0].toLowerCase().equals("accept")) {
            this.write("SP2-0002: ACCEPT statement must specify a variable name\n", this.m_ctx);
            return;
        }
        iSQLCommand.setSql(SQLPLUS.removeDashNewline(iSQLCommand, iSQLCommand.getSql()));
        String[] stringArray2 = this.nextWordAndRest(iSQLCommand.getSql());
        if (!stringArray2[1].trim().equals("")) {
            String string;
            String string22;
            String string3 = "";
            String string4 = "";
            stringArray2 = this.nextWordAndRest(stringArray2[1]);
            string3 = stringArray2[0].toUpperCase();
            string4 = stringArray2[1].trim();
            String string5 = string4.toUpperCase();
            if (string5.endsWith("HIDE") && string5.length() > 4) {
                string5 = string5.substring(0, string5.length() - 4).trim();
                string4 = string4.substring(0, string4.length() - 4).trim();
                bl = true;
            }
            for (String string22 : new String[]{"NOPROMPT", "NOPROMP", "NOPROM", "NOPRO", "NOPR"}) {
                if (!string5.endsWith(string22) || string5.length() <= string22.length()) continue;
                string5 = string5.substring(0, string5.length() - string22.length()).trim();
                string4 = string4.substring(0, string4.length() - string22.length()).trim();
                break;
            }
            int n = string5.indexOf("PROMPT");
            String string6 = "";
            int n2 = 0;
            if (n != -1) {
                stringArray2 = this.nextWordAndRest(string4.substring(n));
                if (stringArray2[1] == "") {
                    this.write(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.getString("PROMPT_STRING_NOT_FOUND"), this.m_ctx), this.m_ctx);
                    n2 = 1;
                } else {
                    string6 = stringArray2[1].trim();
                    int n3 = -1;
                    n3 = string6.toUpperCase().indexOf("DEF");
                    if (n3 < 0) {
                        n3 = string6.toUpperCase().indexOf("DEFA");
                    }
                    if (n3 < 0) {
                        n3 = string6.toUpperCase().indexOf("DEFAU");
                    }
                    if (n3 < 0) {
                        n3 = string6.toUpperCase().indexOf("DEFAUL");
                    }
                    if (n3 < 0) {
                        n3 = string6.toUpperCase().indexOf("DEFAULT");
                    }
                    if (n3 != -1) {
                        string6 = string6.substring(0, n3);
                    }
                    string6 = string6.replaceAll("['\"]", "");
                }
                if (n > 0) {
                    string5 = string5.substring(0, n).trim();
                    string4 = string4.substring(0, n).trim();
                } else {
                    string5 = string5.replaceAll("(?i:prompt)", "").trim();
                    string4 = string4.replaceAll("(?i:prompt)", "").trim();
                }
            }
            string22 = "";
            if (n2 == 0 && (n = string5.indexOf("DEFAULT")) != -1) {
                stringArray2 = this.nextWordAndRest(string4.substring(n));
                string4 = string4.substring(0, n).trim();
                if (stringArray2[1].equals("")) {
                    this.write(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.getString("PROMPT_STRING_NOT_FOUND"), this.m_ctx), this.m_ctx);
                    n2 = 1;
                } else {
                    string22 = stringArray2[1].trim();
                    string22 = string22.replaceAll("['\"]", "");
                }
            }
            String string7 = null;
            if (n2 == 0 && (n = (string5 = (string4 = string4.trim()).toUpperCase()).indexOf("FORMAT")) != -1) {
                stringArray2 = this.nextWordAndRest(string4.substring(n));
                string4 = string4.substring(0, n).trim();
                if (stringArray2[1].equals("")) {
                    this.write(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.getString("PROMPT_STRING_NOT_FOUND"), this.m_ctx), this.m_ctx);
                    n2 = 1;
                } else {
                    string7 = stringArray2[1].trim();
                    if (string7.startsWith("\"") && string7.endsWith("\"") && string7.length() > 1) {
                        string7 = string7.substring(1, string7.length() - 1);
                    } else if (string7.startsWith("'") && string7.endsWith("'") && string7.length() > 1) {
                        string7 = string7.substring(1, string7.length() - 1);
                    }
                }
            }
            String string8 = null;
            if (n2 == 0) {
                string5 = (string4 = string4.trim()).toUpperCase();
                string = string5;
                if (string.equals("NUM") || string.equals("NUMB") || string.equals("NUMBE") || string.equals("NUMBER")) {
                    string8 = "NUMBER";
                } else if (string.equals("DATE") || string.equals("BINARY_FLOAT") || string.equals("BINARY_DOUBLE")) {
                    string8 = string;
                }
            }
            if (n2 == 0) {
                string = null;
                boolean bl2 = false;
                Object var16_19 = null;
                if (!this.validateDefaultAndFormat(string22, string7, string8)) {
                    return;
                }
                while (!bl2) {
                    String string9 = null;
                    string9 = string6;
                    string = this.m_ctx.getPromptedFieldProvider().getPromptedField(this.m_ctx, string9, bl);
                    if (string == null) {
                        try {
                            this.m_conn.commit();
                            this.write("Commit", this.m_ctx);
                        }
                        catch (SQLException sQLException) {
                            this.write(ScriptRunnerDbArb.format("ERROR_ON", "Commit"), this.m_ctx);
                        }
                        this.m_ctx.setExited(true);
                        return;
                    }
                    if (string.equals("")) {
                        string = string22;
                    }
                    if ((string == null || string.equals("")) && string7 != null && !string7.equals("")) {
                        this.write("SP2_0598:\"\" does not match input format \"" + string7 + "\"\n", this.m_ctx);
                        continue;
                    }
                    int n4 = 0;
                    n4 = this.acceptValidate(string, string8, string7);
                    bl2 = n4 == 0;
                    var16_19 = null;
                    String string10 = string;
                    if (bl) {
                        string10 = "*********";
                    }
                    if (n4 == 1722 && string7 != null && !string7.equals("")) {
                        this.writeAndFlush("SP2_0598: \"" + string10 + "\" does not match input format \"" + string7 + "\"\n", this.m_ctx);
                    } else if (n4 == -1 || n4 > 0) {
                        this.writeAndFlush(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.getString("ACCEPT_STATEMENT_MUST_SPECIFY"), this.m_ctx), this.m_ctx);
                        return;
                    }
                    Map<String, String> map = this.m_ctx.getMap();
                    map.put(string3, string);
                }
            }
        } else {
            this.write(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.getString("ACCEPT_STATEMENT_MUST_SPECIFY"), this.m_ctx), this.m_ctx);
            this.writeAndFlush("\n", this.m_ctx);
        }
    }

    private void writeAndFlush(String string, ScriptRunnerContext scriptRunnerContext) {
        this.write(string, scriptRunnerContext);
        try {
            this.m_ctx.getOutputStream().flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private boolean validateDefaultAndFormat(String string, String string2, String string3) {
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            return true;
        }
        int n = 0;
        String string4 = string;
        if (string4 == null || string4.equals("")) {
            string4 = string3.toUpperCase().startsWith("DATE") ? "sysdate" : "0";
        }
        if ((n = this.acceptValidate(string4, string3, string2)) > 0) {
            if (n == 1722) {
                if (string2 == null || string2.equals("")) {
                    this.writeAndFlush("SP2-0425: \"" + string4 + "\" is not a valid NUMBER\n", this.m_ctx);
                } else {
                    this.writeAndFlush("SP2-0598: \"" + string4 + "\" does not match input format \"" + string2 + "\" \n", this.m_ctx);
                }
            } else {
                this.writeAndFlush("SP2-0597:\"" + string2 + "\" is not a valid " + string3 + " format\n", this.m_ctx);
            }
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int acceptValidate(String string, String string2, String string3) {
        int n = 0;
        int n2 = -1;
        int n3 = -2;
        try {
            if (string2 == null) {
                if (string3 != null && string3.matches("^[aA][0-9]*$")) {
                    String string4 = string3.replaceAll("^[aA]([0-9]*)$", "$1");
                    Integer n4 = null;
                    try {
                        n4 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return n2;
                    }
                    if (!string.matches(".{0," + n4 + "}")) return n2;
                    return n;
                }
                if (string3 == null) return 0;
                if (string3.matches("^[aA][0-9]*$")) return 0;
                return n2;
            }
            DBUtil dBUtil = DBUtil.getInstance(this.m_ctx.getCurrentConnection());
            HashMap hashMap = new HashMap();
            ResultSet resultSet = null;
            Statement statement = null;
            boolean bl = false;
            String string5 = null;
            try {
                bl = DBUtil.getConnectionResolver().lock(this.m_ctx.getCurrentConnection());
                if (!bl) {
                    int n5 = n2;
                    return n5;
                }
                if (string3 != null && !string3.equals("")) {
                    statement = this.m_ctx.getCurrentConnection().prepareStatement("select TO_CHAR(TO_" + string2 + "(:v,:f)) from dual");
                    statement.setString(1, string);
                    statement.setString(2, string3);
                } else {
                    statement = this.m_ctx.getCurrentConnection().prepareStatement("select TO_CHAR(TO_" + string2 + "(:v)) from dual");
                    statement.setString(1, string);
                }
                resultSet = statement.executeQuery();
                if (!resultSet.next()) return n;
                string5 = resultSet.getString(1);
                if (string5 != null && !string5.equals(null)) {
                    if (!string5.equals("")) return n;
                }
                if (string == null) return n;
                if (string.equals("")) return n;
                int n6 = n3;
                return n6;
            }
            catch (SQLException sQLException) {
                String string6 = sQLException.getMessage();
                if (string6 == null) {
                    int n7 = n2;
                    return n7;
                }
                int n8 = string6.indexOf(10);
                if (n8 != -1) {
                    string6 = string6.substring(0, n8);
                }
                if (!string6.matches("^[oO][rR][aA]-[0-9]*.*")) {
                    int n9 = n2;
                    return n9;
                }
                Integer n10 = null;
                try {
                    n10 = Integer.parseInt(string6.replaceAll("^[oO][rR][aA]-([0-9]*).*", "$1"));
                }
                catch (NumberFormatException numberFormatException) {
                    int n11 = n2;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!bl) return n11;
                    try {
                        DBUtil.getConnectionResolver().unlock(this.m_ctx.getCurrentConnection());
                        return n11;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n11;
                }
                if (n10 == 1481 || n10 > 1809 && n10 < 1830) {
                    int n12 = n10;
                    return n12;
                }
                if (n10 != null && n10 == 1722) {
                    int n13 = n10;
                    return n13;
                }
                int n14 = n2;
                return n14;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    try {
                        DBUtil.getConnectionResolver().unlock(this.m_ctx.getCurrentConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            return n2;
        }
    }

    private String[] nextWordAndRest(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                bl = !bl;
            }
            if (!Character.isWhitespace(string.charAt(n)) || bl) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            string2 = string.substring(n).trim();
            string3 = string.substring(0, n);
        } else {
            string3 = string;
        }
        String[] stringArray = new String[]{string3, string2};
        return stringArray;
    }

    public void write(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        try {
            ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
            ((BufferedOutputStream)wrapListenBufferOutputStream).flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }
}

