/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.util.Service;

public class ScriptUtils {
    protected static final Logger LOGGER = Logger.getLogger(ScriptUtils.class.getName());
    public static final int EXIT = 4;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    public static final String EXECUTEFAILED = "EXECUTEFAILED";

    public static String[] executeArgs(String string) throws ArgumentQuoteException {
        Matcher matcher;
        boolean bl;
        if (string == null) {
            return null;
        }
        if (string.replaceAll("^\\s+$", "").equals("")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string = " " + string;
        Pattern pattern = Pattern.compile("\\s");
        while (bl = (matcher = pattern.matcher(string)).find()) {
            int n;
            if ((string = string.substring(matcher.start()).trim()).startsWith("'")) {
                n = 1;
                while ((n = string.indexOf("'", n)) != -1 && string.substring(n).startsWith("''")) {
                    n += 2;
                }
                if (n == -1) {
                    throw new ArgumentQuoteException("'");
                }
                arrayList.add(string.substring(1, n).replaceAll("''", "'"));
                if (string.length() <= n + 1) break;
                string = " " + string.substring(n + 1);
                continue;
            }
            if (string.startsWith("\"")) {
                n = 1;
                while ((n = string.indexOf("\"", n)) != -1 && string.substring(n).startsWith("\"\"")) {
                    n += 2;
                }
                if (n == -1) {
                    throw new ArgumentQuoteException("\"");
                }
                arrayList.add(string.substring(1, n).replaceAll("\"\"", "\""));
                if (string.length() <= n + 1) break;
                string = " " + string.substring(n + 1);
                continue;
            }
            matcher = pattern.matcher(string);
            bl = matcher.find();
            if (!bl) {
                if (string.equals("")) break;
                arrayList.add(string);
                break;
            }
            n = matcher.start();
            arrayList.add(string.substring(0, n));
            string = string.substring(n);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static void report(String string, BufferedOutputStream bufferedOutputStream) {
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.write((string + "\n").getBytes("UTF-8"));
                bufferedOutputStream.flush();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public static void doWhenever(ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, Connection connection, boolean bl) {
        iSQLCommand.setProperty(EXECUTEFAILED, EXECUTEFAILED);
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        int n = 0;
        n = bl ? scriptRunnerContext.getSqlError() : scriptRunnerContext.getOsError();
        int n2 = n & 3;
        if (n2 == 2) {
            if (connection != null) {
                try {
                    connection.rollback();
                    ScriptUtils.report("Rollback", wrapListenBufferOutputStream);
                }
                catch (SQLException sQLException) {
                    ScriptUtils.report(ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), wrapListenBufferOutputStream);
                }
            }
        } else if (n2 == 1 && connection != null) {
            try {
                connection.commit();
                ScriptUtils.report("Commit", wrapListenBufferOutputStream);
            }
            catch (SQLException sQLException) {
                ScriptUtils.report(ScriptRunnerDbArb.format("ERROR_ON", "Commit"), wrapListenBufferOutputStream);
            }
        }
        if ((n & 4) == 4) {
            scriptRunnerContext.setExited(true);
            scriptRunnerContext.putProperty("script.runner.exit_int", 1);
        }
    }

    public static String[] parseNameAndTypeUtil(String string) {
        Object object;
        int n;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        String string5 = string.length() > 1000 ? string.substring(0, 1000) : string;
        List<LexerToken> list = LexerToken.parse(string5);
        if (list.size() > 1 && "alter".equalsIgnoreCase(list.get((int)0).content)) {
            bl = true;
            n = 0;
            for (int i = 0; i < 20 && i + 1 <= list.size(); ++i) {
                object = list.get((int)i).content;
                if ("compile".equalsIgnoreCase((String)object)) {
                    n = 1;
                }
                if ("resolve".equalsIgnoreCase((String)object)) {
                    n = 1;
                }
                if (!"body".equalsIgnoreCase((String)object)) continue;
                bl2 = true;
            }
            if (n == 0) {
                return null;
            }
        }
        for (n = 0; n < 15 && n < list.size(); ++n) {
            LexerToken lexerToken = list.get(n);
            if (string4 == null && "DECLARE".equalsIgnoreCase(lexerToken.content) || string4 == null && "BEGIN".equalsIgnoreCase(lexerToken.content)) break;
            if (string4 == null && "PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && "PROCEDURE".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && "FUNCTION".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && "TRIGGER".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && "JAVA".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && "TYPE".equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 != null && "BODY".equalsIgnoreCase(lexerToken.content)) {
                string4 = string4 + " " + lexerToken.content.toUpperCase();
                bl2 = false;
                continue;
            }
            if (string4 != null && "SOURCE".equalsIgnoreCase(lexerToken.content)) {
                string4 = string4 + " " + lexerToken.content.toUpperCase();
                continue;
            }
            if ((string4 == null || !bl && string4.startsWith("JAVA") || "BODY".equalsIgnoreCase(lexerToken.content) || string3 != null) && (string4 == null || bl || !string4.startsWith("JAVA") || n <= 1 || list.get(n - 1) == null || list.get((int)(n - 1)).content == null || !list.get((int)(n - 1)).content.equalsIgnoreCase("NAMED") || string3 != null)) continue;
            if (string4.equals("PACKAGE") && bl2) {
                string4 = "PACKAGE BODY";
            }
            if (string4.equals("TYPE") && bl2) {
                string4 = "TYPE BODY";
            }
            if ((string3 = Service.handleMixedCase(lexerToken.content)).equals("[")) {
                object = string5 + " ";
                boolean bl3 = true;
                int n2 = lexerToken.begin + 1;
                int n3 = ((String)object).length() - 1;
                for (int i = lexerToken.begin + 1; i < 1000 && i < ((String)object).length() - 1; ++i) {
                    String string6 = ((String)object).substring(i, i + 1);
                    if (string6.matches("[ \t\r\n]") && !bl3) {
                        n3 = i;
                        break;
                    }
                    if (string6.equals(".") && !bl3) {
                        n2 = i + 1;
                    }
                    if (string6.equals("[")) {
                        bl3 = true;
                        continue;
                    }
                    if (!string6.equals("]")) continue;
                    bl3 = false;
                }
                if (n3 - n2 >= 100 || n3 - n2 <= 0) break;
                string3 = ((String)object).substring(n2, n3).replaceAll("\\[", "").replaceAll("\\]", "");
                break;
            }
            if (list.size() <= n + 2) break;
            object = list.get(n + 1);
            if (!".".equalsIgnoreCase(((LexerToken)object).content)) break;
            string2 = string3;
            LexerToken lexerToken2 = list.get(n + 2);
            string3 = lexerToken2.content.toUpperCase();
            break;
        }
        if (string3 != null && string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        return new String[]{string2, string3, string4};
    }

    public static String eatOneWord(String string) {
        return (string.trim() + " ").replaceAll("^[^\\s]*\\s+", "").trim();
    }

    public static String stripFirstN(String string, int n, boolean bl, boolean bl2) {
        return ScriptUtils.stripFirstN(string, n, bl, false, bl2);
    }

    public static String stripFirstN(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        String string2 = string;
        if (string.length() > n) {
            string2 = string.substring(0, n);
        }
        if (bl) {
            string2 = bl3 ? SQLPLUS.removeDashNewline(string2) : ScriptUtils.checkforContinuationChars(string2);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 != -1) {
            String string3;
            n4 = string2.indexOf("/*", n2);
            n3 = string2.indexOf("--", n2);
            int n5 = 999999;
            int n6 = string2.indexOf("'", n2);
            int n7 = string2.indexOf("\"", n2);
            if (n4 == -1 && n3 == -1) break;
            int n8 = 99999;
            if (n4 != -1) {
                n8 = n4;
            }
            if (n3 != -1 && n3 < n8) {
                n8 = n3;
            }
            if (n5 != -1 && n5 < n8) {
                n8 = n5;
            }
            if (n6 != -1 && n6 < n8) {
                n8 = n6;
            }
            if (n7 != -1 && n7 < n8) {
                n8 = n7;
            }
            if (n4 != -1 && n4 == n8) {
                string3 = string2;
                if ((string2 = string2.replaceFirst("(?s)/\\*.*?\\*/", " ")).equals(string3) || string2.indexOf("/*", n2) == n4) {
                    if (!bl2) break;
                    return null;
                }
                n2 = n4;
            }
            if (n3 != -1 && n3 == n8) {
                string3 = string2;
                if ((string2 = string2.replaceFirst("(?s)--[^\n]*", " ")).equals(string3) || string2.indexOf("--", n2) == n3) {
                    if (!bl2) break;
                    return null;
                }
                n2 = n3;
            }
            if (n8 != n5 && n8 != n7 && n8 != n6) continue;
            break;
        }
        return string2.trim();
    }

    public static String checkforContinuationChars(String string) {
        boolean bl = true;
        if (string.contains("-")) {
            String[] stringArray = string.split("\n");
            StringBuffer stringBuffer = new StringBuffer("");
            String string2 = null;
            if (stringArray.length != 0) {
                int n = 0;
                for (String string3 : stringArray) {
                    ++n;
                    String string4 = string3;
                    StringBuffer stringBuffer2 = new StringBuffer("");
                    if (bl && string4.indexOf("-") != -1 && string4.replaceAll("\\s+$", "").endsWith("-") && !string4.replaceAll("^\\s+", "").startsWith("--")) {
                        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string4);
                        boolean bl2 = false;
                        char c = stringCharacterIterator.last();
                        while (c != '\uffff') {
                            if (c == '-' && !bl2) {
                                stringBuffer2.insert(0, ' ');
                                bl2 = true;
                            } else {
                                stringBuffer2.insert(0, c);
                            }
                            c = stringCharacterIterator.previous();
                        }
                        stringBuffer.append(stringBuffer2);
                        continue;
                    }
                    if (n == 1) {
                        return string;
                    }
                    bl = false;
                    stringBuffer2 = new StringBuffer(string4);
                    stringBuffer.append(stringBuffer2).append(" \n");
                }
                string2 = stringBuffer.toString();
            } else {
                string2 = string;
            }
            if (string2.length() > 2) {
                if (string2.endsWith("\r\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(13));
                } else if (string2.endsWith("\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(10));
                }
            }
            return string2;
        }
        return string;
    }

    public static ConnectionDetails getConnectionDetails(String string) {
        Object var1_1 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl3 = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < string.length(); ++n) {
            if (!Character.isWhitespace(string.charAt(n))) continue;
            bl = true;
            break;
        }
        if (bl) {
            Object object;
            string = string.substring(n).trim();
            String string6 = "";
            if (string != null && !string.equals("")) {
                object = ScriptUtils.separateRole(string);
                string = object[0];
                string5 = object[1];
                boolean bl4 = bl3 = object[2] != null && ((String)object[2]).equals(Boolean.TRUE.toString());
            }
            if (string.startsWith("[") && string.contains("]jdbc:") || string.startsWith("jdbc:")) {
                object = null;
                try {
                    object = new oracle.dbtools.db.ConnectionDetails(string);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage());
                }
                if (object != null && ((oracle.dbtools.db.ConnectionDetails)object).getDriver() != null) {
                    return new ConnectionDetails(bl2, null, null, string, string5, bl3, 1, 1, null);
                }
            }
            string = string.trim();
            int n4 = 0;
            block8: for (int i = 0; i < string.length() && n3 == -1; ++i) {
                switch (string.charAt(i)) {
                    case '\"': {
                        ++n4;
                        continue block8;
                    }
                    case '@': {
                        if (n4 % 2 != 0) continue block8;
                        n3 = i;
                        continue block8;
                    }
                    case '/': {
                        if (n4 % 2 != 0) continue block8;
                        n2 = i;
                        continue block8;
                    }
                }
            }
            if (n2 != -1 && (n3 == -1 || n3 > n2)) {
                string2 = string.substring(0, n2);
                string6 = string.substring(n2 + 1);
                if (string2.equals("")) {
                    bl2 = true;
                }
                if (n3 != -1) {
                    string3 = string.substring(n2 + 1, n3);
                    string4 = string.substring(n3 + 1).trim().replace("\"", "");
                } else {
                    string3 = string6.trim();
                }
                if (string2.trim().equals("") && string3.trim().equals("")) {
                    bl2 = false;
                }
            } else {
                bl2 = true;
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string4 = string.substring(n3 + 1).trim().replace("\"", "");
                } else {
                    string2 = string.trim();
                }
            }
        } else {
            bl2 = true;
        }
        return new ConnectionDetails(bl2, string2, string3, string4, string5, bl3, n3, n2, null);
    }

    private static String[] nextToChar(String string, char c) {
        String string2;
        String string3;
        int n = string.indexOf(c);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string2 = n == string.length() - 1 ? "" : string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        String[] stringArray = new String[]{string3, string2};
        return stringArray;
    }

    private static String getArgument(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string) || i >= stringArray.length - 1) continue;
            return stringArray[i + 1];
        }
        return "";
    }

    private static String[] separateRole(String string) {
        Boolean bl = Boolean.FALSE;
        String string2 = "";
        String string3 = string;
        if (string3 != null && string3.length() > 0) {
            String string4 = string3.toLowerCase();
            String[] stringArray = string4.split("\\s+");
            if (stringArray != null && stringArray.length > 1) {
                for (String string5 : new String[]{"sysoper", "sysdba", "sysbackup", "sysdg", "syskm", "sysasm"}) {
                    if (!stringArray[stringArray.length - 1].equals(string5) || !stringArray[stringArray.length - 2].equals("as")) continue;
                    string2 = "as " + string5;
                    break;
                }
            }
            if (string2.trim().equals("") && stringArray[stringArray.length - 1].toLowerCase().equals("as")) {
                bl = Boolean.TRUE;
            }
            if (!string2.equals("")) {
                String[] stringArray2 = string3.trim();
                stringArray2 = string3.substring(0, string3.length() - 5);
                string3 = stringArray2.substring(0, stringArray2.toLowerCase().lastIndexOf("as")).trim();
            }
        }
        return new String[]{string3, string2, bl.toString()};
    }
}

