/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.IGetHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.SetSpool;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAloneHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAloneHandleSetPauseProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedAcceptProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedSubstitutionProvider;
import oracle.dbtools.raptor.proformatter.ICodingStyleSQLOptions;
import oracle.dbtools.raptor.proformatter.ICoreFormatter;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.util.IExceptionHandler;
import org.fusesource.jansi.Ansi;

public class ScriptRunnerContext
implements IScriptRunnerContext,
Cloneable {
    public static final String CLI_CONN_URL = "cli.conn.url";
    public static final String CLI_CONN_PROPS = "cli.conn.props";
    public static final String SQL_FORMAT = "sql.format";
    public static final String PRE_COMMAND = "pre.command";
    public static final String POST_COMMAND = "post.command";
    public static final String TOTAL_CMD_COUNT = "total_cmd_count";
    public static final String CURRENT_CMD_COUNT = "current_cmd_count";
    public static final String OUT_STREAM_WRAPPER = "output_stream_wrapper";
    public static final int FEEDBACK_ON = -1;
    public static final int FEEDBACK_OFF = -2;
    public static final String LAST_ERR_TYPE = "sqldev.last.err.type";
    public static final String LAST_ERR_NAME = "sqldev.last.err.name";
    public static final String ERR_ANY_CMDS_IN_SCRIPT = "sqldev.error.any.in";
    public static final String ERR_ENCOUNTERED = "sqldev.error";
    public static final String ERR_MESSAGE = "sqldev.last.err.message";
    public static final String ERR_MESSAGE_SQLCODE = "sqldev.last.err.message.forsqlcode";
    public static final String TOP_BASE_URL = "script.runner.topbase.url";
    public static final String BASE_URL = "script.runner.base.url";
    public static final String NODE_URL = "script.runner.node.url";
    public static final String SYSTEM_OUT = "script.runner.using.systemout";
    public static final String DBCONFIG_GLOGIN = "DBConfig.GLOGIN";
    public static final String DBCONFIG_GLOGIN_FILE = "DBConfig.GLOGIN_FILE";
    public static final String DBCONFIG_DEFAULT_PATH = "DBConfig.DEFAULT_PATH";
    public static final String DBCONFIG_USE_THICK_DRIVER = "DBConfig.USE_THICK_DRIVER";
    public static final String SPOOLOUTBUFFER = "Spool.out.buffer";
    public static final String POPUPBINDS = "f9.popup.binds";
    public static final String APPINFO = "script.runner.appinfo";
    public static final String APPINFOARRAYLIST = "script.runner.appinfo.arraylist";
    public static final String ARRAYSIZE = "script.runner.arraysize";
    public static final String AUTOCOMMITCOUNTER = "script.runner.autocommit.counter";
    public static final String AUTOCOMMITSETTING = "script.runner.autocommit.setting";
    public static final String ERR_FOR_AUTOCOMMIT = "script.runner.autocommit.errorFlag";
    public static final String COPYCOMMIT = "script.runner.copycommit";
    public static final String CHECKBOXAUTOCOMMIT = "script.runner.autocommit.checkbox";
    public static final String LASTSETSERVEROUTPUT = "script.runner.lastsetserveroutput";
    public static final String REINIT_ON_EXIT = "script.runner.reinitOnExit";
    public static final String DBMSPUTPUTPANE = "script.runner.dbmsouputpane";
    public static final Long AUTOCOMMITON = new Long(-1L);
    public static final Long AUTOCOMMITOFF = new Long(-2L);
    public static final int VERIFY_OFF = -3;
    public static final int VERIFY_ON = -4;
    public static final int AUTOPRINT_OFF = -5;
    public static final int AUTOPRINT_ON = -6;
    public static final String DBPROPS = "sqldev.script.runner.connection.properties";
    public static final String AUTOTRACE_CTXTRACESTATE = "AUTOTRACE_STATE";
    public static final String AUTOTRACE_CTXTRACETYPE = "AUTOTRACE_TYPE";
    public static final String AUTOTRACE_AUTO_EXPLAIN = "EXPLAIN";
    public static final String AUTOTRACE_AUTO_STAT = "STATISTICS";
    public static final String AUTOTRACE_AUTO_ALL = "ALL";
    public static final String AUTOTRACE_AUTO_NONE = "NONE";
    public static final String SHOWSERVEROUTPUT = "script.runner.context.serveroutput";
    public static final String SHOWTIMING = "script.runner.context.timing";
    public static final String SHOWAUTOPRINT = "script.runner.context.autoprint";
    public static final String SETNULL = "script.runner.setnull";
    public static final String SETNUMWIDTH = "script.runner.setnumwidth";
    public static final String SETNUMFORMAT = "script.runner.setnumformat";
    public static final String SETPAGESIZE = "script.runner.setpagesize";
    public static final String SETLINESIZE = "script.runner.setlinesize";
    public static final String SETLONG = "script.runner.setlong";
    public static final String SETLONGCHUNKSIZE = "script.runner.setlongchunksize";
    public static final String SETCOLSEP = "script.runner.setcolsep";
    public static final String SETHEADING = "script.runner.setheading";
    public static final String SETHEADSEP = "script.runner.setheadsep";
    public static final String SETHEADSEPCHAR = "script.runner.setheadsepchar";
    public static final String SETWRAP = "script.runner.setwrap";
    public static final String SETSOURCEREF = "script.runner.sourceref";
    public static final String SETSCAN = "sql.scan";
    public static final String TTITLE_ON = "ON";
    public static final String TTITLE_OFF = "OFF";
    public static final String BTITLE_ON = "ON";
    public static final String BTITLE_OFF = "OFF";
    public static final String JLINE_SETTING = "script.runner.jline";
    public static final String NOTSYSDBA = "NOTSYSDBA";
    public static final String OPTLFLAG = "SqlCli.optlflag";
    public static final String SETTRIMSPOOL = "script.runner.settrimspool";
    public static final String SETTRIMOUT = "script.runner.settrimout";
    public static final String NOLOG = "script.runner.sqlplus.nolog";
    public static final String SILENT = "script.runner.sqlplus.silent";
    public static final String EXIT_INT = "script.runner.exit_int";
    public static final String SQLPLUS_CMDLINE_LOGIN = "script.runner.cmdline.login";
    public static final String BASECONNECTIONID = "script.runner.connection.id";
    public static final String SUFFIX = "script.runner.file.suffix";
    public static final String SETCOLOR = "script.runner.color.coding";
    public static final String CDPATH = "script.runner.cd_command";
    public static final String RESTRICTLEVEL = "script.runner.restrict_level";
    public static final String SCRIPT_DEPTH = "script.runner.script_depth";
    public static final String LDAPCON = "script.runner.ldapcon";
    public static final String SETNET = "script.runner.setnet";
    public static final String SETNETOVERWRITE = "script.runner.setnetoverwrite";
    public static final String SQLPROMPTTIME = "script.runner.setsqlplustime";
    public static final String SERVEROUTPUTPENDING = "script.runner.serveroutputpending";
    public static final String SET_PAUSE = "script.runner.set_pause";
    public static final String SET_PAUSE_VALUE = "script.runner.set_pause_value";
    public static final String LNO = "script.runner.lno";
    public static final String PNO = "script.runner.pno";
    public static final String PRELIMAUTH = "script.runner.PRELIM_AUTH";
    public static final String OPTIONAL_SHOW_HEADER = "script.runner.optional_show_header";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Connection baseConnection = null;
    private boolean closeConnection = false;
    private boolean topLevel = false;
    private Map<String, String> map = null;
    private Map<String, String> columnMap = null;
    private boolean exited = false;
    private boolean returnExited = false;
    private int osError = 0;
    private int sqlError = 0;
    private boolean escape = false;
    private char escapeChar = (char)92;
    private char substitutionChar = (char)38;
    private boolean substitutionOn = true;
    private boolean scanOn = true;
    private char terminateChar = (char)59;
    private Character substitutionTerminateChar = Character.valueOf('.');
    private URL _lastUrl = null;
    private Map<String, Object> _props = new HashMap<String, Object>();
    private boolean supressOutput = false;
    private int feedback = -1;
    private Object _outputComp;
    private boolean _verify = true;
    private boolean _echo = false;
    private int _autoprint = -5;
    private String _sqlPrompt = "SQL> ";
    private String m_basePrompt = "";
    private Map<String, Bind> varMap = null;
    private PrintWriter _errWriter;
    private IRaptorTaskProgressUpdater m_taskProgressUpdater = null;
    private boolean m_isRunScript = true;
    private Connection m_currentConnection = null;
    private String m_encoding = System.getProperty("file.encoding");
    private static String s_outputEncoding = "UTF-8";
    private boolean dbmsOutputEnable = false;
    private StringBuffer m_dbmsOutput = null;
    private Map<String, String> m_nlsMap = null;
    private boolean m_isConsumerRunning = false;
    private HashMap<String, Savepoint> savepoints = null;
    private HashMap<String, ArrayList<String>> m_formatCmdList = new HashMap();
    private LinkedHashMap<String, ArrayList<String>> m_breakCmdList = new LinkedHashMap();
    private TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> m_computeCmdList = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TopTitle m_tTitle = null;
    private BottomTitle m_bTitle = null;
    private String m_tTitleCmd = "";
    private String m_bTitleCmd = "";
    private boolean m_tTitleFlag = false;
    private boolean m_bTitleFlag = false;
    protected String m_EditorText = "";
    private IGetPromptedFieldProvider m_getPromptedFieldProvider = new StandAlonePromptedAcceptProvider();
    private IGetPromptedFieldProvider m_getSubstitutionFieldProvider = new StandAlonePromptedSubstitutionProvider();
    private IGetPromptedPasswordFieldsProvider m_getPasswordFieldsProvider = new StandAlonePromptedPasswordFieldsProvider();
    private IGetPromptedConnectFieldsProvider m_getConnectFieldsProvider = new StandAlonePromptedConnectFieldsProvider();
    private IGetHandlePauseProvider m_getHandlePauseProvider = new StandAloneHandlePauseProvider();
    private IGetHandlePauseProvider m_getHandleSetPauseProvider = new StandAloneHandleSetPauseProvider();
    private Version cmdlineVersion = new Version("4.1.0");
    ArrayList<ISQLCommand> m_executedCommandList = new ArrayList();
    public int m_scriptStartIndex = 0;
    public int m_scriptEndIndex = 0;
    public Object node = null;
    private IConsoleReader _sqlplusConsoleReader = null;
    private IBuffer _sqlplusBuffer;
    private ICodingStyleSQLOptions _codingStyleSQLOptions;
    private ICoreFormatter _coreFormatter;
    boolean _interrupted = false;
    private static HashMap<String, String> _ddlOptions = new HashMap();

    public ArrayList<ISQLCommand> getExecutedCommandList() {
        return this.m_executedCommandList;
    }

    public void setScriptText(int n, int n2) {
        this.m_scriptStartIndex = n;
        this.m_scriptEndIndex = n2;
    }

    public boolean isRunScript() {
        return this.m_isRunScript;
    }

    public void setIsRunScript(boolean bl) {
        this.m_isRunScript = bl;
    }

    public ScriptRunnerContext() {
        this.reInitClear();
    }

    public void reInitOnExit() {
        Boolean bl;
        if (this.getProperty(JLINE_SETTING) == null) {
            this.putProperty(NOLOG, false);
            if (this.getBaseConnection() != null && this.getCurrentConnection() == null) {
                this.setCurrentConnection(this.getBaseConnection());
            }
        }
        if ((bl = (Boolean)this.getProperty(REINIT_ON_EXIT)) != null && bl.equals(Boolean.FALSE)) {
            this.reInitNoExit();
        } else {
            this.reInitClear();
        }
    }

    public void reInitClear() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.deferredReInitClear();
        }
    }

    public void deferredReInitClear() {
        this.closeConnection = false;
        this.topLevel = false;
        this.map = Collections.synchronizedMap(new HashMap());
        this.varMap = Collections.synchronizedMap(new HashMap());
        this.columnMap = Collections.synchronizedMap(new HashMap());
        this.returnExited = this.exited;
        this.exited = false;
        this.osError = 0;
        this.sqlError = 0;
        this.escape = false;
        this.substitutionChar = (char)38;
        this.substitutionOn = true;
        this.scanOn = true;
        this._errWriter = null;
        if (this.getProperty(SPOOLOUTBUFFER) != null) {
            this.stopSpool();
        }
        this.setFeedback(6);
        this.putProperty(POPUPBINDS, new HashMap());
        this.putProperty(APPINFO, new Boolean(false));
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        this.putProperty(AUTOCOMMITSETTING, AUTOCOMMITOFF);
        this.putProperty(AUTOCOMMITCOUNTER, new Long(0L));
        this.putProperty(COPYCOMMIT, "0");
        this.putProperty(SETPAGESIZE, new Integer(14));
        this.putProperty(SETLINESIZE, new Integer(80));
        this.putProperty(SETLONG, new Integer(80));
        this.putProperty(SETLONGCHUNKSIZE, new Integer(80));
        this.putProperty(SETHEADING, "ON");
        this.putProperty(SETHEADSEP, "ON");
        this.putProperty(SETTRIMOUT, new Boolean(false));
        this.putProperty(SETHEADSEPCHAR, "|");
        this.putProperty(SETWRAP, "ON");
        this.putProperty(SETCOLSEP, " ");
        this.putProperty(SETSCAN, "ON");
        this.putProperty(SET_PAUSE, Boolean.FALSE);
        this.putProperty(SET_PAUSE_VALUE, "");
        this.putProperty(SETNUMWIDTH, new Integer(10));
        this.putProperty(SUFFIX, "sql");
        this.putProperty(SETNUMFORMAT, "");
        this.putProperty(SETSOURCEREF, "");
        String string = "vi";
        String string2 = System.getenv("EDITOR");
        if (string2 != null && !string2.equals("")) {
            string = string2;
        } else if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            string = "notepad";
        }
        this.getMap().put(SqlplusVariable._EDITOR.toString(), string);
        this.putProperty(SETCOLOR, "OFF");
        this.putProperty(SQLPROMPTTIME, "OFF");
        this.putProperty(LNO, new Integer(0));
        this.putProperty(PNO, new Integer(0));
        this.setSubstitutionTerminateChar(Character.valueOf('.'));
        ScriptRunnerContext.resetDDLOptions();
    }

    public void reInitNoExit() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.deferredReInitNoExit();
        }
    }

    public void deferredReInitNoExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this._errWriter = null;
        this.exited = false;
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        if (this.getProperty(SPOOLOUTBUFFER) != null) {
            this.stopSpool();
        }
    }

    public void stopSpool() {
        new SetSpool().stopSpool(this);
    }

    public PrintWriter getErrWriter() {
        return this._errWriter;
    }

    public void setErrWriter(PrintWriter printWriter) {
        this._errWriter = printWriter;
    }

    public static String getOutputEncoding() {
        return s_outputEncoding;
    }

    public void setNLSMap(Map<String, String> map) {
        this.m_nlsMap = map;
    }

    public Map<String, String> getNLSMap() {
        return this.m_nlsMap;
    }

    public static void setOutputEncoding(String string) {
        s_outputEncoding = string;
    }

    public static byte[] stringToByteArrayForScriptRunner(String string) {
        try {
            return string.getBytes(ScriptRunnerContext.getOutputEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public Connection getBaseConnection() {
        return this.baseConnection;
    }

    public void setBaseConnection(Connection connection) {
        this.baseConnection = connection;
    }

    public boolean getExited() {
        return this.exited;
    }

    public void setExited(boolean bl) {
        Integer n;
        this.exited = bl;
        if (bl && (n = (Integer)this.getProperty(EXIT_INT)) == null) {
            this.putProperty(EXIT_INT, 0);
        }
    }

    public boolean getReturnExited() {
        return this.returnExited;
    }

    public void setReturnExited(boolean bl) {
        this.returnExited = bl;
    }

    public String getPreCommand() {
        return (String)this._props.get(PRE_COMMAND);
    }

    public void setPreCommand(String string) {
        this._props.put(PRE_COMMAND, string);
    }

    public String getPostCommand() {
        return (String)this._props.get(POST_COMMAND);
    }

    public void setPostCommand(String string) {
        this._props.put(POST_COMMAND, string);
    }

    public boolean getEscape() {
        return this.escape;
    }

    public void setEscape(boolean bl) {
        this.escape = bl;
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }

    public void setCloseConnection(boolean bl) {
        this.closeConnection = bl;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean bl) {
        this.topLevel = bl;
    }

    public int getOsError() {
        return this.osError;
    }

    public void setOsError(int n) {
        this.osError = n;
    }

    public int getSqlError() {
        return this.sqlError;
    }

    public void setSqlError(int n) {
        this.sqlError = n;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(Map<String, String> map) {
        this.columnMap = map;
    }

    public char getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void setSubstitutionChar(char c) {
        this.substitutionChar = c;
    }

    public boolean getSubstitutionOn() {
        return this.substitutionOn;
    }

    public void setSubstitutionOn(boolean bl) {
        this.substitutionOn = bl;
    }

    public boolean getScanOn() {
        return this.scanOn;
    }

    public void setScanOn(boolean bl) {
        this.scanOn = bl;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
    }

    public char getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(char c) {
        this.terminateChar = c;
    }

    public Character getSubstitutionTerminateChar() {
        return this.substitutionTerminateChar;
    }

    public void setSubstitutionTerminateChar(Character c) {
        this.substitutionTerminateChar = c;
    }

    private String getDirFromFileURL(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string = null;
        File file = null;
        try {
            file = new File(uRL.getFile());
            string = file.getCanonicalPath();
            if (!file.isDirectory()) {
                if (!file.exists() || string.indexOf(File.separator) == -1) {
                    throw new IOException(Messages.getString("ScriptRunnerContext.14") + string);
                }
                string = string.substring(0, string.lastIndexOf(File.separator));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return string;
    }

    public String getLastDirName() {
        try {
            if (this._lastUrl == null) {
                return null;
            }
            return this.getDirFromFileURL(this._lastUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getLastNodeDirName() {
        try {
            URL uRL = (URL)this.getProperty(NODE_URL);
            if (uRL == null) {
                return null;
            }
            return this.getDirFromFileURL(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getLastNodeForDirNameURL() {
        URL uRL = (URL)this.getProperty(NODE_URL);
        if (uRL == null) {
            return null;
        }
        return uRL;
    }

    public URL getLastUrl() {
        return this._lastUrl;
    }

    public void setLastUrl(URL uRL) {
        this._lastUrl = uRL;
    }

    public void putProperty(String string, Object object) {
        this._props.put(string, object);
    }

    public Object removeProperty(String string) {
        return this._props.remove(string);
    }

    public Object getProperty(String string) {
        return this._props.get(string);
    }

    public Map<String, Object> getProperties() {
        return this._props;
    }

    public void setProperties(Map<String, Object> map) {
        this._props = map;
    }

    public WrapListenBufferOutputStream getOutputStream() {
        return (WrapListenBufferOutputStream)this._props.get(OUT_STREAM_WRAPPER);
    }

    public void setOutputStreamWrapper(BufferedOutputStream bufferedOutputStream) {
        if (this.getOutputStream() == null) {
            if (bufferedOutputStream instanceof WrapListenBufferOutputStream) {
                this._props.put(OUT_STREAM_WRAPPER, bufferedOutputStream);
            } else {
                this._props.put(OUT_STREAM_WRAPPER, new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, this));
            }
        } else {
            try {
                BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
                while (bufferedOutputStream2 instanceof WrapListenBufferOutputStream) {
                    bufferedOutputStream2 = ((WrapListenBufferOutputStream)bufferedOutputStream2).getMainStream();
                }
                this.getOutputStream().replaceMainStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public boolean isOutputSupressed() {
        return this.supressOutput;
    }

    public void setSupressOutput(boolean bl) {
        this.supressOutput = bl;
    }

    public void setFeedback(int n) {
        this.feedback = n;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public void setOutputComponenet(Object object) {
        this._outputComp = object;
    }

    public Object getOutputComponent() {
        return this._outputComp;
    }

    public void write(String string) {
        if (this.isConsumerRunning()) {
            try {
                this.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, Messages.getString("ScriptRunnerContext.15"), iOException);
            }
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "The following was not written to the Script Runner Result Window as the outputStream was closed:" + string);
        }
    }

    public void setVerify(boolean bl) {
        this._verify = bl;
    }

    public boolean isCommandLine() {
        return this._props.get(JLINE_SETTING) != null;
    }

    public boolean isVerifyOn() {
        return this._verify;
    }

    public void setEcho(boolean bl) {
        this._echo = bl;
    }

    public boolean isEchoOn() {
        return this._echo;
    }

    public Map<String, Bind> getVarMap() {
        return this.varMap;
    }

    public void setVarMap(Map<String, Bind> map) {
        this.varMap = map;
    }

    public int get_autoprint() {
        return this._autoprint;
    }

    public void set_autoprint(int n) {
        this._autoprint = n;
    }

    @Override
    public IRaptorTaskProgressUpdater getTaskProgressUpdater() {
        return this.m_taskProgressUpdater;
    }

    public void setTaskProgressUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this.m_taskProgressUpdater = iRaptorTaskProgressUpdater;
    }

    public void setCurrentConnection(Connection connection) {
        if (this.m_currentConnection != null && (connection == null || !connection.equals(this.m_currentConnection)) || connection == null) {
            this.doAllNullSqlplusVar();
        }
        this.m_currentConnection = connection;
    }

    public Connection getCurrentConnection() {
        return this.m_currentConnection;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public void updateColumn(String[] stringArray, String[] stringArray2) {
        boolean bl;
        Map<String, String> map = this.getColumnMap();
        boolean bl2 = bl = stringArray2 == null;
        if (map.size() == 0) {
            return;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            String string3 = null;
            if (!bl) {
                string3 = stringArray2[i];
            }
            if (string3 == null) {
                string3 = "";
            }
            if ((string = map.get(string2.toUpperCase())) == null) continue;
            if (!bl || !this.getMap().keySet().contains(string.toUpperCase())) {
                this.getMap().put(string.toUpperCase(), string3);
            }
            if (!bl || this.getMap().keySet().contains(string.toUpperCase())) continue;
            this.getMap().put(string.toUpperCase(), "");
        }
    }

    public void enableDbmsOutput() {
        this.dbmsOutputEnable = true;
    }

    public void setdbmsEnable(boolean bl) {
        this.dbmsOutputEnable = bl;
    }

    public boolean isDbmsEnabled() {
        return this.dbmsOutputEnable;
    }

    public void clearDbmsFlags() {
        this.dbmsOutputEnable = false;
    }

    public void pushDbmsOutput(String string) {
        if (this.m_dbmsOutput == null) {
            this.m_dbmsOutput = new StringBuffer();
        }
        this.m_dbmsOutput.append(string);
    }

    public String popDbmsOutput() {
        if (this.m_dbmsOutput == null) {
            return null;
        }
        String string = this.m_dbmsOutput.toString();
        this.m_dbmsOutput = null;
        return string;
    }

    public void writeDisconnectWarning() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.getMap().put(SqlplusVariable._CONNECT_IDENTIFIER.toString(), (String)this.getProperty(BASECONNECTIONID));
            this.putProperty(BASECONNECTIONID, null);
            this.getMap().put(SqlplusVariable._PRIVILEGE.toString(), null);
            this.write(Messages.getString("WRITEDISCONNECTWARNING") + "\n");
        }
        try {
            this.getOutputStream().flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void closeCurrentConnection() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.alwaysCloseCurrentConnection();
        }
    }

    public void alwaysCloseCurrentConnection() {
        try {
            if (!(this.getBaseConnection() != null && this.getCurrentConnection() == this.getBaseConnection() || this.getCurrentConnection() == null || this.getCurrentConnection().isClosed())) {
                this.getCurrentConnection().commit();
                this.getCurrentConnection().close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public void consumerRuning(boolean bl) {
        this.m_isConsumerRunning = bl;
    }

    public boolean isConsumerRunning() {
        if (!this.m_isConsumerRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_isConsumerRunning;
    }

    public void addSavepoint(Savepoint savepoint) {
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        try {
            this.savepoints.put(savepoint.getSavepointName(), savepoint);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public HashMap<String, Savepoint> getSavePoints() {
        return this.savepoints;
    }

    public void setSavepoints(HashMap<String, Savepoint> hashMap) {
        this.savepoints = hashMap;
    }

    public Savepoint getSavepoint(String string) {
        if (this.savepoints != null) {
            return this.savepoints.get(string);
        }
        return null;
    }

    public HashMap<String, ArrayList<String>> getStoredFormatCmds() {
        return this.m_formatCmdList;
    }

    public void setStoredFormatCmds(HashMap<String, ArrayList<String>> hashMap) {
        this.m_formatCmdList = hashMap;
    }

    public LinkedHashMap<String, ArrayList<String>> getStoredBreakCmds() {
        return this.m_breakCmdList;
    }

    public void setStoredBreakCmds(LinkedHashMap<String, ArrayList<String>> linkedHashMap) {
        this.m_breakCmdList = linkedHashMap;
    }

    public TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> getStoredComputeCmds() {
        return this.m_computeCmdList;
    }

    public void setStoredComputeCmds(TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> treeMap) {
        this.m_computeCmdList = treeMap;
    }

    public String getTTitleCmd() {
        return this.m_tTitleCmd;
    }

    public void setTTitleCmd(String string) {
        this.m_tTitleCmd = string;
    }

    public String getBTitleCmd() {
        return this.m_bTitleCmd;
    }

    public void setBTitleCmd(String string) {
        this.m_bTitleCmd = string;
    }

    public boolean getBTitleFlag() {
        return this.m_bTitleFlag;
    }

    public void setBTitleFlag(boolean bl) {
        this.m_bTitleFlag = bl;
    }

    public void setTTitle(TopTitle topTitle) {
        this.m_tTitle = topTitle;
    }

    public TopTitle getTTitle() {
        return this.m_tTitle;
    }

    public void setBTitle(BottomTitle bottomTitle) {
        this.m_bTitle = bottomTitle;
    }

    public BottomTitle getBTitle() {
        return this.m_bTitle;
    }

    public void setTTitleFlag(boolean bl) {
        this.m_tTitleFlag = bl;
    }

    public boolean getTTitleFlag() {
        return this.m_tTitleFlag;
    }

    public void setPromptedFieldProvider(IGetPromptedFieldProvider iGetPromptedFieldProvider) {
        this.m_getPromptedFieldProvider = iGetPromptedFieldProvider;
    }

    public IGetPromptedFieldProvider getPromptedFieldProvider() {
        return this.m_getPromptedFieldProvider;
    }

    public void setSubstitutionFieldProvider(IGetPromptedFieldProvider iGetPromptedFieldProvider) {
        this.m_getSubstitutionFieldProvider = iGetPromptedFieldProvider;
    }

    public IGetPromptedFieldProvider getSubstitutionFieldProvider() {
        return this.m_getSubstitutionFieldProvider;
    }

    public void setPasswordFieldsProvider(IGetPromptedPasswordFieldsProvider iGetPromptedPasswordFieldsProvider) {
        this.m_getPasswordFieldsProvider = iGetPromptedPasswordFieldsProvider;
    }

    public IGetPromptedPasswordFieldsProvider getPasswordFieldsProvider() {
        return this.m_getPasswordFieldsProvider;
    }

    public void setConnectFieldsProvider(IGetPromptedConnectFieldsProvider iGetPromptedConnectFieldsProvider) {
        this.m_getConnectFieldsProvider = iGetPromptedConnectFieldsProvider;
    }

    public IGetPromptedConnectFieldsProvider getConnectFieldsProvider() {
        return this.m_getConnectFieldsProvider;
    }

    public void setHandlePauseProvider(IGetHandlePauseProvider iGetHandlePauseProvider) {
        this.m_getHandlePauseProvider = iGetHandlePauseProvider;
    }

    public IGetHandlePauseProvider getHandlePauseProvider() {
        return this.m_getHandlePauseProvider;
    }

    public void setHandleSetPauseProvider(IGetHandlePauseProvider iGetHandlePauseProvider) {
        this.m_getHandleSetPauseProvider = iGetHandlePauseProvider;
    }

    public IGetHandlePauseProvider getHandleSetPauseProvider() {
        return this.m_getHandleSetPauseProvider;
    }

    public void setSourceRef(String string) {
        if (string == null || string.equals("")) {
            this.putProperty(SETSOURCEREF, string);
        }
        int n = string.indexOf("/");
        int n2 = string.indexOf("\\");
        if (n == -1 && n2 == -1 || string.endsWith("/") || string.endsWith("\\")) {
            this.putProperty(SETSOURCEREF, "");
            return;
        }
        String string2 = string.toLowerCase(Locale.US);
        if (string2.startsWith("http://") || string2.startsWith("http:\\\\") || string2.startsWith("ftp:\\\\") || string2.startsWith("ftp://")) {
            this.putProperty(SETSOURCEREF, string);
        } else {
            if (File.separator.equals("/")) {
                string = string.replace("\\", "/");
            } else if (!string.startsWith("//")) {
                string = string.replace("/", "\\");
            }
            this.putProperty(SETSOURCEREF, string);
        }
    }

    public static String lineErr(String string, String string2, Object object, Object object2, Object object3, ScriptRunnerContext scriptRunnerContext) {
        String string3 = "";
        String string4 = "";
        if (scriptRunnerContext != null) {
            string4 = (String)scriptRunnerContext.getProperty(SETSOURCEREF);
        }
        string3 = string4 == null || string4.equals("") ? MessageFormat.format(string, object, object2, object3) : MessageFormat.format(string2, object, string4, object2, object3);
        return string3;
    }

    public static String lineColErr(String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5, ScriptRunnerContext scriptRunnerContext) {
        String string3 = "";
        String string4 = "";
        if (scriptRunnerContext != null) {
            string4 = (String)scriptRunnerContext.getProperty(SETSOURCEREF);
        }
        string3 = string4 == null || string4.equals("") ? MessageFormat.format(string, object, object2, object3, object4, object5) : MessageFormat.format(string2, object, object2, object3, object4, string4, object5);
        return string3;
    }

    public String getSourceRef() {
        return (String)this.getProperty(SETSOURCEREF);
    }

    public ScriptRunnerContext clone() {
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        scriptRunnerContext.set_autoprint(this.get_autoprint());
        scriptRunnerContext.setTTitleFlag(this.getTTitleFlag());
        scriptRunnerContext.setBTitleFlag(this.getBTitleFlag());
        scriptRunnerContext.setBTitle(this.getBTitle());
        scriptRunnerContext.setTTitle(this.getTTitle());
        scriptRunnerContext.setBTitleCmd(this.getBTitleCmd());
        scriptRunnerContext.setTTitleCmd(this.getTTitleCmd());
        scriptRunnerContext.setStoredFormatCmds(this.getStoredFormatCmds());
        scriptRunnerContext.setSavepoints(this.getSavePoints());
        scriptRunnerContext.consumerRuning(false);
        scriptRunnerContext.setdbmsEnable(this.isDbmsEnabled());
        scriptRunnerContext.setEncoding(this.getEncoding());
        scriptRunnerContext.setCurrentConnection(this.getCurrentConnection());
        scriptRunnerContext.set_autoprint(this.get_autoprint());
        scriptRunnerContext.setVarMap(this.getVarMap());
        scriptRunnerContext.setVerify(this.isVerifyOn());
        scriptRunnerContext.setEcho(this.isEchoOn());
        scriptRunnerContext.setFeedback(this.getFeedback());
        scriptRunnerContext.setSupressOutput(this.isOutputSupressed());
        scriptRunnerContext.setProperties(this.getProperties());
        scriptRunnerContext.setLastUrl(this.getLastUrl());
        scriptRunnerContext.setTerminateChar(this.getTerminateChar());
        scriptRunnerContext.setSubstitutionTerminateChar(this.getSubstitutionTerminateChar());
        scriptRunnerContext.setEscapeChar(this.getEscapeChar());
        scriptRunnerContext.setScanOn(this.getScanOn());
        scriptRunnerContext.setSubstitutionChar(this.getSubstitutionChar());
        scriptRunnerContext.setSubstitutionOn(this.getSubstitutionOn());
        scriptRunnerContext.setMap(this.getMap());
        scriptRunnerContext.setColumnMap(this.getColumnMap());
        scriptRunnerContext.setSqlError(this.getSqlError());
        scriptRunnerContext.setOsError(this.getOsError());
        scriptRunnerContext.setCloseConnection(this.getCloseConnection());
        scriptRunnerContext.setEscape(this.getEscape());
        scriptRunnerContext.setReturnExited(this.getReturnExited());
        scriptRunnerContext.setBaseConnection(this.getBaseConnection());
        scriptRunnerContext.setNLSMap(this.getNLSMap());
        scriptRunnerContext.setSourceRef(this.getSourceRef());
        scriptRunnerContext.setPromptedFieldProvider(this.getPromptedFieldProvider());
        scriptRunnerContext.setSubstitutionFieldProvider(this.getSubstitutionFieldProvider());
        scriptRunnerContext.setPasswordFieldsProvider(this.getPasswordFieldsProvider());
        scriptRunnerContext.setHandlePauseProvider(this.getHandlePauseProvider());
        scriptRunnerContext.setHandleSetPauseProvider(this.getHandleSetPauseProvider());
        scriptRunnerContext.setSQLPlusFormatter(this.getSQLPlusFormatter());
        scriptRunnerContext.setSQLPlusCodingStyleOptions(this.getSQLPlusCodingStyleOptions());
        return scriptRunnerContext;
    }

    public String getSettingsDir() {
        String string = System.getProperty("ide.pref.dir");
        if (string == null) {
            string = System.getProperty("ide.base.dir");
        }
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + ".sqldeveloper";
        }
        try {
            if (!new File(string).exists()) {
                new File(string).mkdir();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public IExceptionHandler getExceptionHandler() {
        return null;
    }

    public String getStringTerminator() {
        return System.getProperty("line.separator");
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public Object getNode() {
        return this.node;
    }

    public void setPrompt(String string) {
        this._sqlPrompt = string;
    }

    public String getPrompt() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss ");
        Calendar calendar = Calendar.getInstance();
        boolean bl = this.getProperty(SQLPROMPTTIME).equals("ON");
        String string = this.doAllReplaceSqlplusVar(this._sqlPrompt).replaceAll("'", "").replaceAll("\"", "");
        return bl ? simpleDateFormat.format(calendar.getTime()) + string : string;
    }

    public String getDate(String string) {
        return this.doPromptReplaceSqlplusVar(string, SqlplusVariable._DATE);
    }

    public String getPrivilege(String string) {
        return this.doPromptReplaceSqlplusVar(string, SqlplusVariable._PRIVILEGE);
    }

    public String getConnectionID(String string) {
        return this.doPromptReplaceSqlplusVar(string, SqlplusVariable._CONNECT_IDENTIFIER);
    }

    public String getRawPrompt() {
        return this._sqlPrompt;
    }

    String doAllReplaceSqlplusVar(String string) {
        String string2 = string;
        for (SqlplusVariable sqlplusVariable : SqlplusVariable.values()) {
            string2 = this.doPromptReplaceSqlplusVar(string2, sqlplusVariable);
        }
        Set<String> set = this.getMap().keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.toLowerCase().contains(string3.toLowerCase())) continue;
            try {
                string2 = Pattern.compile(string3, 18).matcher(string2).replaceAll(this.getMap().get(string3));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return string2;
    }

    void doAllNullSqlplusVar() {
        for (SqlplusVariable sqlplusVariable : SqlplusVariable.values()) {
            if (sqlplusVariable.equals((Object)SqlplusVariable._PRIVILEGE) || sqlplusVariable.equals((Object)SqlplusVariable._CONNECT_IDENTIFIER) || sqlplusVariable.equals((Object)SqlplusVariable._EDITOR)) continue;
            this.getMap().put(sqlplusVariable.toString(), null);
        }
    }

    public String doPromptReplaceSqlplusVar(String string, SqlplusVariable sqlplusVariable) {
        return this.doPromptReplaceSqlplusVar(this.getCurrentConnection(), string, sqlplusVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    String doPromptReplaceSqlplusVar(Connection var1_1, String var2_2, SqlplusVariable var3_3) {
        block103: {
            if (var2_2.toUpperCase().indexOf(var3_3.toString()) == -1) break block103;
            if (var1_1 == null && !SqlplusVariable._SQLPLUS_RELEASE.equals((Object)var3_3) && !SqlplusVariable._EDITOR.equals((Object)var3_3)) {
                return "";
            }
            if ((var1_1 != null || !SqlplusVariable._SQLPLUS_RELEASE.equals((Object)var3_3)) && !DBUtil.getConnectionResolver().isOracle(var1_1)) break block103;
            var4_4 = this.getMap().get(var3_3.toString());
            switch (1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[var3_3.ordinal()]) {
                case 1: {
                    if (var1_1 == null) {
                        var4_4 = SqlplusVariable._DATE.toString();
                        break;
                    }
                    try {
                        if (var1_1 == null || var1_1.isClosed()) break;
                        var4_4 = DBUtil.getInstance(var1_1).executeOracleReturnOneCol("select TO_CHAR(cast(current_timestamp as  date)) from dual", new HashMap<K, V>());
                    }
                    catch (SQLException var5_5) {}
                    break;
                }
                case 2: {
                    if (var4_4 != null) break;
                    try {
                        if (var1_1 != null && !var1_1.isClosed()) {
                            var4_4 = DBUtil.getInstance(var1_1).executeOracleReturnOneCol("select USER from dual", new HashMap<K, V>());
                            break;
                        }
                        var4_4 = "";
                    }
                    catch (SQLException var5_6) {}
                    break;
                }
                case 3: {
                    if (var4_4 == null) break;
                    break;
                }
                case 4: {
                    if (var4_4 == null || var4_4.equals("") || this.getProperty("script.runner.jline") == null) {
                        var4_4 = "UNKNOWN";
                        break;
                    }
                    if (!var4_4.equals("NOTSYSDBA")) break;
                    var4_4 = "";
                    break;
                }
                case 5: {
                    if (var4_4 != null && var4_4 != "") break;
                    if (!DBUtil.getConnectionResolver().lock(var1_1)) ** GOTO lbl125
                    try {
                        var5_7 = null;
                        var6_12 = null;
                        var4_4 = "";
                        var7_15 = false;
                        try {
                            var5_7 = var1_1.createStatement();
                            var6_12 = var5_7.executeQuery("select sys_context('userenv','service_name') from dual");
                            if (var6_12.next()) {
                                var4_4 = var6_12.getString(1);
                                if (var4_4 != null && var4_4.indexOf(".") != -1) {
                                    var4_4 = var4_4.substring(0, var4_4.indexOf("."));
                                }
                                if (var4_4 != null && !var4_4.equals("") && !var4_4.toLowerCase().startsWith("sys$")) {
                                    var7_15 = true;
                                }
                            }
                        }
                        catch (SQLException var8_20) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_20.getStackTrace()[0].toString(), var8_20);
                        }
                        finally {
                            if (var6_12 != null) {
                                try {
                                    var6_12.close();
                                }
                                catch (SQLException var8_21) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_21.getStackTrace()[0].toString(), var8_21);
                                }
                            }
                            if (var5_7 != null) {
                                try {
                                    var5_7.close();
                                }
                                catch (SQLException var8_23) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_23.getStackTrace()[0].toString(), var8_23);
                                }
                            }
                        }
                        if (!var7_15) {
                            try {
                                var5_7 = var1_1.createStatement();
                                var6_12 = var5_7.executeQuery("select sys_context('userenv','con_name') from dual");
                                if (var6_12.next() && (var4_4 = var6_12.getString(1)) != null && !var4_4.equals("")) {
                                    var7_15 = true;
                                }
                            }
                            catch (SQLException var8_26) {
                                if (var8_26.getErrorCode() != 2003) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_26.getStackTrace()[0].toString(), var8_26);
                                }
                            }
                            finally {
                                if (var6_12 != null) {
                                    try {
                                        var6_12.close();
                                    }
                                    catch (SQLException var8_27) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_27.getStackTrace()[0].toString(), var8_27);
                                    }
                                }
                                if (var5_7 != null) {
                                    try {
                                        var5_7.close();
                                    }
                                    catch (SQLException var8_28) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_28.getStackTrace()[0].toString(), var8_28);
                                    }
                                }
                            }
                        }
                        if (var7_15) ** GOTO lbl125
                        try {
                            var5_7 = var1_1.createStatement();
                            var6_12 = var5_7.executeQuery("select sys_context('userenv','db_name') from dual");
                            if (var6_12.next() && (var4_4 = var6_12.getString(1)) != null && !var4_4.equals("")) {
                                var7_15 = true;
                            }
                        }
                        finally {
                            if (var6_12 != null) {
                                try {
                                    var6_12.close();
                                }
                                catch (SQLException var8_29) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_29.getStackTrace()[0].toString(), var8_29);
                                }
                            }
                            if (var5_7 != null) {
                                try {
                                    var5_7.close();
                                }
                                catch (Exception var8_30) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_30.getStackTrace()[0].toString(), var8_30);
                                }
                            }
                        }
                    }
                    catch (SQLException var5_8) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var5_8.getStackTrace()[0].toString(), var5_8);
                    }
                    finally {
                        DBUtil.getConnectionResolver().unlock(var1_1);
                    }
lbl125:
                    // 4 sources

                    if (var4_4 != null) break;
                    var4_4 = "";
                    break;
                }
                case 6: {
                    if (var4_4 != null) break;
                    if (var4_4 == null) {
                        var4_4 = "";
                    }
                    if (!DBUtil.getConnectionResolver().lock(var1_1)) break;
                    try {
                        var5_9 = var1_1.getMetaData().getDatabaseMajorVersion();
                        var6_13 = var1_1.getMetaData().getDatabaseMinorVersion();
                        var7_16 = "";
                        var7_16 = var5_9 > 9 ? "" + var5_9 : "0" + var5_9;
                        var7_16 = var6_13 > 9 ? var7_16 + var6_13 : var7_16 + "0" + var6_13;
                        var4_4 = var7_16 + "000000";
                        break;
                    }
                    catch (SQLException var5_10) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var5_10.getStackTrace()[0].toString(), var5_10);
                        break;
                    }
                    finally {
                        DBUtil.getConnectionResolver().unlock(var1_1);
                    }
                }
                case 7: {
                    if (var4_4 != null) break;
                    var5_11 = this.getCmdlineVersion().toIntArray();
                    var6_14 = 1;
                    var7_17 = "";
                    var8_31 = var5_11;
                    var9_37 = var8_31.length;
                    for (var10_44 = 0; var10_44 < var9_37; ++var10_44) {
                        var11_46 = var8_31[var10_44];
                        if (var6_14 > 5 || var11_46 == null) break;
                        var7_17 = var11_46 > 9 ? var7_17 + "" + var11_46 : var7_17 + "0" + var11_46;
                        ++var6_14;
                    }
                    for (var8_32 = var6_14; var8_32 < 6; ++var8_32) {
                        var7_17 = var7_17 + "00";
                    }
                    var4_4 = var7_17;
                    break;
                }
                case 8: {
                    if (var4_4 != null) break;
                    try {
                        var8_33 = (Boolean)this.getProperty("script.runner.PRELIM_AUTH");
                        if (var8_33 != null && var8_33.equals(Boolean.TRUE)) {
                            if (var1_1 != null && !var1_1.isClosed()) {
                                var4_4 = DBUtil.getInstance(var1_1).executeOracleReturnOneCol("select * from v$version where upper(banner) like upper('Oracle Database%')", new HashMap<K, V>());
                                break;
                            }
                            var4_4 = "";
                            break;
                        }
                        if (var1_1 != null && !var1_1.isClosed()) {
                            if (!DBUtil.getConnectionResolver().lock(var1_1)) break;
                            try {
                                var9_38 = var1_1.getMetaData();
                                if (var9_38 == null || (var4_4 = var9_38.getDatabaseProductVersion()) != null) break;
                                var4_4 = "";
                                break;
                            }
                            finally {
                                DBUtil.getConnectionResolver().unlock(var1_1);
                            }
                        }
                        var4_4 = "";
                    }
                    catch (SQLException var8_34) {}
                    break;
                }
                case 9: {
                    if (var4_4 != null) break;
                    var4_4 = "UNKNOWN";
                    var8_35 = null;
                    try {
                        var9_39 = Paths.get("", new String[0]);
                        var4_4 = var9_39.toAbsolutePath().toString();
                    }
                    catch (IOError var9_40) {
                        var8_35 = var9_40;
                    }
                    catch (InvalidPathException var9_41) {
                        var8_35 = var9_41;
                    }
                    if (var8_35 == null) break;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var8_35.getStackTrace()[0].toString(), var8_35);
                }
            }
            if (var4_4 != null && !var3_3.equals((Object)SqlplusVariable._DATE) && !var3_3.equals((Object)SqlplusVariable._PRIVILEGE)) {
                this.getMap().put(var3_3.toString(), var4_4);
            }
            if (var4_4 != null) {
                var2_2 = this.caseInsensitiveReplace(var2_2, var3_3.toString(), var4_4);
            }
        }
        return var2_2;
    }

    private String caseInsensitiveReplace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        if (string == null || string.equals("")) {
            return "";
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string2.toUpperCase();
        String string5 = string.toUpperCase();
        while ((n = string5.indexOf(string4, n2)) != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string4.length());
            string5 = string.toUpperCase();
            n2 = n + string3.length();
        }
        return string;
    }

    public URL getLastDirNameURL() {
        return this._lastUrl;
    }

    public Version getCmdlineVersion() {
        return this.cmdlineVersion;
    }

    public void setVersion(Version version) {
        this.cmdlineVersion = version;
    }

    public void setSQLPlusCmdLineLogin() {
        this.getProperties().put(SQLPLUS_CMDLINE_LOGIN, "true");
    }

    public void setSQLPlusConsoleReader(IConsoleReader iConsoleReader) {
        this._sqlplusConsoleReader = iConsoleReader;
    }

    public IConsoleReader getSQLPlusConsoleReader() {
        return this._sqlplusConsoleReader;
    }

    public void setSQLPlusCodingStyleOptions(ICodingStyleSQLOptions iCodingStyleSQLOptions) {
        this._codingStyleSQLOptions = iCodingStyleSQLOptions;
    }

    public ICodingStyleSQLOptions getSQLPlusCodingStyleOptions() {
        return this._codingStyleSQLOptions;
    }

    public void setSQLPlusFormatter(ICoreFormatter iCoreFormatter) {
        this._coreFormatter = iCoreFormatter;
    }

    public ICoreFormatter getSQLPlusFormatter() {
        return this._coreFormatter;
    }

    public void setAnsiColor(boolean bl) {
        Ansi.setEnabled((boolean)bl);
    }

    public void setSQLPlusBuffer(IBuffer iBuffer) {
        this._sqlplusBuffer = iBuffer;
    }

    public IBuffer getSQLPlusBuffer() {
        return this._sqlplusBuffer;
    }

    public Object getComputes() {
        return 1;
    }

    public void clearComputes() {
    }

    public Object getBreaks() {
        return 1;
    }

    public void clearBreaks() {
    }

    public Connection cloneCLIConnection() throws SQLException {
        if (this.getProperty(CLI_CONN_URL) == null || this.getProperty(CLI_CONN_PROPS) == null) {
            throw new RuntimeException("No CLI connection information");
        }
        return DriverManager.getConnection((String)this.getProperty(CLI_CONN_URL), (Properties)this.getProperty(CLI_CONN_PROPS));
    }

    public String prependCD(String string) {
        String[] stringArray;
        String string2 = string;
        String string3 = string;
        boolean bl = false;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (string3.length() <= 3 || (string3.charAt(1) != ':' || string3.charAt(2) != '/' && string3.charAt(2) != '\\') && (string3.charAt(0) != '/' || string3.charAt(2) != ':' || string3.charAt(3) != '/')) {
                bl = true;
            }
        } else if (!string3.startsWith("/")) {
            bl = true;
        }
        String string4 = (String)this.getProperty(CDPATH);
        if (bl && string4 != null && (stringArray = string4.split(File.pathSeparator)) != null && stringArray.length > 0 && stringArray[0] != null && new File(stringArray[0]).isDirectory()) {
            string4 = stringArray[0];
            string2 = string4.endsWith(File.separator) ? string4 + string2 : string4 + File.separator + string2;
        }
        return string2;
    }

    /*
     * Exception decompiling
     */
    public String save(String var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean getTiming() {
        if (this.getProperty(SHOWTIMING) != null) {
            return (Boolean)this.getProperty(SHOWTIMING);
        }
        return false;
    }

    private ArrayList<String> getContextCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = SQLStatementTypes.setCommands.size();
        arrayList.add("set feedback OFF");
        arrayList.add("set heading ON");
        return arrayList;
    }

    public void setBasePrompt(String string) {
        this.m_basePrompt = string;
    }

    public String getBasePrompt() {
        return this.m_basePrompt;
    }

    public boolean isInterrupted() {
        return this._interrupted;
    }

    public void setInterrupted(boolean bl) {
        this._interrupted = bl;
    }

    private static void resetDDLOptions() {
        String[] stringArray;
        _ddlOptions.clear();
        for (String string : stringArray = new String[]{"PRETTY", "SQLTERMINATOR", "CONSTRAINTS", "REF_CONSTRAINTS", "CONSTRAINTS_AS_ALTER", "OID", "SIZE_BYTE_KEYWORD", "PARTITIONING", "SEGMENT_ATTRIBUTES", "STORAGE", "TABLESPACE", "SPECIFICATION", "BODY", "FORCE", "INSERT", "DEFAULT", "INHERIT"}) {
            _ddlOptions.put(string, "ON");
        }
        _ddlOptions.put("DEFAULT", "OFF");
    }

    public Map<String, String> getDDLOptions() {
        if (_ddlOptions != null) {
            return _ddlOptions;
        }
        return null;
    }

    public void setDDLOptions(String string, String string2) {
        if (string.toUpperCase().equals("RESET")) {
            if (string2.toUpperCase().equals("ON")) {
                ScriptRunnerContext.resetDDLOptions();
            }
            return;
        }
        if (_ddlOptions.keySet().contains(string)) {
            _ddlOptions.replace(string, string2);
            boolean bl = true;
            for (String string3 : _ddlOptions.keySet()) {
                if (string3.toUpperCase().equals("RESET") || !_ddlOptions.get(string3.toUpperCase()).equals("OFF")) continue;
                bl = false;
            }
            _ddlOptions.replace("DEFAULT", bl ? "ON" : "OFF");
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable;

        static {
            $SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable = new int[SqlplusVariable.values().length];
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._DATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._EDITOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._PRIVILEGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._CONNECT_IDENTIFIER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._O_RELEASE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._SQLPLUS_RELEASE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._O_VERSION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$oracle$dbtools$raptor$newscriptrunner$ScriptRunnerContext$SqlplusVariable[SqlplusVariable._PWD.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static enum SqlplusVariable {
        _DATE,
        _CONNECT_IDENTIFIER,
        _USER,
        _PRIVILEGE,
        _SQLPLUS_RELEASE,
        _EDITOR,
        _O_VERSION,
        _O_RELEASE,
        _PWD;

    }
}

