/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class JSONFormatter
extends ResultsFormatter {
    public static final String TYPE = "JSON";
    public static final String EXT = "json";

    public JSONFormatter() {
        super(TYPE, Messages.getString("JSONFormatter.0"), EXT);
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public void start() throws IOException {
        this.write("{\"items\":[\n");
    }

    @Override
    public void startRow() throws IOException {
        long l = this.getResultsFormatterWrapper().getRowNum();
        if (l > 1L) {
            this.write(",");
        }
        this.write("{");
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        int n3 = this.getDataType(n);
        Object object2 = this.getValue(object);
        if (object2 != null) {
            if (n2 != 0) {
                this.write(",");
            }
            this.write("\"" + this.getColumnName(n).toLowerCase() + "\":");
            if (object == null || n3 == 4 || n3 == -5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 2 || n3 == 2 || n3 == -6 || n3 == 3) {
                this.write(object2.toString());
            } else {
                this.write("\"" + object2.toString() + "\"");
            }
        }
    }

    @Override
    public void endRow() throws IOException {
        this.write("}");
    }

    @Override
    public void end() throws IOException {
        this.write("]}\n");
    }
}

