/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypePlatformException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingSplit;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.Datum;

public class CallableBindingDatumAtName<P extends DataBinding>
extends CallableBindingImpl<P> {
    protected final BindContext context;
    private String byPositionBindToken;
    private String byNameBindToken;
    private OracleCallableStatement stmt;

    public CallableBindingDatumAtName(BindContext bindContext, P p) {
        this(bindContext, p, p.getDataType());
    }

    public CallableBindingDatumAtName(BindContext bindContext, P p, DataType dataType) {
        this(bindContext, p, dataType, p.getMode());
    }

    public CallableBindingDatumAtName(BindContext bindContext, P p, BindingMode bindingMode) {
        this(bindContext, p, p.getDataType(), bindingMode);
    }

    protected CallableBindingDatumAtName(BindContext bindContext, P p, DataType dataType, BindingMode bindingMode) {
        super(p, dataType, bindingMode);
        this.context = bindContext;
        this.stmt = null;
        this.byPositionBindToken = null;
        this.byNameBindToken = null;
    }

    @Override
    public void setByNameBindToken(String string) {
        this.byNameBindToken = string;
    }

    @Override
    public String getByNameBindToken() {
        return this.byNameBindToken;
    }

    @Override
    public void setByPositionBindToken(String string) {
        this.byPositionBindToken = string;
    }

    @Override
    public String getByPositionBindToken() {
        if (this.byPositionBindToken == null) {
            this.byPositionBindToken = this.context.nextBindToken();
        }
        return this.byPositionBindToken;
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode bindingMode) {
        if (bindingMode.getEffectiveMode() == BindingMode.IN && this.getByNameBindToken() != null) {
            return BindingStyle.NAME;
        }
        return BindingStyle.POSITION;
    }

    @Override
    public String getBindToken(BindingMode bindingMode) {
        if (this.getBindingStyle(bindingMode) == BindingStyle.NAME) {
            return this.getByNameBindToken();
        }
        return this.getByPositionBindToken();
    }

    public OracleCallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement callableStatement) {
        try {
            this.stmt = (OracleCallableStatement)callableStatement;
        }
        catch (ClassCastException classCastException) {
            throw new DataTypePlatformException(OracleCallableStatement.class);
        }
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            this.outputValue = this.customOutputByPosition(this.getCallableStatement(), this.context.remapPosition(this.getByPositionBindToken()));
        }
        return this.outputValue;
    }

    @Override
    protected PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        String string = this.param.getName();
        if (this.param instanceof DataParameter) {
            switch (this.mode) {
                case RETURN: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallWrapper, "%s := ", this.getBindToken(this.mode));
                    break;
                }
                default: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.ParamBinding, string + "=>%s", this.getBindToken(this.mode));
                    break;
                }
            }
        } else {
            switch (this.mode) {
                case IN: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallBlocks, string + " := %s;", this.getBindToken(this.mode));
                    break;
                }
                case OUT: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := " + string + ";", this.getBindToken(this.mode));
                }
            }
        }
        return pLSQLBoundBlockBuilder;
    }

    @Override
    protected void customBindIN(DataValue dataValue) throws SQLException {
        if (this.getBindingStyle(this.mode) == BindingStyle.NAME) {
            this.customBindIN(dataValue, this.getByNameBindToken());
        } else {
            this.customBindIN(dataValue, this.context.remapPosition(this.getByPositionBindToken()));
        }
    }

    protected void customBindIN(DataValue dataValue, int n) throws SQLException {
        this.inputValue = dataValue;
        Object object = dataValue != null ? dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        this.stmt.setObject(n, object, this.dataType.getSqlDataType(ValueType.DATUM));
    }

    protected void customBindIN(DataValue dataValue, String string) throws SQLException {
        this.inputValue = dataValue;
        Object object = dataValue != null ? dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        this.stmt.setObjectAtName(string, object, this.dataType.getSqlDataType(ValueType.DATUM));
    }

    @Override
    protected void customBindOUT() throws SQLException {
        this.customBindOUT(this.getByPositionBindToken());
    }

    protected void customBindOUT(String string) throws SQLException {
        String string2 = this.dataType.getUserDataTypeString();
        if (string2 != null) {
            this.stmt.registerOutParameter(this.context.remapPosition(string), this.dataType.getSqlDataType(ValueType.DATUM), string2);
        } else {
            this.stmt.registerOutParameter(this.context.remapPosition(string), this.dataType.getSqlDataType(ValueType.DATUM));
        }
    }

    @Override
    protected void customReportBinding(StringBuilder stringBuilder, String string, DataValue dataValue) {
        this.reportBinding(stringBuilder, string, this.getBindToken(this.mode), dataValue.getDataType(), this.mode.getEffectiveMode(), dataValue.getStringValue().toString());
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        CallableBindingSplit<DataBinding> callableBindingSplit = new CallableBindingSplit<DataBinding>(this.context, this.param, this.dataType, this.mode);
        callableBindingSplit.setByNameBindToken(this.getByNameBindToken());
        callableBindingSplit.setByPositionBindToken(this.getByPositionBindToken());
        return callableBindingSplit;
    }

    protected DataValue customOutputByPosition(OracleCallableStatement oracleCallableStatement, int n) throws SQLException {
        Datum datum;
        block2: {
            datum = null;
            try {
                datum = oracleCallableStatement.getOracleObject(n);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 17021) break block2;
                throw sQLException;
            }
        }
        return this.dataType.getDataValue(datum);
    }
}

