/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.util.encoding.BASE64Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingFactory;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class ROWID
extends Datum {
    protected ROWID(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        switch (valueType) {
            case JDBC: {
                return this.customTypedValue(dataTypeConnectionProvider, dataValueInternal, ValueType.DEFAULT, object);
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.ROWID.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -8;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        if (object instanceof oracle.sql.ROWID) {
            return object;
        }
        if (object instanceof byte[]) {
            return new oracle.sql.ROWID(Arrays.copyOf((byte[])object, ((byte[])object).length));
        }
        return new oracle.sql.ROWID(String.valueOf(object).getBytes());
    }

    @Override
    protected boolean customRequiresConnection() {
        return true;
    }

    public static byte[] decodeRowId(Object object) throws IOException, EncodingException {
        return ROWID.decodeRowId(String.valueOf(object));
    }

    public static byte[] decodeRowId(String string) throws IOException, EncodingException {
        if (string.contains(".")) {
            return ROWID.decodeOracle7RowId(string.toCharArray());
        }
        return ROWID.decodeOracle8RowId(string.toCharArray());
    }

    public static String encodeRowId(byte[] byArray) throws IOException, EncodingException {
        if (byArray.length == 8) {
            return ROWID.encodeOracle7RowId(byArray);
        }
        return ROWID.encodeOracle8RowId(byArray);
    }

    public static byte[] decodeOracle8RowId(char[] cArray) throws IOException, EncodingException {
        int n;
        BASE64Encoding bASE64Encoding = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
        char[] cArray2 = new char[8];
        int n2 = 0;
        cArray2[n2++] = 65;
        cArray2[n2++] = 65;
        for (n = 0; n < 6; ++n) {
            cArray2[n2++] = cArray[n];
        }
        byte[] byArray = bASE64Encoding.decodeToByteArray(cArray2);
        char[] cArray3 = new char[4];
        n2 = 0;
        ++n;
        while (n < 9) {
            cArray3[n2++] = cArray[n];
            ++n;
        }
        cArray3[n2++] = 65;
        cArray3[n2++] = 61;
        byte[] byArray2 = bASE64Encoding.decodeToByteArray(cArray3);
        char[] cArray4 = new char[4];
        n2 = 0;
        ++n;
        ++n;
        while (n < 15) {
            cArray4[n2++] = cArray[n];
            ++n;
        }
        byte[] byArray3 = bASE64Encoding.decodeToByteArray(cArray4);
        char[] cArray5 = new char[4];
        n2 = 0;
        cArray5[n2++] = 65;
        while (n < 18) {
            cArray5[n2++] = cArray[n];
            ++n;
        }
        byte[] byArray4 = bASE64Encoding.decodeToByteArray(cArray5);
        byte[] byArray5 = new byte[]{byArray[2], byArray[3], byArray[4], byArray[5], byArray2[0], (byte)(byArray2[1] | byArray3[0]), byArray3[1], byArray3[2], byArray4[1], byArray4[2]};
        return byArray5;
    }

    public static String encodeOracle8RowId(byte[] byArray) throws IOException, EncodingException {
        BASE64Encoding bASE64Encoding = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = new byte[6];
        byArray2[2] = byArray[0];
        byArray2[3] = byArray[1];
        byArray2[4] = byArray[2];
        byArray2[5] = byArray[3];
        char[] cArray = bASE64Encoding.encodeToCharArray(byArray2);
        stringBuilder.append(cArray, 2, 6);
        stringBuilder.append("A");
        byte[] byArray3 = new byte[]{byArray[4], (byte)(byArray[5] & 0xF0)};
        char[] cArray2 = bASE64Encoding.encodeToCharArray(byArray3);
        stringBuilder.append(cArray2, 0, 2);
        stringBuilder.append("AA");
        byte[] byArray4 = new byte[]{(byte)(byArray[5] & 0xF), byArray[6], byArray[7]};
        char[] cArray3 = bASE64Encoding.encodeToCharArray(byArray4);
        stringBuilder.append(cArray3);
        byte[] byArray5 = new byte[3];
        byArray5[1] = byArray[8];
        byArray5[2] = byArray[9];
        char[] cArray4 = bASE64Encoding.encodeToCharArray(byArray5);
        stringBuilder.append(cArray4, 1, 3);
        return stringBuilder.toString();
    }

    public static byte[] decodeOracle7RowId(char[] cArray) throws IOException, EncodingException {
        BASE64Encoding bASE64Encoding = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bASE64Encoding.decode(new CharArrayReader(cArray, 0, 8), byteArrayOutputStream);
        bASE64Encoding.decode(new CharArrayReader(cArray, 9, 4), byteArrayOutputStream);
        bASE64Encoding.decode(new CharArrayReader(cArray, 14, 4), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String encodeOracle7RowId(byte[] byArray) throws IOException, EncodingException {
        BASE64Encoding bASE64Encoding = (BASE64Encoding)EncodingFactory.getDecoder(EncodingType.ENCODING_HEX, MimeType.MIME_TEXT);
        StringWriter stringWriter = new StringWriter();
        bASE64Encoding.encode(new ByteArrayInputStream(byArray, 0, 4), stringWriter);
        stringWriter.append('.');
        bASE64Encoding.encode(new ByteArrayInputStream(byArray, 5, 2), stringWriter);
        stringWriter.append('.');
        bASE64Encoding.encode(new ByteArrayInputStream(byArray, 5, 2), stringWriter);
        return stringWriter.toString();
    }
}

