/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NUMBER;
import oracle.dbtools.raptor.datatypes.util.StringValue;

public class INTEGER
extends NUMBER {
    protected INTEGER(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        switch (stringType) {
            case GENERIC: {
                oracle.sql.NUMBER nUMBER = (oracle.sql.NUMBER)dataValueInternal.getInternalValue();
                try {
                    return new StringValue(nUMBER.bigIntegerValue().toString());
                }
                catch (SQLException sQLException) {
                    throw new DataTypeSQLException(sQLException);
                }
            }
        }
        return super.customStringValue(dataTypeConnectionProvider, dataValueInternal, stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        Object object3 = super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        try {
            switch (valueType) {
                case JDBC: {
                    return this.unscaledValue((BigDecimal)object3);
                }
            }
            return object3;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, object2, exception);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return BigInteger.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    private BigInteger unscaledValue(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.unscaledValue();
    }

    @Override
    protected oracle.sql.NUMBER posNUMBERMax(Integer n, Integer n2) throws SQLException {
        oracle.sql.NUMBER nUMBER;
        oracle.sql.NUMBER nUMBER2 = super.posNUMBERMax(n, n2);
        if (nUMBER2 != null && nUMBER2.compareTo(nUMBER = new oracle.sql.NUMBER((Object)"2147483647")) > 0) {
            return nUMBER;
        }
        return nUMBER2;
    }

    @Override
    protected oracle.sql.NUMBER negNUMBERMax(Integer n, Integer n2) throws SQLException {
        oracle.sql.NUMBER nUMBER;
        oracle.sql.NUMBER nUMBER2 = super.negNUMBERMax(n, n2);
        if (nUMBER2 != null && nUMBER2.compareTo(nUMBER = new oracle.sql.NUMBER((Object)"-2147483647")) < 0) {
            return nUMBER;
        }
        return nUMBER2;
    }
}

