/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import oracle.sql.Datum;

public abstract class OraIntervalDatum
implements Cloneable,
Comparable<OraIntervalDatum> {
    public static final int ALL_FIELDS = 255;
    public static final int NULL_FIELD = -1;
    public static final int SIGN = 0;
    public static final int YEARS = 1;
    public static final int MONTHS = 2;
    public static final int DAYS = 1;
    public static final int HOURS = 2;
    public static final int MINUTES = 3;
    public static final int SECONDS = 4;
    public static final int NANOS = 5;
    public static final String LEADINGPRECISION = "LEADINGPRECISION";
    public static final String FRACTIONALPRECISION = "FRACTIONALPRECISION";
    protected OraIntervalDatumImpl datumImpl;

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    protected OraIntervalDatum(OraIntervalDatumImpl oraIntervalDatumImpl) {
        this.datumImpl = oraIntervalDatumImpl;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.datumImpl.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.datumImpl.removePropertyChangeListener(propertyChangeListener);
    }

    public abstract Datum getDatum();

    public MetaData getMetaData() {
        return this.datumImpl.getMetaData();
    }

    public void clear() {
        this.datumImpl.clear();
    }

    public void normalize() {
        this.datumImpl.normalize();
    }

    public int get(int n) {
        return this.datumImpl.get(n);
    }

    public void set(int n, int n2) {
        this.datumImpl.set(n, n2);
    }

    public int getFromField() {
        return this.datumImpl.getFromField();
    }

    public int getToField() {
        return this.datumImpl.getToField();
    }

    public final int getLeadingPrecision() {
        return this.datumImpl.getLeadingPrecision();
    }

    public final void setLeadingPrecision(int n) {
        this.datumImpl.setLeadingPrecision(n);
    }

    public final int getFractionalPrecision() {
        return this.datumImpl.getFractionalPrecision();
    }

    public final void setFractionalPrecision(int n) {
        this.datumImpl.setFractionalPrecision(n);
    }

    public abstract boolean nanosSupported();

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        OraIntervalDatum oraIntervalDatum = (OraIntervalDatum)object;
        return OraIntervalDatum.areEqual(this.datumImpl, oraIntervalDatum.datumImpl);
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.datumImpl == null ? 0 : this.datumImpl.hashCode());
        return n;
    }

    @Override
    public int compareTo(OraIntervalDatum oraIntervalDatum) {
        int n = 0;
        if (this != oraIntervalDatum) {
            n = this.datumImpl.compareTo(oraIntervalDatum.datumImpl);
        }
        return n;
    }

    public Object clone() {
        try {
            OraIntervalDatum oraIntervalDatum = (OraIntervalDatum)super.clone();
            oraIntervalDatum.datumImpl = (OraIntervalDatumImpl)this.datumImpl.clone();
            return oraIntervalDatum;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final void replicate(OraIntervalDatum oraIntervalDatum) {
        if (oraIntervalDatum.getClass() == this.getClass()) {
            this.datumImpl.replicate(oraIntervalDatum.datumImpl);
        }
    }

    public final void setValue(OraIntervalDatum oraIntervalDatum) {
        if (oraIntervalDatum.getClass() == this.getClass()) {
            this.datumImpl.setValue(oraIntervalDatum.datumImpl);
        }
    }

    protected static abstract class OraIntervalDatumImpl
    implements Cloneable,
    Comparable<OraIntervalDatumImpl> {
        protected int[] fields;
        protected MetaData metadata;
        private int leadingPrecision;
        private int fractionalPrecision;
        private int fromField;
        private int toField;
        private PropertyChangeSupport changesSupport = new PropertyChangeSupport(this);

        protected void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changesSupport.addPropertyChangeListener(propertyChangeListener);
        }

        protected void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changesSupport.removePropertyChangeListener(propertyChangeListener);
        }

        private void fireFieldChange(int n, int n2, int n3) {
            this.changesSupport.firePropertyChange(this.metadata.getFieldId(n), n2, n3);
        }

        private void fireLeadingPrecisionChange(int n, int n2) {
            this.changesSupport.firePropertyChange(OraIntervalDatum.LEADINGPRECISION, n, n2);
        }

        private void fireFractionalPrecisionChange(int n, int n2) {
            this.changesSupport.firePropertyChange(OraIntervalDatum.FRACTIONALPRECISION, n, n2);
        }

        protected OraIntervalDatumImpl(MetaData metaData, int[] nArray, int n, int n2, int n3, int n4) {
            this.metadata = metaData;
            this.fields = nArray;
            this.fromField = n;
            this.toField = n3;
            this.leadingPrecision = n2;
            this.fractionalPrecision = n4;
            this.set(0, 1);
            for (int i = 1; i < nArray.length; ++i) {
                int n5 = nArray[i];
                if (n5 == 0) continue;
                if (n5 < 0) {
                    this.set(0, -1);
                }
                for (int j = i; j < nArray.length; ++j) {
                    this.set(j, Math.abs(nArray[j]));
                }
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            OraIntervalDatumImpl oraIntervalDatumImpl = (OraIntervalDatumImpl)object;
            return Arrays.equals(this.fields, oraIntervalDatumImpl.fields);
        }

        @Override
        public int compareTo(OraIntervalDatumImpl oraIntervalDatumImpl) {
            int n = 0;
            if (this != oraIntervalDatumImpl) {
                int n2 = this.fields[0];
                int n3 = oraIntervalDatumImpl.fields[0];
                for (int i = 1; n == 0 && i < this.fields.length; ++i) {
                    int n4 = this.fields[i] * n2;
                    int n5 = oraIntervalDatumImpl.fields[i] * n3;
                    if (n4 == n5) continue;
                    if (n4 < n5) {
                        n = -1;
                        continue;
                    }
                    if (n4 <= n5) continue;
                    n = 1;
                }
            }
            return n;
        }

        public int hashCode() {
            int n = 7;
            n = n * 31 + Arrays.hashCode(this.fields);
            return n;
        }

        public Object clone() {
            try {
                OraIntervalDatumImpl oraIntervalDatumImpl = (OraIntervalDatumImpl)super.clone();
                oraIntervalDatumImpl.metadata = (MetaData)this.metadata.clone();
                oraIntervalDatumImpl.fields = (int[])this.fields.clone();
                oraIntervalDatumImpl.fromField = this.fromField;
                oraIntervalDatumImpl.toField = this.toField;
                oraIntervalDatumImpl.leadingPrecision = this.leadingPrecision;
                oraIntervalDatumImpl.fractionalPrecision = this.fractionalPrecision;
                return oraIntervalDatumImpl;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void replicate(OraIntervalDatumImpl oraIntervalDatumImpl) {
            this.fromField = oraIntervalDatumImpl.fromField;
            this.toField = oraIntervalDatumImpl.toField;
            this.setLeadingPrecision(this.getLeadingPrecision());
            this.setFractionalPrecision(this.getFractionalPrecision());
            this.setValue(oraIntervalDatumImpl);
        }

        public void setValue(OraIntervalDatumImpl oraIntervalDatumImpl) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (i == 0 || i >= this.fromField && i <= this.toField) {
                    this.set(i, oraIntervalDatumImpl.fields[i]);
                    if (i != 4) continue;
                    this.set(5, oraIntervalDatumImpl.fields[5]);
                    ++i;
                    continue;
                }
                this.set(i, 0);
            }
        }

        public MetaData getMetaData() {
            return this.metadata;
        }

        public int getFromField() {
            return this.fromField;
        }

        public int getToField() {
            return this.toField;
        }

        public void setLeadingPrecision(int n) {
            int n2 = this.leadingPrecision;
            if (n != n2) {
                this.leadingPrecision = n;
                if (n2 > n) {
                    this.leading_precision_changed(n2, n);
                }
                this.fireLeadingPrecisionChange(n2, n);
                if (n2 < n) {
                    this.leading_precision_changed(n2, n);
                }
            }
        }

        public final int getLeadingPrecision() {
            return this.leadingPrecision;
        }

        protected void leading_precision_changed(int n, int n2) {
        }

        public final void setFractionalPrecision(int n) {
            int n2 = this.fractionalPrecision;
            if (n != n2) {
                this.fractionalPrecision = n;
                if (n2 > n) {
                    this.fractional_precision_changed(n2, n);
                }
                this.fireFractionalPrecisionChange(n2, n);
                if (n2 < n) {
                    this.fractional_precision_changed(n2, n);
                }
            }
        }

        public final int getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        protected void fractional_precision_changed(int n, int n2) {
        }

        protected int get(int n) {
            return this.fields[n];
        }

        protected void set(int n, int n2) {
            int n3 = this.fields[n];
            if (n3 != n2) {
                this.fields[n] = n2;
                this.fireFieldChange(n, n3, n2);
            }
        }

        protected abstract byte[] getDatumBytes();

        public void clear() {
            this.set(0, 1);
            for (int i = 1; i < this.fields.length; ++i) {
                this.set(i, 0);
            }
        }

        public abstract void normalize();
    }

    public static enum Field {
        SIGN(0, 1, 1, 1),
        YEARS(0, 999999999, 2, 9),
        MONTHS(0, 11, 2, 2),
        DAYS(0, 999999999, 2, 9),
        HOURS(0, 23, 2, 2),
        MINUTES(0, 59, 2, 2),
        SECONDS(0, 59, 2, 2),
        NANOS(0, 999999999, -1, -1);

        private int minValue;
        private int maxValue;
        private int minDisplayPrecision;
        private int maxDisplayPrecision;

        private Field(int n2, int n3, int n4, int n5) {
            this.minValue = n2;
            this.maxValue = n3;
            this.minDisplayPrecision = n4;
            this.maxDisplayPrecision = n5;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public int getMinDisplayPrecision() {
            return this.minDisplayPrecision;
        }

        public int getMaxDisplayPrecision() {
            return this.maxDisplayPrecision;
        }
    }

    public static abstract class MetaData
    implements Cloneable {
        protected abstract List<Field> getFieldList();

        public Field[] getFields() {
            return this.getFieldList().toArray(new Field[this.getFieldList().size()]);
        }

        public Field getField(int n) {
            return this.getFields()[n];
        }

        public Field getField(String string) {
            Field field = Field.valueOf(string);
            return this.getFieldList().contains((Object)field) ? field : null;
        }

        public int getFieldOrdinal(Field field) {
            return this.getFieldList().indexOf((Object)field);
        }

        public String getFieldId(Field field) {
            return this.getFieldList().contains((Object)field) ? field.toString() : null;
        }

        public int getFieldOrdinal(String string) {
            return this.getFieldOrdinal(this.getField(string));
        }

        public String getFieldId(int n) {
            return this.getFieldId(this.getField(n));
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }
}

