/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import org.xml.sax.SAXException;

public class DataValueImpl
implements DataValue {
    private final DataValueAccessor accessor = new DataValueAccessor();
    private final Object internalValue;
    private boolean valueIsNull;
    protected final DataTypeImpl datatype;

    protected DataValueImpl(DataTypeImpl dataTypeImpl) {
        this(dataTypeImpl, null);
    }

    protected DataValueImpl(DataTypeImpl dataTypeImpl, Object object) {
        this.datatype = dataTypeImpl;
        try {
            this.internalValue = dataTypeImpl.getInternalValue(object);
            dataTypeImpl.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
            this.valueIsNull = DataTypesUtil.isNull(this.internalValue);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeIllegalArgumentException dataTypeIllegalArgumentException) {
            throw dataTypeIllegalArgumentException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)exception);
        }
    }

    protected DataValueImpl(DataTypeImpl dataTypeImpl, Collection<DataValue> collection) {
        this.datatype = dataTypeImpl;
        try {
            this.internalValue = collection;
            dataTypeImpl.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
            this.valueIsNull = DataTypesUtil.isNull(this.internalValue);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)exception);
        }
    }

    @Override
    public final String getName() {
        return null;
    }

    @Override
    public final DataType getDataType() {
        return this.datatype;
    }

    @Override
    public DataValue getBindingDataValue() {
        return this;
    }

    @Override
    public final StringValue getStringValue() {
        return this.getStringValue(-1);
    }

    @Override
    public final StringValue getStringValue(StringType stringType) {
        return this.getStringValue(stringType, -1);
    }

    @Override
    public final StringValue getStringValue(int n) {
        return this.getStringValue(StringType.DEFAULT, n);
    }

    @Override
    public final StringValue getStringValue(StringType stringType, int n) {
        try {
            return this.customStringValue(stringType, n);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)exception);
        }
    }

    protected StringValue customStringValue(StringType stringType, int n) {
        return this.datatype.getStringValue(this.accessor, stringType, n);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, StringType stringType) {
        return this.getStringValue(dataTypeConnectionProvider, stringType, -1);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, StringType stringType, int n) {
        try {
            return this.customStringValue(dataTypeConnectionProvider, stringType, n);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (DataTypeException dataTypeException) {
            throw dataTypeException;
        }
        catch (Exception exception) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)exception);
        }
    }

    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, StringType stringType, int n) {
        return this.datatype.getStringValue(dataTypeConnectionProvider, this.accessor, stringType, n);
    }

    @Override
    public final Object getTypedValue() {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
    }

    @Override
    public final Object getTypedValue(ValueType valueType) {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, valueType);
    }

    @Override
    public final Object getTypedValue(Object object) {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, object);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        return this.getTypedValue(dataTypeConnectionProvider, valueType, null);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) {
        return this.datatype.getTypedValue(dataTypeConnectionProvider, this.accessor, valueType, object);
    }

    public String toString() {
        try {
            return this.valueIsNull ? null : this.getStringValue(-1).toString();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return this.internalValue == null ? null : this.internalValue.toString();
        }
    }

    @Override
    public final boolean isNull() {
        return this.valueIsNull;
    }

    public final boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl) {
            if (object instanceof NamedDataValue) {
                bl = object.equals(this);
            } else if (object instanceof DataValueImpl) {
                DataValueImpl dataValueImpl = (DataValueImpl)object;
                bl = this.getClass() == dataValueImpl.getClass() && (this.isNull() && dataValueImpl.isNull() || !this.isNull() && !dataValueImpl.isNull() && this.customEquals(object));
            }
        }
        return bl;
    }

    protected boolean customEquals(Object object) {
        if (object instanceof DataValueImpl) {
            DataValueImpl dataValueImpl = (DataValueImpl)object;
            return DataValueImpl.areEquals(this.datatype, dataValueImpl.datatype) && this.datatype.equals(this.internalValue, dataValueImpl.internalValue);
        }
        return false;
    }

    private static boolean areEquals(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    @Override
    public final void marshallToXml(DataValueMarshallHandler dataValueMarshallHandler, String string) {
        try {
            dataValueMarshallHandler.startDataValue(this.getDataType(), string, this.isNull());
            if (!this.isNull()) {
                this.customMarshallToXml(dataValueMarshallHandler, string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new DataTypeMarshallingException(this, (Throwable)exception);
        }
        finally {
            try {
                dataValueMarshallHandler.endDataValue(this.getDataType(), string);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    @Override
    public final void marshallToXml(DataValueMarshallHandler dataValueMarshallHandler) {
        this.marshallToXml(dataValueMarshallHandler, this.getName());
    }

    protected void customMarshallToXml(DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        this.datatype.marshallToXml(this.accessor, dataValueMarshallHandler, string);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public final List<DataValue> getComponents() {
        return this.customComponents();
    }

    protected List<DataValue> customComponents() {
        return this.datatype.getComponents(this.accessor);
    }

    private class DataValueAccessor
    implements DataValueInternal {
        private DataValueAccessor() {
        }

        @Override
        public Object getInternalValue() {
            return DataValueImpl.this.internalValue;
        }

        @Override
        public boolean isNull() {
            return DataValueImpl.this.valueIsNull;
        }
    }
}

