/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;

public class TaskLinkedList<S>
extends LinkedList<RaptorTask<?>> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(RaptorTask<?> raptorTask) {
        boolean bl = true;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            bl = super.offer(raptorTask);
            this.notify();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        boolean bl = true;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            bl = super.remove(object);
            this.notify();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaptorTask<?> takeNextTask(Collection<RaptorTask<?>> collection) throws InterruptedException {
        RaptorTask<?> raptorTask = null;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            while (this.getNextTask(collection) == null) {
                this.wait();
            }
            raptorTask = this.getNextTask(collection);
            this.remove(raptorTask);
        }
        return raptorTask;
    }

    private RaptorTask<?> getNextTask(Collection<RaptorTask<?>> collection) {
        RaptorTask raptorTask = null;
        for (RaptorTask raptorTask2 : this) {
            RaptorTask<?> raptorTask3 = this.getConflictingTask(raptorTask2, collection);
            if (raptorTask3 != null) {
                raptorTask2.getDescriptor().setMessage(MessageFormat.format(Messages.getString("TaskLinkedList.0"), raptorTask3.getDescriptor().getName()));
                continue;
            }
            if (raptorTask != null) continue;
            raptorTask = raptorTask2;
        }
        return raptorTask;
    }

    private RaptorTask<?> getConflictingTask(RaptorTask<?> raptorTask, Collection<RaptorTask<?>> collection) {
        ISchedulingRule iSchedulingRule = raptorTask.getSchedulingRule();
        if (iSchedulingRule == null) {
            return null;
        }
        for (RaptorTask<?> raptorTask2 : collection) {
            ISchedulingRule iSchedulingRule2;
            if (raptorTask2.getStatus() == IRaptorTaskStatus.FINISHED || raptorTask2.getStatus() == IRaptorTaskStatus.FAILED || raptorTask2.getSchedulingRule() == null || !iSchedulingRule.isConflicting(iSchedulingRule2 = raptorTask2.getSchedulingRule()) && !iSchedulingRule2.isConflicting(iSchedulingRule)) continue;
            return raptorTask2;
        }
        return null;
    }
}

