/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Service;

public class PlsqlRules {
    public static void main(String[] stringArray) throws Exception {
        throw new AssertionError((Object)"VT: broken");
    }

    public static Set<RuleTuple> parseBNFtext(String string) throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        List<LexerToken> list = LexerToken.parse(string);
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        for (LexerToken lexerToken : list) {
            if (lexerToken.content.charAt(0) != '.' && lexerToken.content.charAt(0) != '_' && lexerToken.content.charAt(lexerToken.content.length() - 1) == '_' && lexerToken.content.toUpperCase().equals(lexerToken.content)) {
                lexerToken.content = "'" + lexerToken.content.substring(0, lexerToken.content.length() - 1).toUpperCase() + "'";
            }
            arrayList.add(lexerToken);
        }
        ParseNode parseNode = Grammar.parseGrammarFile(arrayList, string);
        Grammar.grammar(parseNode, arrayList, treeSet);
        PlsqlRules.substitute(treeSet, "expr", "pls_expr");
        return treeSet;
    }

    private static void substitute(Set<RuleTuple> set, String string, String string2) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
        boolean bl = false;
        for (RuleTuple ruleTuple : set) {
            RuleTuple ruleTuple2 = new RuleTuple(ruleTuple.head, new String[ruleTuple.rhs.length]);
            if (ruleTuple.head.equals(string)) {
                ruleTuple2.head = string2;
                bl = true;
            }
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (ruleTuple.rhs[i].equals(string)) {
                    ruleTuple2.rhs[i] = string2;
                    bl = true;
                    continue;
                }
                ruleTuple2.rhs[i] = ruleTuple.rhs[i];
            }
            if (!bl) continue;
            treeSet.add(ruleTuple);
            treeSet2.add(ruleTuple2);
        }
        set.removeAll(treeSet);
        set.addAll(treeSet2);
    }

    static void fixIdentifierIsOrAs(Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            int n;
            RuleTuple ruleTuple2;
            if (3 <= ruleTuple.rhs.length && ("'PACKAGE'".equals(ruleTuple.rhs[0]) || "'TYPE'".equals(ruleTuple.rhs[0]) || "'PROCEDURE'".equals(ruleTuple.rhs[0]) || "'FUNCTION'".equals(ruleTuple.rhs[0]) || "'TRIGGER'".equals(ruleTuple.rhs[0])) && "identifier".equals(ruleTuple.rhs[1])) {
                ruleTuple2 = new RuleTuple(ruleTuple.head, new String[ruleTuple.rhs.length + 2]);
                ruleTuple2.rhs[0] = ruleTuple.rhs[0];
                ruleTuple2.rhs[1] = "identifier";
                ruleTuple2.rhs[2] = "'.'";
                for (n = 1; n < ruleTuple.rhs.length; ++n) {
                    ruleTuple2.rhs[n + 2] = ruleTuple.rhs[n];
                }
                treeSet.add(ruleTuple2);
                continue;
            }
            if (4 > ruleTuple.rhs.length || !"'BODY'".equals(ruleTuple.rhs[1]) || !"identifier".equals(ruleTuple.rhs[2])) continue;
            ruleTuple2 = new RuleTuple(ruleTuple.head, new String[ruleTuple.rhs.length + 2]);
            ruleTuple2.rhs[0] = ruleTuple.rhs[0];
            ruleTuple2.rhs[1] = ruleTuple.rhs[1];
            ruleTuple2.rhs[2] = "identifier";
            ruleTuple2.rhs[3] = "'.'";
            for (n = 2; n < ruleTuple.rhs.length; ++n) {
                ruleTuple2.rhs[n + 2] = ruleTuple.rhs[n];
            }
            treeSet.add(ruleTuple2);
        }
        set.addAll(treeSet);
    }

    public static void numberRules(Set<RuleTuple> set) {
        set.add(new RuleTuple(".fd.", new String[0]));
        set.add(new RuleTuple(".fd.", new String[]{"'f'"}));
        set.add(new RuleTuple(".fd.", new String[]{"'d'"}));
        set.add(new RuleTuple(".+-.", new String[0]));
        set.add(new RuleTuple(".+-.", new String[]{"'+'"}));
        set.add(new RuleTuple(".+-.", new String[]{"'-'"}));
        set.add(new RuleTuple(".exp.", new String[0]));
        set.add(new RuleTuple(".exp.", new String[]{"'E'", ".+-.", "digits"}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"'.'", "digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", "digits", ".exp.", ".fd."}));
    }

    public static Set<String> getKeywords(Set<RuleTuple> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RuleTuple ruleTuple : set) {
            for (String string : ruleTuple.rhs) {
                if (!string.startsWith("'")) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    static String readBNFfile() throws Exception {
        String string = Service.readFile(PlsqlRules.class, "plsql.y");
        string = string.substring(string.indexOf("/*---------------------------- Start of Rules -------------------------------*/") + "/*---------------------------- Start of Rules -------------------------------*/".length());
        string = PlsqlRules.removeNestedBlock(string, "/*", "*/");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = string.replace("ASSIGN_", "':' '='");
        string = string.replace("LTEQ_", "'<' '='");
        string = string.replace("GTEQL_", "'>' '='");
        string = string.replace("NOTEQL_", "'!' '='");
        string = string.replace("BOX_", "'<' '>'");
        string = string.replace("CAT_", "'|' '|'");
        string = string.replace(" DBLDOT_ ", " '.' '.' ");
        string = string.replace("ARROW_", "'=' '>'");
        string = string.replace("EXP_ pri", "'*' '*' pri");
        string = string.replace("L_LBL_", "'<' '<'");
        string = string.replace("R_LBL_", "'>' '>'");
        string = string.replace(" INDICATOR_ ", " ':' ");
        string = string.replace("')'", " ')' ");
        string = string.replace("'('", " '(' ");
        string = string.replace("%%", "");
        string = string.replace("bind_var.INDICATOR_id.", "\"bind_var.INDICATOR_id.\"");
        string = string.replace("...from_table_reference_or_subquery..", "\"...from_table_reference_or_subquery..\"");
        return string;
    }

    static String removeNestedBlock(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < string.length()) {
            n3 = string.indexOf(string2, n4);
            int n5 = string.indexOf(string2, n3 + n);
            int n6 = string.indexOf(string3, n3 + n) + n2;
            if (n3 > 0 && n3 < n5 && n5 < n6) {
                stringBuffer.append(string.substring(n4, n3 + n));
                n4 = n3 + n;
                continue;
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            stringBuffer.append(string.substring(n4, n3));
            n4 = string.indexOf(string3, n3 + n) + n2;
            if (n4 >= n2) continue;
            stringBuffer.append(string.substring(n3));
            break;
        }
        return stringBuffer.toString();
    }
}

