/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class ParsedSql
extends Parsed {
    public ParsedSql(String string) throws InterruptedException {
        super(string, SqlEarley.fullRecognizer(), null);
        try {
            this.src = LexerToken.parse(string, false, true, new InterruptedException());
        }
        catch (InterruptedException interruptedException) {
            this.earley = null;
            throw new InterruptedException();
        }
    }

    @Override
    public synchronized List<LexerToken> getSrc() {
        if (this.src == null || this.earley == null) {
            throw new AssertionError((Object)"Impossible ParsedSql instance with broken lexical analysis");
        }
        return this.src;
    }

    public synchronized ParseNode parse() throws InterruptedException {
        if (this.earley == null) {
            throw new InterruptedException("Interrupted earlier");
        }
        if (this.root == null) {
            Visual visual = null;
            if (this.debug) {
                visual = new Visual(this.src, this.earley);
            }
            this.matrix = new Matrix(this.earley);
            try {
                ((SqlEarley)this.earley).parse(this.src, this.matrix, new InterruptedException());
            }
            catch (InterruptedException interruptedException) {
                this.src = null;
                throw new InterruptedException();
            }
            if (this.debug) {
                visual.draw(this.matrix);
            }
            this.root = this.earley.forest(this.src, this.matrix);
        }
        return this.root;
    }

    @Override
    public synchronized ParseNode getRoot() {
        throw new AssertionError((Object)"overriden by parse(), which throws InterruptedException");
    }

    public static void main(String[] stringArray) throws Exception {
        final Thread thread = Thread.currentThread();
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(50000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                thread.interrupt();
            }
        }.start();
        String string = Service.readFile(SqlEarley.class, "MSC_CL_PRE_PROCESS.pkgbdy");
        SqlEarley.fullRecognizer();
        long l = System.currentTimeMillis();
        ParsedSql parsedSql = new ParsedSql(string);
        long l2 = System.currentTimeMillis();
        System.out.println("Constructor (Lex) time = " + (l2 - l));
        l = System.currentTimeMillis();
        List<LexerToken> list = parsedSql.getSrc();
        l2 = System.currentTimeMillis();
        System.out.println("getter time = " + (l2 - l));
        System.out.println("tokens= " + list.size());
        l = System.currentTimeMillis();
        ParseNode parseNode = parsedSql.parse();
        l2 = System.currentTimeMillis();
        System.out.println("parse time = " + (l2 - l));
        if (list.size() < 100) {
            parseNode.printTree();
        }
    }
}

