/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.UnifiedRules;

public class ExportGrammar {
    private static Set<RuleTuple> origRules;

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        if (bl) {
            ExportGrammar.copyGrammar(bl, "C:\\AceOracle\\WebContent\\src\\parser\\sqlgrammar.js");
            ExportGrammar.copyGrammar(bl, "C:\\sql_developer_web\\js\\oracle\\oracle.grammar.js");
        } else {
            ExportGrammar.copyGrammar(bl, "C:\\Temp\\sqlgrammar.txt");
        }
    }

    private static void copyGrammar(boolean bl, String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        if (bl) {
            bufferedWriter.write("function sqlGrammar() {\n");
            bufferedWriter.write("    var sql = [];\n");
        }
        for (RuleTuple ruleTuple : origRules) {
            if (bl) {
                if (ruleTuple.head.toLowerCase().contains("xml") || ruleTuple.head.toLowerCase().contains("partition") || ruleTuple.head.toLowerCase().contains("table_properties")) {
                    System.out.println(ruleTuple.toString());
                    continue;
                }
                bufferedWriter.write("sql.push({head:\"");
                bufferedWriter.write(ruleTuple.head.replace("\"", "\\\""));
                bufferedWriter.write("\",rhs:[\"");
                int n = -1;
                for (String string2 : ruleTuple.rhs) {
                    if (0 < ++n) {
                        bufferedWriter.write("\",\"");
                    }
                    bufferedWriter.write(string2.replace("\"", "\\\""));
                }
                bufferedWriter.write("\"]});\n");
                continue;
            }
            bufferedWriter.write(ruleTuple.toString() + "\n");
        }
        if (bl) {
            bufferedWriter.write("  return sql;\n");
            bufferedWriter.write("}\n");
        }
        bufferedWriter.close();
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
            origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

