/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Service;

public class RuleTransforms {
    public static Set<String> dubiousEmptyProductions = new HashSet<String>();

    private static void log(Set<RuleTuple> set, Set<RuleTuple> set2) {
        boolean bl = true;
        bl = false;
        if (bl) {
            System.out.println("---:");
            RuleTuple.printRules(set);
            System.out.println("+++:");
            RuleTuple.printRules(set2);
            System.out.println();
        }
    }

    public static void removeRules(String string, Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            if (!string.equals(ruleTuple.head)) continue;
            treeSet.add(ruleTuple);
        }
        set.removeAll(treeSet);
    }

    public static void substituteSingleBinaryProductions(Set<RuleTuple> set) {
        while (true) {
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
            for (RuleTuple ruleTuple : set) {
                if (!ruleTuple.head.endsWith(")") && !ruleTuple.head.endsWith("#") || ruleTuple.rhs.length != 2) continue;
                boolean bl = true;
                for (RuleTuple ruleTuple2 : set) {
                    if (!ruleTuple.head.equals(ruleTuple2.head) || ruleTuple.equals(ruleTuple2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                treeSet.add(ruleTuple);
                System.out.println(">>> " + ruleTuple.toString());
                for (RuleTuple ruleTuple2 : set) {
                    String[] stringArray = new String[ruleTuple2.rhs.length * 2];
                    int n = 0;
                    for (int i = 0; i < ruleTuple2.rhs.length; ++i) {
                        if (ruleTuple2.rhs[i].equals(ruleTuple.head)) {
                            stringArray[n++] = ruleTuple.rhs[0];
                            stringArray[n++] = ruleTuple.rhs[1];
                            continue;
                        }
                        stringArray[n++] = ruleTuple2.rhs[i];
                    }
                    if (n == ruleTuple2.rhs.length) continue;
                    treeSet.add(ruleTuple2);
                    String[] stringArray2 = new String[n];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray2[i] = stringArray[i];
                    }
                    treeSet2.add(new RuleTuple(ruleTuple2.head, stringArray2));
                }
            }
            if (treeSet.size() == 0) break;
            RuleTransforms.log(treeSet, treeSet2);
            set.removeAll(treeSet);
            set.addAll(treeSet2);
        }
    }

    public static void substituteSingleUnaryProductions(Set<RuleTuple> set) {
        if (set.size() == 1) {
            return;
        }
        while (true) {
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
            for (RuleTuple ruleTuple : set) {
                if (ruleTuple.rhs.length != 1 || ruleTuple.rhs[0].equals(ruleTuple.head)) continue;
                boolean bl = true;
                for (RuleTuple ruleTuple2 : set) {
                    if (!ruleTuple.head.equals(ruleTuple2.head) || ruleTuple.equals(ruleTuple2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                treeSet.add(ruleTuple);
                System.out.println(">>> " + ruleTuple.toString());
                for (RuleTuple ruleTuple2 : set) {
                    String[] stringArray = new String[ruleTuple2.rhs.length];
                    bl = false;
                    for (int i = 0; i < ruleTuple2.rhs.length; ++i) {
                        if (ruleTuple2.rhs[i].equals(ruleTuple.head)) {
                            stringArray[i] = ruleTuple.rhs[0];
                            bl = true;
                            continue;
                        }
                        stringArray[i] = ruleTuple2.rhs[i];
                    }
                    if (!bl) continue;
                    treeSet.add(ruleTuple2);
                    treeSet2.add(new RuleTuple(ruleTuple2.head, stringArray));
                }
            }
            if (treeSet.size() == 0) break;
            RuleTransforms.log(treeSet, treeSet2);
            set.removeAll(treeSet);
            set.addAll(treeSet2);
        }
    }

    public static void eliminateEmptyProductions(Set<RuleTuple> set) {
        while (true) {
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
            String string = null;
            for (RuleTuple ruleTuple : set) {
                if (string != null || ruleTuple.rhs.length != 0) continue;
                string = ruleTuple.head;
                treeSet.add(ruleTuple);
                System.out.println("--- " + ruleTuple.toString());
                if (string.contains("[")) break;
                dubiousEmptyProductions.add(string);
                break;
            }
            if (string == null) break;
            boolean bl = true;
            for (RuleTuple ruleTuple : set) {
                if (ruleTuple.rhs.length == 0 || !string.equals(ruleTuple.head)) continue;
                bl = false;
                break;
            }
            for (RuleTuple ruleTuple : set) {
                String[] stringArray;
                int n = 0;
                for (String string2 : ruleTuple.rhs) {
                    if (!string2.equals(string)) continue;
                    ++n;
                }
                if (n == 0) continue;
                if (bl) {
                    treeSet.add(ruleTuple);
                }
                if (n > 2) {
                    throw new AssertionError((Object)("head = " + string + " matched " + ruleTuple.toString()));
                }
                if (n == 1) {
                    stringArray = new String[ruleTuple.rhs.length - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < stringArray.length) {
                        if (ruleTuple.rhs[n2].equals(string)) {
                            ++n3;
                        }
                        stringArray[n2] = ruleTuple.rhs[n3];
                        ++n2;
                        ++n3;
                    }
                    treeSet2.add(new RuleTuple(ruleTuple.head, stringArray));
                }
                if (n != 2) continue;
                stringArray = new String[ruleTuple.rhs.length - 2];
                String[] stringArray2 = new String[ruleTuple.rhs.length - 1];
                String[] stringArray3 = new String[ruleTuple.rhs.length - 1];
                int n4 = 0;
                int n5 = 0;
                while (n4 < stringArray.length) {
                    if (ruleTuple.rhs[n4].equals(string)) {
                        ++n5;
                    }
                    stringArray[n4] = ruleTuple.rhs[n5];
                    ++n4;
                    ++n5;
                }
                n4 = 0;
                n5 = 0;
                while (n4 < stringArray3.length) {
                    if (n4 == n5 && ruleTuple.rhs[n4].equals(string)) {
                        ++n5;
                    }
                    stringArray3[n4] = ruleTuple.rhs[n5];
                    ++n4;
                    ++n5;
                }
                n4 = 0;
                n5 = 0;
                int n6 = 0;
                while (n5 < stringArray2.length) {
                    if (n4 == 0 && ruleTuple.rhs[n5].equals(string)) {
                        n4 = 1;
                    } else if (n4 != 0 && ruleTuple.rhs[n5].equals(string)) {
                        ++n6;
                    }
                    stringArray2[n5] = ruleTuple.rhs[n6];
                    ++n5;
                    ++n6;
                }
                treeSet2.add(new RuleTuple(ruleTuple.head, stringArray));
                treeSet2.add(new RuleTuple(ruleTuple.head, stringArray2));
                treeSet2.add(new RuleTuple(ruleTuple.head, stringArray3));
            }
            if (treeSet.size() == 0 && treeSet2.size() == 0) break;
            RuleTransforms.log(treeSet, treeSet2);
            set.addAll(treeSet2);
            set.removeAll(treeSet);
        }
    }

    public static void injectMissingEmptyProductions(Set<RuleTuple> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : dubiousEmptyProductions) {
            System.out.println("injecting " + string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            for (RuleTuple ruleTuple : set) {
                int n = 0;
                for (String string2 : ruleTuple.rhs) {
                    if (!string2.equals(string)) continue;
                    ++n;
                }
                if (n == 0) continue;
                if (n > 1) {
                    throw new AssertionError((Object)("head = " + string + " matched " + ruleTuple.toString()));
                }
                if (ruleTuple.rhs.length == 1) {
                    hashSet.add(ruleTuple.head);
                }
                String[] stringArray = new String[ruleTuple.rhs.length - 1];
                int n2 = 0;
                int n3 = 0;
                while (n2 < stringArray.length) {
                    if (ruleTuple.rhs[n2].equals(string)) {
                        ++n3;
                    }
                    stringArray[n2] = ruleTuple.rhs[n3];
                    ++n2;
                    ++n3;
                }
                treeSet.add(new RuleTuple(ruleTuple.head, stringArray));
            }
            System.out.println("++**++:");
            RuleTuple.printRules(treeSet);
            System.out.println();
            set.addAll(treeSet);
        }
        dubiousEmptyProductions = hashSet;
    }

    public static void printRulesHierachy(String string, Set<RuleTuple> set) {
        System.out.println("-------------Rules Hierachy------------");
        int n = string.indexOf(91);
        LinkedList<RuleTuple> linkedList = new LinkedList<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            if (!ruleTuple.head.startsWith(n > 0 ? string.substring(0, n) : string)) continue;
            linkedList.add(ruleTuple);
        }
        RuleTransforms.printRule(string, linkedList, 0);
        System.out.println("-------------------------------------");
    }

    private static void printRule(String string, List<RuleTuple> list, int n) {
        for (RuleTuple ruleTuple : list) {
            if (!ruleTuple.head.equals(string)) continue;
            Service.identln(n, ruleTuple.toString());
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                RuleTransforms.printRule(ruleTuple.rhs[i], list, n + 1);
            }
        }
    }

    public static void print(Set<RuleTuple> set) {
        for (RuleTuple ruleTuple : set) {
            System.out.println(ruleTuple.toString() + ";");
        }
    }

    public static void printSelectedRules(String string, Set<RuleTuple> set) {
        System.out.println("-------------Rules---------------");
        for (RuleTuple ruleTuple : set) {
            if (!ruleTuple.toString().contains(string)) continue;
            System.out.println(ruleTuple.toString());
        }
        System.out.println("-------------------------------------");
    }

    public static boolean isEmptyHead(String string, Set<RuleTuple> set) {
        if ("cluster_index_clause".equals(string)) {
            string = "cluster_index_clause";
        }
        boolean bl = RuleTransforms.emptyClosure(set).contains(string);
        return bl;
    }

    private static Set<String> emptyClosure(Set<RuleTuple> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RuleTuple object : set) {
            if (object.rhs.length != 0) continue;
            hashSet.add(object.head);
        }
        while (true) {
            HashSet hashSet2 = new HashSet();
            for (RuleTuple ruleTuple : set) {
                boolean bl = true;
                for (String string : ruleTuple.rhs) {
                    if (hashSet.contains(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashSet2.add(ruleTuple.head);
            }
            if (hashSet.containsAll(hashSet2)) break;
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }

    public static void main(String[] stringArray) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("xmltable[6912,6915)", new String[]{"string_literal", "xmltable[6913,6915)"}));
        treeSet.add(new RuleTuple("xmltable[6913,6915)", new String[]{"xmltable_options", "')'"}));
        treeSet.add(new RuleTuple("xmltable_options", new String[]{"xmltable_options[3,24)"}));
        treeSet.add(new RuleTuple("xmltable_options", new String[]{"xmltable_options[3,24)"}));
        treeSet.add(new RuleTuple("xmltable_options[10,11)", new String[]{"COLUMNS"}));
        treeSet.add(new RuleTuple("xmltable_options[15,16)", new String[]{"XML_table_column"}));
        treeSet.add(new RuleTuple("xmltable_options[15,23)", new String[]{"xmltable_options[15,16)", "xmltable_options[16,23)"}));
        treeSet.add(new RuleTuple("xmltable_options[16,23)", new String[0]));
        treeSet.add(new RuleTuple("xmltable_options[16,23)", new String[]{"xmltable_options[17,19)"}));
        treeSet.add(new RuleTuple("xmltable_options[16,23)", new String[]{"xmltable_options[16,23)", "xmltable_options[16,23)"}));
        treeSet.add(new RuleTuple("xmltable_options[17,18)", new String[]{"','"}));
        treeSet.add(new RuleTuple("xmltable_options[17,19)", new String[]{"xmltable_options[17,18)", "xmltable_options[18,19)"}));
        treeSet.add(new RuleTuple("xmltable_options[18,19)", new String[]{"XML_table_column"}));
        treeSet.add(new RuleTuple("xmltable_options[3,24)", new String[]{"xmltable_options[3,6)", "xmltable_options[6,24)"}));
        treeSet.add(new RuleTuple("xmltable_options[3,6)", new String[0]));
        treeSet.add(new RuleTuple("xmltable_options[3,6)", new String[]{"xmltable_options[4,5)"}));
        treeSet.add(new RuleTuple("xmltable_options[4,5)", new String[]{"XML_passing_clause"}));
        treeSet.add(new RuleTuple("xmltable_options[6,24)", new String[0]));
        treeSet.add(new RuleTuple("xmltable_options[6,24)", new String[]{"xmltable_options[7,23)"}));
        treeSet.add(new RuleTuple("xmltable_options[7,15)", new String[]{"xmltable_options[10,11)"}));
        treeSet.add(new RuleTuple("xmltable_options[7,23)", new String[]{"xmltable_options[7,15)", "xmltable_options[15,23)"}));
        System.out.println(RuleTransforms.isEmptyHead("xmltable", treeSet));
        System.out.println(RuleTransforms.isEmptyHead("xmltable_options", treeSet));
        RuleTransforms.eliminateEmptyProductions(treeSet);
        System.out.println(RuleTransforms.isEmptyHead("xmltable", treeSet));
        System.out.println(RuleTransforms.isEmptyHead("xmltable_options", treeSet));
        RuleTuple.printRules(treeSet);
    }
}

