/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.TriState;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.Messages;
import oracle.dbtools.db.OracleUtil;
import oracle.dbtools.db.PrepareResult;
import oracle.dbtools.db.ThirdPartyUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Service;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

public class DBUtil {
    protected static final String VERSION_10G_STRING = "10.1";
    protected static final String EMPTY_STRING = "";
    private static final String QUOTE_DELIMITER = "\"";
    protected static final Logger LOGGER = Logger.getLogger(DBUtil.class.getName());
    public static final Object NULL_VALUE = new Object();
    public static final String SUBSTITUTION = "substitution";
    public static final String PREFERRED_FETCH_SIZE = "PreferfedFetchSize";
    protected static ConnectionResolver s_conns;
    private static Map<Thread, Statement> s_execThreadMap;
    protected static String s_prodName;
    private static String m_currentErrorString;
    private static final Map<Connection, Version> VERSION_CACHE;
    private static Map<Connection, DBUtil> s_instanceMap;
    private static Map<String, Constructor<? extends DBUtil>> s_utilImpls;
    protected final Connection m_conn;
    private String m_cname;
    private boolean m_raiseError;
    private ThreadLocal<SQLException> m_lastException = new ThreadLocal();
    private Map<String, Boolean> m_accessCache = new HashMap<String, Boolean>();
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*[0-9]+";
    private static final Pattern s_pattern;
    public static final Version ORACLE8_VERSION;
    public static final Version ORACLE8i_VERSION;
    public static final Version ORACLE9i_VERSION;
    public static final Version ORACLE9iR2_VERSION;
    public static final Version ORACLE10g_VERSION;
    public static final Version ORACLE10gR2_VERSION;
    public static final Version ORACLE11g_VERSION;
    public static final Version ORACLE12c_VERSION;
    static final boolean DEBUG_BUILD;
    private static ThreadLocal<Integer> s_lockCheckCount;

    public static synchronized void setConnectionResolver(ConnectionResolver connectionResolver) {
        if (s_conns != null) {
            throw new IllegalStateException("Cannot set a ConnectionResolver if one is already set");
        }
        s_conns = connectionResolver;
    }

    public static synchronized ConnectionResolver getConnectionResolver() {
        return s_conns;
    }

    public static void setProductName(String string) {
        s_prodName = string;
    }

    public static void registerUtilForType(String string, Constructor<? extends DBUtil> constructor) {
        s_utilImpls.put(string, constructor);
    }

    public static DBUtil getInstance(Connection connection) {
        return DBUtil.getInstance(null, connection);
    }

    public static DBUtil getInstance(String string) {
        DBUtil dBUtil = null;
        try {
            dBUtil = DBUtil.getInstance(string, s_conns.getConnection(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dBUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBUtil getInstance(String string, Connection connection) {
        assert (connection != null);
        DBUtil dBUtil = null;
        Map<Connection, DBUtil> map = s_instanceMap;
        synchronized (map) {
            dBUtil = s_instanceMap.get(connection);
            if (dBUtil == null) {
                String string2 = s_conns.getConnectionType(connection);
                Constructor<? extends DBUtil> constructor = s_utilImpls.get(string2);
                if (constructor != null) {
                    try {
                        dBUtil = constructor.newInstance(string, connection);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        LOGGER.severe(throwable.getLocalizedMessage());
                    }
                }
                if (dBUtil == null) {
                    dBUtil = new ThirdPartyUtil(string, connection);
                }
                s_instanceMap.put(connection, dBUtil);
            } else if (string != null && dBUtil.m_cname == null) {
                dBUtil.m_cname = string;
            }
        }
        return dBUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelExecution(Thread thread) {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            Statement statement = s_execThreadMap.get(thread);
            if (statement != null) {
                try {
                    statement.cancel();
                    return true;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected DBUtil(String string, Connection connection) {
        this.m_cname = string;
        this.m_conn = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setCurrentStatement(Statement statement) {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            s_execThreadMap.put(Thread.currentThread(), statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearCurrentStatement() {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            s_execThreadMap.remove(Thread.currentThread());
        }
    }

    public void setDBAction(String string) {
        throw new UnsupportedOperationException("setDBAction");
    }

    public void setDBModuleAction(String string) {
        throw new UnsupportedOperationException("setDBModuleAction");
    }

    public String executeReturnOneCol(String string, Map<String, ? extends Object> map) {
        return this.executeNonOracleReturnOneCol(string, map);
    }

    public String executeReturnOneCol(String string) {
        return this.executeNonOracleReturnOneCol(string, null);
    }

    private String executeNonOracleReturnOneCol(final String string, final Map<String, ?> map) {
        OperImpl<String> operImpl = new OperImpl<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                String string3;
                PrepareResult prepareResult = DBUtil.this.prepareNonOracleSql(string, map);
                String string2 = prepareResult.getSQL();
                List<Object> list = prepareResult.getBinds();
                string2 = string2.replaceAll("\n", " ");
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = DBUtil.this.m_conn.prepareStatement(string2);
                    DBUtil.bind(preparedStatement, list);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    string3 = resultSet.getString(1);
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(preparedStatement, resultSet);
                    throw throwable;
                }
                DBUtil.cleanup(preparedStatement, resultSet);
                return string3;
            }

            @Override
            public String getSQL() {
                return string;
            }
        };
        return this.lockForOperation(operImpl, null);
    }

    public final String executeOracleReturnOneCol(final String string, final Map<String, ?> map) {
        OperImpl<String> operImpl = new OperImpl<String>(){

            @Override
            public String getSQL() {
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                ResultSet resultSet;
                CallableStatement callableStatement;
                block2: {
                    String string2;
                    callableStatement = null;
                    resultSet = null;
                    try {
                        callableStatement = DBUtil.this.m_conn.prepareCall(string);
                        DBUtil.bind(string, callableStatement, map);
                        resultSet = callableStatement.executeQuery();
                        if (!resultSet.next()) break block2;
                        string2 = resultSet.getString(1);
                    }
                    catch (Throwable throwable) {
                        DBUtil.cleanup(callableStatement, resultSet);
                        throw throwable;
                    }
                    DBUtil.cleanup(callableStatement, resultSet);
                    return string2;
                }
                DBUtil.cleanup(callableStatement, resultSet);
                return null;
            }
        };
        return this.lockForOperation(operImpl, null);
    }

    public final String executeReturnOneCol(final String string, final List<?> list) {
        OperImpl<String> operImpl = new OperImpl<String>(){

            @Override
            public String getSQL() {
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                ResultSet resultSet;
                CallableStatement callableStatement;
                block2: {
                    String string2;
                    callableStatement = null;
                    resultSet = null;
                    try {
                        callableStatement = DBUtil.this.m_conn.prepareCall(string);
                        DBUtil.bind((PreparedStatement)callableStatement, list);
                        resultSet = callableStatement.executeQuery();
                        if (!resultSet.next()) break block2;
                        string2 = resultSet.getString(1);
                    }
                    catch (Throwable throwable) {
                        DBUtil.cleanup(callableStatement, resultSet);
                        throw throwable;
                    }
                    DBUtil.cleanup(callableStatement, resultSet);
                    return string2;
                }
                DBUtil.cleanup(callableStatement, resultSet);
                return null;
            }
        };
        return this.lockForOperation(operImpl, null);
    }

    public final int executeUpdate(final String string, final List<?> list) {
        OperImpl<Integer> operImpl = new OperImpl<Integer>(){

            @Override
            public String getSQL() {
                return string;
            }

            @Override
            public Integer call() throws SQLException {
                Integer n;
                CallableStatement callableStatement = null;
                try {
                    callableStatement = DBUtil.this.m_conn.prepareCall(string);
                    if (list != null) {
                        DBUtil.bind((PreparedStatement)callableStatement, list);
                    }
                    n = callableStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(callableStatement);
                    throw throwable;
                }
                DBUtil.cleanup(callableStatement);
                return n;
            }
        };
        return this.lockForOperation(operImpl, 0);
    }

    public final int executeUpdate(final String string, final Map<String, ?> map) {
        OperImpl<Integer> operImpl = new OperImpl<Integer>(){

            @Override
            public String getSQL() {
                return string;
            }

            @Override
            public Integer call() throws SQLException {
                Integer n;
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = DBUtil.this.prepareExecute(string, map);
                    n = preparedStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(preparedStatement);
                    throw throwable;
                }
                DBUtil.cleanup(preparedStatement);
                return n;
            }
        };
        return this.lockForOperation(operImpl, 0);
    }

    public final boolean execute(String string) {
        return this.execute(string, null, null);
    }

    public final boolean execute(String string, List<?> list) {
        return this.execute(string, list, null);
    }

    public final boolean execute(final String string, final List<?> list, String string2) {
        OperImpl<Boolean> operImpl = new OperImpl<Boolean>(){

            @Override
            public String getSQL() {
                return string;
            }

            @Override
            public Boolean call() throws SQLException {
                Boolean bl;
                CallableStatement callableStatement = null;
                try {
                    callableStatement = DBUtil.this.m_conn.prepareCall(string);
                    if (list != null) {
                        DBUtil.bind((PreparedStatement)callableStatement, list);
                    }
                    bl = callableStatement.execute();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(callableStatement);
                    throw throwable;
                }
                DBUtil.cleanup(callableStatement);
                return bl;
            }
        };
        return this.lockForOperation(operImpl, Boolean.FALSE);
    }

    public final PreparedStatement prepareExecute(final String string, final Map<String, ?> map) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = DBUtil.assertLock(new OperImpl<PreparedStatement>(){

                @Override
                public String getSQL() {
                    return string;
                }

                @Override
                public PreparedStatement call() throws Exception {
                    PreparedStatement preparedStatement = DBUtil.this.prepareExecuteImpl(string, map);
                    return preparedStatement;
                }
            });
            this.clearLastException();
        }
        catch (SQLException sQLException) {
            DBUtil.cleanup(preparedStatement);
            this.handleException(sQLException, string);
            preparedStatement = null;
        }
        catch (Exception exception) {
            DBUtil.cleanup(preparedStatement);
            if (this.m_raiseError) {
                s_conns.getExceptionReporter().raiseException(exception);
            } else {
                LOGGER.severe(exception.getMessage());
            }
            preparedStatement = null;
        }
        return preparedStatement;
    }

    protected PreparedStatement prepareExecuteImpl(String string, Map<String, ?> map) throws SQLException {
        PrepareResult prepareResult = this.prepareNonOracleSql(string, map);
        String string2 = prepareResult.getSQL();
        CallableStatement callableStatement = this.m_conn.prepareCall(string2);
        List<Object> list = prepareResult.getBinds();
        if (list.size() > 0) {
            DBUtil.bind((PreparedStatement)callableStatement, list);
        }
        return callableStatement;
    }

    public final boolean execute(final String string, final Map<String, ?> map) {
        OperImpl<Boolean> operImpl = new OperImpl<Boolean>(){

            @Override
            public Boolean call() {
                PreparedStatement preparedStatement = DBUtil.this.prepareExecute(string, map);
                return DBUtil.this.execute(preparedStatement);
            }
        };
        return this.lockForOperation(operImpl, false);
    }

    private boolean execute(final PreparedStatement preparedStatement) {
        boolean bl = false;
        OperImpl<Boolean> operImpl = new OperImpl<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    preparedStatement.execute();
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    DBUtil.cleanup(preparedStatement);
                }
            }
        };
        try {
            bl = DBUtil.assertLock(operImpl);
            this.clearLastException();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException, null);
        }
        catch (Exception exception) {
            if (this.m_raiseError) {
                s_conns.getExceptionReporter().raiseException(exception);
            }
            LOGGER.severe(exception.getMessage());
        }
        return bl;
    }

    public final ResultSet executeOracleQuery(final String string, final Map<String, ?> map) {
        ResultSet resultSet = null;
        OperImpl<ResultSet> operImpl = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement preparedStatement = null;
                try {
                    ResultSet resultSet;
                    preparedStatement = DBUtil.this.m_conn.prepareStatement(string);
                    if (map != null) {
                        DBUtil.bind(string, preparedStatement, map);
                    }
                    DBUtil.this.setCurrentStatement(preparedStatement);
                    try {
                        resultSet = preparedStatement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        throw sQLException;
                    }
                    finally {
                        DBUtil.this.clearCurrentStatement();
                    }
                    return resultSet;
                }
                catch (SQLException sQLException) {
                    DBUtil.cleanup(preparedStatement);
                    throw sQLException;
                }
            }
        };
        try {
            resultSet = DBUtil.assertLock(operImpl);
            this.clearLastException();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException, string);
        }
        catch (Exception exception) {
            if (this.m_raiseError) {
                String string2 = s_conns.getConnectionName(this.m_conn);
                s_conns.getExceptionReporter().raiseException(exception, string2);
            }
            LOGGER.severe(exception.getMessage());
        }
        return resultSet;
    }

    public ResultSet executeQuery(String string, Map<String, ?> map) {
        return this.executeNonOracleQuery(string, map);
    }

    private String getQueryNonOracleQueryUsingMessageFormat(String string, Map<String, ?> map) {
        PrepareResult prepareResult = this.prepareNonOracleSqlMsgFormat(string, map);
        String string2 = prepareResult.getSQL();
        return string2;
    }

    private ResultSet executeNonOracleQuery(String string, Map<String, ?> map) {
        ResultSet resultSet = null;
        if (string.contains("{:")) {
            string = this.getQueryNonOracleQueryUsingMessageFormat(string, map);
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        final ArrayList arrayList2 = new ArrayList();
        String string2 = string;
        for (Bind object2 : arrayList) {
            arrayList2.add(map.get(object2.getName()));
            string2 = string2.replaceFirst(":" + object2.getName(), "?");
        }
        final String string3 = string2;
        OperImpl<ResultSet> operImpl = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = DBUtil.this.m_conn.prepareStatement(string3);
                    DBUtil.bind(preparedStatement, arrayList2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    return resultSet;
                }
                catch (SQLException sQLException) {
                    DBUtil.cleanup(preparedStatement);
                    throw sQLException;
                }
            }
        };
        try {
            resultSet = DBUtil.assertLock(operImpl);
            this.clearLastException();
        }
        catch (SQLException exception) {
            this.handleException(exception, string3);
        }
        catch (Exception exception) {
            if (this.m_raiseError) {
                s_conns.getExceptionReporter().raiseException(exception);
            }
            LOGGER.severe(exception.getMessage());
        }
        return resultSet;
    }

    public final ResultSet executeQuery(final String string, final List<?> list) {
        ResultSet resultSet = null;
        OperImpl<ResultSet> operImpl = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = DBUtil.this.prepareQuery(string);
                    if (list != null) {
                        DBUtil.bind(preparedStatement, list);
                    }
                    ResultSet resultSet = preparedStatement.executeQuery();
                    return resultSet;
                }
                catch (SQLException sQLException) {
                    DBUtil.cleanup(preparedStatement);
                    throw sQLException;
                }
            }
        };
        try {
            resultSet = DBUtil.assertLock(operImpl);
            this.clearLastException();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException, string);
        }
        catch (Exception exception) {
            if (this.m_raiseError) {
                s_conns.getExceptionReporter().raiseException(exception);
            }
            LOGGER.severe(exception.getMessage());
        }
        return resultSet;
    }

    public final List<List<?>> executeReturnListofList(final String string, final Map<String, ?> map) {
        OperImpl operImpl = new OperImpl<List<List<?>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<List<?>> call() throws SQLException {
                ResultSet resultSet = DBUtil.this.executeQuery(string, map);
                try {
                    int n;
                    ArrayList arrayList = new ArrayList();
                    ArrayList<Object> arrayList2 = null;
                    String[] stringArray = new String[resultSet.getMetaData().getColumnCount()];
                    arrayList2 = new ArrayList<Object>();
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList2.add(resultSet.getMetaData().getColumnName(n + 1));
                    }
                    arrayList.add(arrayList2);
                    while (resultSet.next()) {
                        arrayList2 = new ArrayList();
                        for (n = 0; n < stringArray.length; ++n) {
                            arrayList2.add(resultSet.getObject(n + 1));
                        }
                        arrayList.add(arrayList2);
                    }
                    ArrayList arrayList3 = arrayList;
                    return arrayList3;
                }
                finally {
                    try {
                        DBUtil.cleanup(resultSet);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        return this.lockForOperation(operImpl, null);
    }

    public final List<Map<String, ?>> executeReturnList(final String string, final Map<String, ?> map) {
        OperImpl operImpl = new OperImpl<List<Map<String, ?>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Map<String, ?>> call() throws SQLException {
                ResultSet resultSet = DBUtil.this.executeQuery(string, map);
                try {
                    int n;
                    ArrayList arrayList = new ArrayList();
                    HashMap<String, Object> hashMap = null;
                    String[] stringArray = new String[resultSet.getMetaData().getColumnCount()];
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = resultSet.getMetaData().getColumnName(n + 1);
                    }
                    while (resultSet.next()) {
                        hashMap = new HashMap<String, Object>();
                        for (n = 0; n < stringArray.length; ++n) {
                            hashMap.put(stringArray[n], resultSet.getObject(n + 1));
                        }
                        arrayList.add(hashMap);
                    }
                    ArrayList arrayList2 = arrayList;
                    return arrayList2;
                }
                finally {
                    try {
                        DBUtil.cleanup(resultSet);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        List list = Collections.emptyList();
        return this.lockForOperation(operImpl, list);
    }

    public final Map<String, ?> executeReturnMap(final String string, final Map<String, ?> map) {
        OperImpl operImpl = new OperImpl<Map<String, ?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, ?> call() throws SQLException {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                ResultSet resultSet = DBUtil.this.executeQuery(string, map);
                try {
                    int n;
                    String[] stringArray = new String[resultSet.getMetaData().getColumnCount()];
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = resultSet.getMetaData().getColumnName(n + 1);
                    }
                    while (resultSet.next()) {
                        n = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            hashMap.put(n + "." + stringArray[i], resultSet.getObject(i + 1));
                        }
                        ++n;
                    }
                    HashMap<String, Object> hashMap2 = hashMap;
                    return hashMap2;
                }
                finally {
                    DBUtil.cleanup(resultSet);
                }
            }
        };
        return this.lockForOperation(operImpl, Collections.EMPTY_MAP);
    }

    public static void bind(final PreparedStatement preparedStatement, final Map<String, ?> map) throws SQLException {
        if (map.size() == 0) {
            return;
        }
        try {
            DBUtil.assertLock(new StatementOperImpl<Void>((Statement)preparedStatement){

                @Override
                public Void call() throws SQLException {
                    if (preparedStatement instanceof OraclePreparedStatement) {
                        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
                        Object var2_3 = null;
                        for (String string : map.keySet()) {
                            var2_3 = map.get(string);
                            try {
                                if (var2_3 == NULL_VALUE) {
                                    oraclePreparedStatement.setNullAtName(string, 12);
                                    continue;
                                }
                                if (var2_3 instanceof String) {
                                    oraclePreparedStatement.setStringAtName(string, (String)var2_3);
                                    continue;
                                }
                                if (var2_3 instanceof BigDecimal) {
                                    oraclePreparedStatement.setBigDecimalAtName(string, (BigDecimal)var2_3);
                                    continue;
                                }
                                if (var2_3 instanceof CLOB) {
                                    oraclePreparedStatement.setCLOBAtName(string, (CLOB)var2_3);
                                    continue;
                                }
                                oraclePreparedStatement.setObjectAtName(string, var2_3);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        DBUtil.logStateException(new IllegalStateException("Non Oracle statement with bind names"), "{0} called with a non Oracle statement; {1} called {2}");
                        Iterator iterator = map.values().iterator();
                        ArrayList arrayList = new ArrayList(16);
                        while (iterator.hasNext()) {
                            arrayList.add(iterator.next());
                        }
                        DBUtil.bind(preparedStatement, arrayList);
                    }
                    return null;
                }
            });
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bind(final PreparedStatement preparedStatement, final List<?> list) throws SQLException {
        StatementOperImpl<Void> statementOperImpl = new StatementOperImpl<Void>((Statement)preparedStatement){

            @Override
            public Void call() throws SQLException {
                int n = 1;
                for (Object e : list) {
                    if (e == NULL_VALUE || e instanceof String && ((String)e).equals(DBUtil.EMPTY_STRING)) {
                        preparedStatement.setNull(n, 12);
                    } else if (e instanceof String) {
                        preparedStatement.setString(n, (String)e);
                    } else if (e instanceof BigDecimal) {
                        preparedStatement.setBigDecimal(n, (BigDecimal)e);
                    } else if (e instanceof Date) {
                        preparedStatement.setDate(n, (Date)e);
                    } else if (e instanceof Integer) {
                        preparedStatement.setInt(n, (Integer)e);
                    } else if (e instanceof Array) {
                        preparedStatement.setArray(n, (Array)e);
                    } else if (e instanceof Blob) {
                        preparedStatement.setBlob(n, (Blob)e);
                    } else if (e instanceof Boolean) {
                        preparedStatement.setBoolean(n, (Boolean)e);
                    } else if (e instanceof Byte) {
                        preparedStatement.setByte(n, (Byte)e);
                    } else if (e instanceof byte[]) {
                        preparedStatement.setBytes(n, (byte[])e);
                    } else if (e instanceof Clob) {
                        preparedStatement.setClob(n, (Clob)e);
                    } else if (e instanceof Double) {
                        preparedStatement.setDouble(n, (Double)e);
                    } else if (e instanceof Float) {
                        preparedStatement.setFloat(n, ((Float)e).floatValue());
                    } else if (e instanceof Integer) {
                        preparedStatement.setInt(n, (Integer)e);
                    } else if (e instanceof Long) {
                        preparedStatement.setLong(n, (Long)e);
                    } else if (e instanceof NClob) {
                        preparedStatement.setNClob(n, (NClob)e);
                    } else if (e instanceof String) {
                        preparedStatement.setNString(n, (String)e);
                    } else if (e instanceof Ref) {
                        preparedStatement.setRef(n, (Ref)e);
                    } else if (e instanceof RowId) {
                        preparedStatement.setRowId(n, (RowId)e);
                    } else if (e instanceof Short) {
                        preparedStatement.setShort(n, (Short)e);
                    } else if (e instanceof String) {
                        preparedStatement.setString(n, (String)e);
                    } else if (e instanceof SQLXML) {
                        preparedStatement.setSQLXML(n, (SQLXML)e);
                    } else if (e instanceof Time) {
                        preparedStatement.setTime(n, (Time)e);
                    } else if (e instanceof Timestamp) {
                        preparedStatement.setTimestamp(n, (Timestamp)e);
                    } else if (e instanceof URL) {
                        preparedStatement.setURL(n, (URL)e);
                    } else {
                        preparedStatement.setObject(n, e);
                    }
                    ++n;
                }
                return null;
            }
        };
        try {
            DBUtil.assertLock(statementOperImpl);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDBMSOUTPUT() {
        throw new UnsupportedOperationException("getDBMSOUTPUT");
    }

    public void handleException(Exception exception) {
        String string = exception.getMessage();
        MessageLogging.getInstance().log(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getDbVersion(Connection connection) {
        if (connection == null) {
            return ORACLE10g_VERSION;
        }
        Version version = VERSION_CACHE.get(connection);
        if (version == null) {
            version = DBUtil.getInstance(connection).fetchDbVersion();
            Map<Connection, Version> map = VERSION_CACHE;
            synchronized (map) {
                VERSION_CACHE.put(connection, version);
            }
        }
        return version;
    }

    private Version fetchDbVersion() {
        OperImpl<String> operImpl = new OperImpl<String>(){

            @Override
            public String call() throws Exception {
                return DBUtil.this.fetchDbVersionImpl();
            }
        };
        String string = this.lockForOperation(operImpl, VERSION_10G_STRING);
        Matcher matcher = s_pattern.matcher(string);
        String string2 = matcher.find() ? matcher.group() : "1.0.0";
        return new Version(string2);
    }

    protected String fetchDbVersionImpl() throws SQLException, ThreadDeath {
        String string;
        DatabaseMetaData databaseMetaData = null;
        databaseMetaData = this.m_conn.getMetaData();
        try {
            string = databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion() + ".0";
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            try {
                string = databaseMetaData.getDatabaseProductVersion();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                string = "1.0.0";
            }
        }
        return string;
    }

    public static synchronized boolean checkVersion(String string, Version version, Version version2) {
        try {
            return DBUtil.checkVersion(s_conns.getConnection(string), version, version2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
    }

    public static boolean checkVersion(Connection connection, Version version, Version version2) {
        Version version3;
        try {
            version3 = DBUtil.getDbVersion(connection);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            version3 = null;
        }
        return DBUtil.checkVersion(version3, version, version2);
    }

    public static boolean checkVersion(Version version, Version version2, Version version3) {
        boolean bl = false;
        if (version == null || (version3 == null || version3.compareTo(version) <= 0) && (version2 == null || version2.compareTo(version) >= 0)) {
            bl = true;
        }
        return bl;
    }

    public final String getCurrentError() {
        return m_currentErrorString != null ? m_currentErrorString : EMPTY_STRING;
    }

    public int getErrorOffset(String string) {
        throw new UnsupportedOperationException("getErrorOffset");
    }

    public static String addDoubleQuote(String string) {
        return DBUtil.quoteIdentifier(string, '\"');
    }

    public void setRaiseError(boolean bl) {
        this.m_raiseError = bl;
    }

    public static String quoteIdentifier(String string, char c) {
        return OracleUtil.getReservedWords().contains(string) ? c + string + c : Service.quoteIdentifier(string, c);
    }

    public static List<String> getBinds(String string) {
        return Parser.getInstance().getBindNames(string);
    }

    public static List<String> getBinds(String string, boolean bl) {
        return Parser.getInstance().getBindNames(string, bl);
    }

    public static void bind(String string, PreparedStatement preparedStatement, Map map) throws SQLException {
        if (map != null) {
            HashMap hashMap = new HashMap();
            Iterator iterator = map.keySet().iterator();
            String string2 = null;
            Object var6_6 = null;
            HashSet<String> hashSet = new HashSet<String>(DBUtil.getBinds(string));
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                var6_6 = map.get(string2);
                if (!hashSet.contains(string2.intern())) continue;
                hashMap.put(string2, map.get(string2));
            }
            DBUtil.bind(preparedStatement, hashMap);
        }
    }

    public String scrubObjectName(String string) {
        return string.indexOf(QUOTE_DELIMITER) > -1 ? string.replaceAll(QUOTE_DELIMITER, EMPTY_STRING) : string.toUpperCase();
    }

    public static String[] resolveDBLink(String string) {
        String[] stringArray = string.split("@");
        return stringArray.length == 2 ? stringArray : null;
    }

    public Map<String, String> resolveName(String string) {
        return null;
    }

    public Map<String, String> resolveName(String string, boolean bl) {
        return null;
    }

    public final String prepareOracleSql(String string) {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        String string2 = string;
        int n = 1;
        for (Bind bind : arrayList) {
            string2 = string2.replaceFirst(":" + bind.getName(), ":ZSqlDevUnIq" + n);
            ++n;
        }
        return string2;
    }

    public final String prepareNonOracleSql(String string) {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        String string2 = string;
        for (Bind bind : arrayList) {
            string2 = string2.replaceFirst(":" + bind.getName(), "?");
        }
        return string2;
    }

    protected PreparedStatement prepareQuery(String string) throws SQLException {
        String string2 = this.prepareNonOracleSql(string);
        return this.m_conn.prepareStatement(string2);
    }

    public final PrepareResult prepareNonOracleSql(String string, Map<String, ?> map) {
        if (string.indexOf("{:") != -1) {
            string = this.prepareNonOracleSqlMsgFormat(string, map).getSQL();
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string2 = string;
        for (Bind bind : arrayList) {
            if (map != null) {
                arrayList2.add(map.get(bind.getName()));
            }
            string2 = string2.replaceFirst(":" + bind.getName(), "?");
        }
        return new PrepareResult(string2, arrayList2);
    }

    private PrepareResult prepareNonOracleSqlMsgFormat(String string, Map<String, ?> map) {
        int n = 0;
        String string2 = string;
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string3 = string;
        for (Bind bind : arrayList) {
            if (map == null) continue;
            if (map.get(bind.getName()) instanceof String) {
                String string4;
                String string5 = (String)map.get(bind.getName());
                string5 = (string5 = string5.trim()).contains(string4 = " ") ? this.addDbQuotes(string5, true) : this.addDbQuotes(string5, false);
                arrayList2.add(string5);
            } else {
                arrayList2.add(map.get(bind.getName()));
            }
            string3 = string3.replaceFirst("\\{:" + bind.getName(), "{" + Integer.toString(n++));
        }
        string3 = string3.replaceAll("'", "''");
        string2 = MessageFormat.format(string3, arrayList2.toArray());
        return new PrepareResult(string2, arrayList2);
    }

    public final String addDbQuotes(String string) {
        return this.addDbQuotes(string, true);
    }

    public String addDbQuotes(String string, boolean bl) {
        char c = this.getQuoteCharacter();
        if (bl) {
            return string.indexOf(c) >= 0 ? string : c + string + c;
        }
        return DBUtil.quoteIdentifier(string, c);
    }

    protected char getQuoteCharacter() {
        return '\"';
    }

    public final SQLException getLastException() {
        SQLException sQLException = this.peekLastException();
        this.clearLastException();
        return sQLException;
    }

    private void clearLastException() {
        this.m_lastException.set(null);
    }

    private void setLastException(SQLException sQLException) {
        this.m_lastException.set(sQLException);
    }

    private SQLException peekLastException() {
        return this.m_lastException.get();
    }

    private void handleException(SQLException sQLException, String string) {
        SQLException sQLException2 = this.getLastException();
        if (sQLException2 != null) {
            LOGGER.severe(MessageFormat.format(Messages.getString("DBUtil_UNHANDLED_EXCEPTION"), sQLException2.getLocalizedMessage()));
        }
        if (this.m_raiseError) {
            s_conns.getExceptionReporter().raiseException(sQLException, this.m_cname, string, -1);
        } else {
            this.setLastException(sQLException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "Oracle Database 11g Enterprise Edition Release 11.2.0.1.0 - 64bit Production";
        String[] stringArray2 = string.split(" ");
        String string2 = ".*[0-9]\\.+[0-9]\\.+.*";
        String string3 = null;
        for (String string4 : stringArray2) {
            System.out.println(string4);
            if (!Pattern.matches(string2, string4)) continue;
            string3 = string4;
            System.out.println("--Matched");
        }
    }

    public static boolean hasTransaction(String string) {
        return DBUtil.getInstance(string).hasTransaction();
    }

    public static boolean hasTransaction(Connection connection) {
        return DBUtil.getInstance(connection).hasTransaction();
    }

    protected boolean hasTransaction() {
        throw new UnsupportedOperationException("hasTransaction");
    }

    public static boolean isOracleConnectionAlive(Connection connection) {
        if (connection == null) {
            return false;
        }
        return DBUtil.getInstance(connection).isOracleConnectionAlive();
    }

    protected boolean isOracleConnectionAlive() {
        throw new UnsupportedOperationException("isOracleConnectionAlive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V lockForOperation(LockableOperation<V> lockableOperation, V v) {
        V v2 = v;
        Connection connection = lockableOperation.getConnection();
        if (s_conns.lock(connection)) {
            try {
                SQLException sQLException = this.peekLastException();
                v2 = lockableOperation.call();
                if (sQLException == this.peekLastException()) {
                    this.clearLastException();
                }
            }
            catch (SQLException sQLException) {
                this.handleException(sQLException, lockableOperation.getSQL());
            }
            catch (Exception exception) {
                if (this.m_raiseError) {
                    s_conns.getExceptionReporter().raiseException(exception);
                } else {
                    m_currentErrorString = exception.getMessage();
                    LOGGER.info(exception.getMessage());
                }
            }
            finally {
                s_conns.unlock(connection);
            }
        }
        return v2;
    }

    private static <V> V assertLock(LockableOperation<V> lockableOperation) throws Exception {
        Object object;
        if (DEBUG_BUILD && s_lockCheckCount.get() == 0 && !s_conns.checkLock(lockableOperation.getConnection())) {
            object = new IllegalMonitorStateException(Messages.getString("DBUtil.112"));
            DBUtil.logStateException(object, "Illegal Lock State: {0} requires connection lock to be held. {1} called {2} without it");
        }
        s_lockCheckCount.set(s_lockCheckCount.get() + 1);
        try {
            object = lockableOperation.call();
            return object;
        }
        finally {
            s_lockCheckCount.set(s_lockCheckCount.get() - 1);
        }
    }

    private static void logStateException(Exception exception, String string) {
        Object[] objectArray;
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = 1;
        StackTraceElement stackTraceElement = stackTraceElementArray[n++];
        String string2 = stackTraceElement.getClassName();
        StackTraceElement stackTraceElement2 = null;
        StackTraceElement stackTraceElement3 = null;
        while (n < stackTraceElementArray.length) {
            objectArray = stackTraceElementArray[n];
            if (!string2.equals(objectArray.getClassName())) {
                stackTraceElement2 = stackTraceElementArray[n - 1];
                stackTraceElement3 = objectArray;
                break;
            }
            ++n;
        }
        objectArray = new Object[]{stackTraceElement.getMethodName(), stackTraceElement3.toString(), stackTraceElement2.toString()};
        MessageLogging.getInstance().reportAPIException(MessageFormat.format(string, objectArray), exception, stackTraceElement.getMethodName());
        LOGGER.log(Level.SEVERE, string, objectArray);
    }

    protected static void cleanup(Statement statement) {
        DBUtil.cleanup(statement, null);
    }

    protected static void cleanup(ResultSet resultSet) {
        if (resultSet != null) {
            Statement statement = null;
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                LOGGER.warning(sQLException.getLocalizedMessage());
            }
            DBUtil.cleanup(statement, resultSet);
        }
    }

    protected static void cleanup(Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                LOGGER.warning(exception.getLocalizedMessage());
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        DBUtil.cleanup(resultSet);
    }

    public TriState hasAccessCached(String string) {
        String string2 = string.toLowerCase();
        if (this.m_accessCache.containsKey(string2)) {
            if (this.m_accessCache.get(string2) == Boolean.TRUE) {
                return TriState.TRUE;
            }
            return TriState.FALSE;
        }
        return TriState.UNDEF;
    }

    public final boolean hasAccess(String string) {
        String string2 = string.toLowerCase();
        if (this.m_accessCache.containsKey(string2)) {
            return this.m_accessCache.get(string2);
        }
        boolean bl = false;
        if (this.m_conn != null) {
            bl = this.checkAccess(string2);
            this.m_accessCache.put(string2, bl);
        }
        return bl;
    }

    protected boolean checkAccess(String string) {
        boolean bl = false;
        try (Statement statement = this.m_conn.createStatement();){
            String string2 = "select 1 from " + string + " where 1=2";
            statement.execute(string2);
            bl = true;
        }
        catch (SQLException sQLException) {
            LOGGER.info(string + oracle.dbtools.raptor.query.Messages.getString("QueryUtils.31"));
        }
        return bl;
    }

    static {
        s_execThreadMap = new HashMap<Thread, Statement>();
        VERSION_CACHE = new WeakHashMap<Connection, Version>();
        s_instanceMap = new WeakHashMap<Connection, DBUtil>();
        s_utilImpls = new HashMap<String, Constructor<? extends DBUtil>>();
        try {
            DBUtil.registerUtilForType("Oracle", OracleUtil.class.getDeclaredConstructor(String.class, Connection.class));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            LOGGER.severe(throwable.getLocalizedMessage());
        }
        s_pattern = Pattern.compile(VERSION_PATTERN);
        ORACLE8_VERSION = new Version("8");
        ORACLE8i_VERSION = new Version("8.1");
        ORACLE9i_VERSION = new Version("9");
        ORACLE9iR2_VERSION = new Version("9.2");
        ORACLE10g_VERSION = new Version(VERSION_10G_STRING);
        ORACLE10gR2_VERSION = new Version("10.2");
        ORACLE11g_VERSION = new Version("11");
        ORACLE12c_VERSION = new Version("12");
        DEBUG_BUILD = Boolean.getBoolean("sqldev.debugbuild");
        s_lockCheckCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    private static abstract class StatementOperImpl<V>
    implements LockableOperation<V> {
        private Connection m_conn;

        private StatementOperImpl(Statement statement) throws SQLException {
            this.m_conn = statement.getConnection();
        }

        @Override
        public Connection getConnection() {
            return this.m_conn;
        }

        @Override
        public String getSQL() {
            return null;
        }

        @Override
        public int getOffset() {
            return -1;
        }
    }

    protected abstract class OperImpl<V>
    implements LockableOperation<V> {
        protected OperImpl() {
        }

        @Override
        public Connection getConnection() {
            return DBUtil.this.m_conn;
        }

        @Override
        public String getSQL() {
            return null;
        }

        @Override
        public int getOffset() {
            return -1;
        }
    }

    protected static interface LockableOperation<V>
    extends Callable<V> {
        public Connection getConnection();

        public String getSQL();

        public int getOffset();
    }
}

