/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;

public class ConnectionDetails {
    private String _type = null;
    private String _url = null;
    private String _driver = null;
    private Connection _conn = null;
    private Properties _properties = new Properties();
    private static HashMap<String, String> _typeDriverMap = new HashMap();

    public ConnectionDetails(String string) {
        ConnectionDetails.registerDriver("jdbc:jtds:sqlserver", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:jtds:sybase", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:as400:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:db2:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:informix", "com.ibm.informix.Driver");
        ConnectionDetails.registerDriver("jdbc:mysql:", "com.mysql.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:postgresql:", "org.postgresql.Driver");
        ConnectionDetails.registerDriver("jdbc:teradata:", "com.teradata.jdbc.TeraDriver");
        ConnectionDetails.registerDriver("jdbc:oracle:thin:", "oracle.jdbc.OracleDriver");
        this.setUrl(string);
        for (String string2 : _typeDriverMap.keySet()) {
            if (!this.getUrl().startsWith(string2)) continue;
            this.setType(string2);
            this.setDriver(_typeDriverMap.get(string2));
            break;
        }
    }

    private static void registerDriver(String string, String string2) {
        _typeDriverMap.put(string, string2);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) {
        if (string.startsWith("[")) {
            string = this.processURL(string);
        }
        this._url = string = this.resolveHashAmpersand(string);
    }

    private String processURL(String string) {
        int n = string.indexOf("]");
        String string2 = string.substring(1, n);
        this.processArgs(string2);
        string = string.substring(n + 1);
        return string;
    }

    private void processArgs(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length <= 1) continue;
            this._properties.put(stringArray2[0], stringArray2[1]);
        }
    }

    private String resolveHashAmpersand(String string) {
        return string.replace('#', '&');
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String string) {
        this._driver = string;
    }

    public Connection getConn() {
        if (this._conn == null) {
            try {
                Class<?> clazz = Class.forName(this.getDriver());
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(driver);
                this._conn = this._properties.size() == 2 && this._properties.containsKey("USERNAME") && this._properties.containsKey("PASSWORD") ? DriverManager.getConnection(this.getUrl(), this._properties.getProperty("USERNAME"), this._properties.getProperty("PASSWORD")) : (this._properties.size() > 0 ? DriverManager.getConnection(this.getUrl(), this._properties) : DriverManager.getConnection(this.getUrl()));
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
            }
        }
        return this._conn;
    }

    public void setConn(Connection connection) {
        this._conn = connection;
    }
}

