/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.data.readservice.ReadService;

public class ReadServiceDelimited
extends ReadService {
    public static final String NAME = "Delimited";
    public static final String FORMAT = "delimited";
    public static final String EXT = "dsv";
    public static final int BUFFER_SIZE = 1024;
    public static final int BUFFER_KSIZE = 1;
    private BufferedReader _reader;
    private InputStream _inputStream;
    private ReadParmsDelimitedAPI _parms;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private String[] m_headerRowColumnNames;
    private int m_columnCount = -1;
    private String m_currentRow = null;
    private boolean m_currentRowRead = true;
    private String[] m_firstRow = null;
    private int m_rowsRead = 0;

    public ReadServiceDelimited(InputStream inputStream, ReadParmsDelimitedAPI readParmsDelimitedAPI) {
        this(inputStream, readParmsDelimitedAPI, null);
    }

    public ReadServiceDelimited(InputStream inputStream, ReadParmsDelimitedAPI readParmsDelimitedAPI, Iterable<Locale> iterable) {
        this._inputStream = inputStream;
        this._parms = readParmsDelimitedAPI == null ? new ReadParmsDelimitedAPI.Builder().build() : readParmsDelimitedAPI;
        super.setResponseLocales(iterable);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    protected void setLogger(Logger logger) {
        this.LOGGER = logger;
        super.setLogger(logger);
    }

    @Override
    public String[] getColumnNames() throws DataFormatException {
        try {
            int n;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this._parms.isHeaderBeforeSkip()) {
                for (n = 0; n < this._parms.getSkipRows(); ++n) {
                    if (this.hasMoreRows()) continue;
                    this.readLine(this._reader);
                }
            }
            if (this.hasMoreRows()) {
                this.m_firstRow = (String[])this.readline();
            }
            while (this.hasMoreRows() && this.m_firstRow != null && (this.m_firstRow.length == 0 || this.m_firstRow.length == 1 && this.m_firstRow[0].length() == 0)) {
                this.m_firstRow = (String[])this.readline();
            }
            if (this.m_firstRow != null && this.m_firstRow.length > 0) {
                for (n = 0; n < this.m_firstRow.length; ++n) {
                    if (this.m_firstRow[n] == null) continue;
                    if (hashMap.containsKey(this.m_firstRow[n])) {
                        hashMap.put(this.m_firstRow[n], (Integer)hashMap.get(this.m_firstRow[n]) + 1);
                        arrayList.add(this.m_firstRow[n].toString() + hashMap.get(this.m_firstRow[n]));
                        continue;
                    }
                    hashMap.put(this.m_firstRow[n], 1);
                    arrayList.add(this.m_firstRow[n]);
                }
                this.m_headerRowColumnNames = arrayList.toArray(new String[arrayList.size()]);
            }
            int n2 = this.m_columnCount = this.m_headerRowColumnNames == null ? 0 : this.m_headerRowColumnNames.length;
            if (!this._parms.isHeaderBeforeSkip()) {
                for (n = 0; n < this._parms.getSkipRows(); ++n) {
                    if (this.hasMoreRows()) continue;
                    this.readLine(this._reader);
                }
            }
        }
        catch (IOException iOException) {
            this.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return this.m_headerRowColumnNames;
    }

    private String[] splitRow(String string) throws DataFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this._parms.getDelimiterValue();
        int n = string2.length();
        int n2 = -1;
        if (n != 0) {
            int n3 = 0;
            int n4 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            if (this._parms.isDelimiterWhiteSpace()) {
                string2 = "\t";
                n = 1;
            }
            String string3 = this._parms.getEnclosureLeft();
            String string4 = this._parms.getEnclosureRight();
            boolean bl = this._parms.isEnclosed();
            if (n4 == 2) {
                n4 = 0;
            }
            int n5 = 0;
            while (n5 < string.length()) {
                char c = string.charAt(n5);
                switch (n4) {
                    case 0: {
                        if (bl && string.startsWith(string3, n5)) {
                            n5 += string3.length();
                            n4 = 1;
                            break;
                        }
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (!this._parms.isDelimiterWhiteSpace()) break;
                            n4 = 2;
                            break;
                        }
                        stringBuilder.append(c);
                        ++n5;
                        break;
                    }
                    case 1: {
                        if (bl && string.startsWith(string4, n5)) {
                            n5 += string4.length();
                            n4 = this._parms.isEnclosureRightDouble() ? 3 : 4;
                            break;
                        }
                        stringBuilder.append(c);
                        ++n5;
                        break;
                    }
                    case 2: {
                        if (!this.isThisDelimiter(string, n5, string2)) {
                            if (bl && string.startsWith(string3, n5)) {
                                n4 = 1;
                                stringBuilder = new StringBuilder();
                                n5 += string3.length();
                                break;
                            }
                            n4 = 0;
                            ++n5;
                            stringBuilder.append(c);
                            break;
                        }
                        n5 += n;
                        break;
                    }
                    case 3: {
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (this._parms.isDelimiterWhiteSpace()) {
                                n4 = 2;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        if (string.startsWith(string4, n5)) {
                            stringBuilder.append(c);
                            ++n5;
                            n4 = 1;
                            break;
                        }
                        if (n2 == -1) {
                            n2 = n5;
                        }
                        stringBuilder.append(string4 + c);
                        ++n5;
                        n4 = 5;
                        break;
                    }
                    case 4: {
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (this._parms.isDelimiterWhiteSpace()) {
                                n4 = 2;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        if (string.startsWith(string4, n5)) {
                            stringBuilder.append(string4);
                            ++n5;
                            break;
                        }
                        stringBuilder.append(string4 + c);
                        ++n5;
                        n4 = 1;
                        break;
                    }
                    case 5: {
                        stringBuilder.append(c);
                        ++n5;
                    }
                }
            }
            if (n4 == 0) {
                arrayList.add(stringBuilder.toString());
                n3 = 0;
                stringBuilder = new StringBuilder();
            } else if (n4 == 1) {
                arrayList.add(string3 + stringBuilder.toString());
                if (n2 == -1) {
                    n2 = string.length() - 1;
                }
            } else if (n4 != 0) {
                arrayList.add(stringBuilder.toString());
            }
        } else {
            arrayList.add(string);
        }
        if (n2 != -1) {
            String string5 = this.translate("ENCLOSURE_ERR") + " " + (n2 + 1);
            throw new DataFormatException(string5, n2 + 1, string, arrayList.toArray(new String[arrayList.size()]));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isThisDelimiter(String string, int n, String string2) {
        if (this._parms.isDelimiterWhiteSpace()) {
            return string.startsWith(string2, n) || string.startsWith(" ", n);
        }
        return string.startsWith(string2, n);
    }

    @Override
    public boolean hasMoreRows() {
        boolean bl = this.m_currentRowRead;
        this.m_currentRowRead = false;
        try {
            if (!bl) {
                return true;
            }
            if (!this._parms.isLimitRows() || this.m_rowsRead < this._parms.getLimitRows()) {
                this.m_currentRow = this.readLine(this._reader);
                if (this.m_currentRow != null) {
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            this.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.m_currentRow = null;
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void start() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
            this._reader = this.getReader();
        }
        catch (IOException iOException) {
            this.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.m_currentRow = null;
    }

    private BufferedReader getReader() {
        BufferedReader bufferedReader = null;
        this.m_currentRow = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this._inputStream, this._parms.getEncoding()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedReader;
    }

    @Override
    public void close() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException iOException) {
            this.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.m_currentRow = null;
        this._reader = null;
    }

    public static void main(String[] stringArray) {
        try {
            ReadServiceDelimited readServiceDelimited = new ReadServiceDelimited(new FileInputStream(new File("d:/family.csv")), null);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    @Override
    public Object[] readline() throws DataFormatException {
        Object[] objectArray = this.splitRow(this.m_currentRow);
        this.m_currentRowRead = true;
        return objectArray;
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        if (!this._parms.isStandardTerminator()) {
            StringBuffer stringBuffer;
            block3: {
                String string = this._parms.getTerminator();
                char[] cArray = new char[1];
                int n = bufferedReader.read(cArray);
                if (n == -1) {
                    return null;
                }
                ++this.m_rowsRead;
                int n2 = n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(cArray);
                String string2 = "";
                do {
                    n = bufferedReader.read(cArray);
                    n2 += n;
                    if (n == -1) break block3;
                    stringBuffer.append(cArray);
                } while (stringBuffer.length() < string.length() || string.length() <= 0 || !(string2 = stringBuffer.substring(stringBuffer.length() - string.length(), stringBuffer.length())).equals(string));
                return stringBuffer.substring(0, stringBuffer.length() - string.length());
            }
            return stringBuffer.length() == 0 ? null : stringBuffer.toString();
        }
        return bufferedReader.readLine();
    }
}

