/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import oracle.dbtools.data.readservice.ReadParmsAPI;

public class ReadParmsDelimitedAPI
extends ReadParmsAPI {
    public static String DEFAULT_ENCODING = "UTF8";
    public static String DEFAULT_DELIMITER = ",";
    public static String DEFAULT_ENCLOSURE = "\"";
    public static int UNLIMITED = -1;
    public static final String EOL_CRLF = "\r\n";
    public static final String EOL_LF = "\n";
    public static final String EOL_CR = "\r";
    private ReadParmsAPI.SERVICE_TYPE _serviceType;
    private String _encoding = DEFAULT_ENCODING;
    private String _delimiter = DEFAULT_DELIMITER;
    private String _enclosureLeft = DEFAULT_ENCLOSURE;
    private String _enclosureRight = DEFAULT_ENCLOSURE;
    private boolean _enclosureRightDouble;
    private String _lineEnd;
    private int _lineMax;

    private ReadParmsDelimitedAPI(Builder builder) {
        super(builder._header, builder._headerBeforeSkip, builder._skipRows, builder._limitRows);
        this._serviceType = builder._serviceType;
        this._encoding = this.notNull(builder._encoding);
        this._delimiter = this.notNull(builder._delimiter);
        this._enclosureLeft = this.notNull(builder._enclosureLeft);
        this._enclosureRight = this.notNull(builder._enclosureRight);
        this._enclosureRightDouble = builder._enclosureRightDouble;
        this._lineEnd = builder._lineEnd;
        this._lineMax = builder._lineMax;
        this.validateParm(PARMS.SERVICE_TYPE, (Object)this._serviceType);
        this.validateParm(PARMS.DELIMITER, this._delimiter);
        if (this._enclosureLeft.length() > 0 && this._enclosureRight.length() == 0) {
            this._enclosureRight = this._enclosureLeft;
        }
        if (this._lineMax < 1) {
            this._lineMax = UNLIMITED;
        }
        if (this.getSkipRows() < 0) {
            throw new IllegalStateException(PARMS.SKIP_ROWS.toString());
        }
    }

    private void validateParm(Enum<PARMS> enum_, Object object) {
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            throw new IllegalStateException(enum_.toString());
        }
    }

    private String notNull(String string) {
        return string != null ? string : "";
    }

    @Override
    public ReadParmsAPI.SERVICE_TYPE getServiceType() {
        return this._serviceType;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public static boolean isDelimiterWhiteSpace(String string) {
        return string.length() > 1 && string.equals("  ");
    }

    public boolean isDelimiterWhiteSpace() {
        return this._delimiter.length() > 1 && this._delimiter.equals("  ");
    }

    public String getDelimiterValue() {
        String string = this.getDelimiter();
        if (string != null && string.length() > 0) {
            if (string.equals("TAB")) {
                string = "\t";
            } else if (string.equals("WHITESPACE")) {
                string = "  ";
            } else if (string.equals("SPACE")) {
                string = " ";
            }
        }
        return string;
    }

    public static String getDelimiterString(String string) {
        String string2 = string;
        if (string2.equals("TAB")) {
            string2 = "X'09'";
        } else if (string2.equals("WHITESPACE")) {
            string2 = "WHITESPACE";
        } else if (string2.equals("SPACE")) {
            string2 = " ";
        }
        if (string2.equals("\t")) {
            return "\\t";
        }
        return string2;
    }

    public boolean isEnclosed() {
        return this.getEnclosureLeft().length() != 0 && this.getEnclosureRight().length() != 0;
    }

    public String getEnclosureLeft() {
        return this._enclosureLeft;
    }

    public String getEnclosureRight() {
        return this._enclosureRight;
    }

    public boolean isEnclosureRightDouble() {
        return this._enclosureRightDouble;
    }

    public static String getEnvTerminatorValue() {
        return System.getProperty("line.separator");
    }

    public String getTerminator() {
        return this._lineEnd;
    }

    public boolean isStandardTerminator() {
        return this._lineEnd == null || this._lineEnd.equalsIgnoreCase(EOL_CRLF) || this._lineEnd.equals(EOL_CR) || this._lineEnd.equals(EOL_LF);
    }

    public boolean getUseMaxLength() {
        return this._lineMax > 0;
    }

    public int getMaxLength() {
        return this._lineMax;
    }

    public static class Builder {
        private String _format = "CSV";
        private ReadParmsAPI.SERVICE_TYPE _serviceType;
        private boolean _header = true;
        private boolean _headerBeforeSkip = true;
        private int _skipRows = 0;
        private int _limitRows = UNLIMITED;
        private String _encoding = DEFAULT_ENCODING;
        private String _delimiter = DEFAULT_DELIMITER;
        private String _enclosureLeft = DEFAULT_ENCLOSURE;
        private String _enclosureRight = DEFAULT_ENCLOSURE;
        private boolean _enclosureRightDouble;
        private String _lineEnd;
        private int _lineMax = UNLIMITED;

        public Builder() {
            this._serviceType = ReadParmsAPI.SERVICE_TYPE.CSV;
        }

        public Builder header(boolean bl) {
            this._header = bl;
            return this;
        }

        public Builder headerBeforeSkip(boolean bl) {
            this._headerBeforeSkip = bl;
            return this;
        }

        public Builder skipRows(int n) {
            this._skipRows = n;
            return this;
        }

        public Builder limitRows(int n) {
            this._limitRows = n;
            return this;
        }

        public Builder encoding(String string) {
            this._encoding = string == null ? DEFAULT_ENCODING : string;
            return this;
        }

        public Builder delimiter(String string) {
            this._delimiter = string;
            return this;
        }

        public Builder enclosures(String string) {
            if (string == null || string.length() == 0) {
                this._enclosureLeft = "";
                this._enclosureRight = "";
            } else if (string.length() == 1) {
                this._enclosureLeft = string;
                this._enclosureRight = string;
            } else {
                this._enclosureLeft = string.substring(0, 0);
                this._enclosureRight = string.substring(1, 1);
            }
            return this;
        }

        public Builder enclosureLeft(String string) {
            this._enclosureLeft = string;
            return this;
        }

        public Builder enclosureRight(String string) {
            this._enclosureRight = string;
            return this;
        }

        public Builder enclosureRightDouble(boolean bl) {
            this._enclosureRightDouble = bl;
            return this;
        }

        public Builder lineEnd(String string) {
            if (string.equals("\\r")) {
                this._lineEnd = ReadParmsDelimitedAPI.EOL_CR;
            } else if (string.equals("\\r\\n")) {
                this._lineEnd = ReadParmsDelimitedAPI.EOL_CRLF;
            } else if (string.equals("\\n")) {
                this._lineEnd = ReadParmsDelimitedAPI.EOL_LF;
            }
            this._lineEnd = string;
            return this;
        }

        public Builder lineMax(int n) {
            this._lineMax = n;
            return this;
        }

        public ReadParmsDelimitedAPI build() {
            return new ReadParmsDelimitedAPI(this);
        }
    }

    private static enum PARMS {
        SERVICE_TYPE,
        HEADER,
        SKIP_BEFORE_HEADER,
        SKIP_ROWS,
        LIMIT_ROWS,
        ENCODING,
        DELIMITER,
        LEFT_ENCLOSURE,
        RIGHT_ENCLOSURE,
        RIGHT_ENCLOSURE_DOUBLE,
        LINE_END,
        MAX_LENGTH;

    }
}

