/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import java.text.NumberFormat;
import java.text.ParsePosition;
import oracle.dbtools.data.formattors.BaseFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NumberFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column column) {
        String string = null;
        string = this.addDoubleQuote(column.getName()) + " " + column.getType();
        if (column.getName() != null && this.isPrecisionAllowed() && column.getPrecision() > 0) {
            string = column.getScale() > 0 ? string + "(" + column.getPrecision() + ", " + column.getScale() + ")" : string + "(" + column.getPrecision() + ")";
        }
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    @Override
    public String formatData(Object object, Column column) {
        String string = "NULL";
        if (object != null) {
            String string2 = object.toString();
            NumberFormat numberFormat = null;
            ParsePosition parsePosition = new ParsePosition(0);
            numberFormat = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
            try {
                string = column.getPrecision() > 0 && column.getScale() > 0 || column.getPrecision() == 0 && column.getScale() == 0 || this.isScaleImported() ? "" + numberFormat.parse(string2, parsePosition).doubleValue() : "" + numberFormat.parse(string2, parsePosition).longValue();
            }
            catch (Exception exception) {
                string = string2;
            }
            if (parsePosition.getIndex() < string2.length()) {
                return string2;
            }
        }
        if (string.length() == 0) {
            return "NULL";
        }
        return string;
    }

    @Override
    public Object formatDataForJava(Object object, Column column) throws Exception {
        String string = this.formatData(object, column);
        if (this.m_connection != null && string != null) {
            String string2 = "" + ((OracleNLSProvider)NLSProvider.getProvider(this.m_connection)).getDecimalSeparator();
            string = string.replace(".", string2);
        }
        return string;
    }

    @Override
    public int getSqlType(String string) {
        if (string.equals("NUMBER")) {
            return 2;
        }
        if (string.equals("INTEGER")) {
            return 4;
        }
        if (string.equals("LONG")) {
            return 8;
        }
        if (string.equals("FLOAT")) {
            return 6;
        }
        return 2;
    }
}

