/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import oracle.dbtools.data.formattors.BaseFormattor;
import oracle.dbtools.data.model.Column;

public class CharFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column column) {
        String string = null;
        string = this.addDoubleQuote(column.getName()) + " " + column.getType();
        if (column.getName() != null && column.getPrecision() > 0) {
            string = string + "(" + column.getPrecision() + ")";
        }
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    @Override
    public String formatData(Object object, Column column) {
        return this.formatData(object, column, true);
    }

    @Override
    public Object formatDataForJava(Object object, Column column) throws Exception {
        return object != null ? object.toString() : "NULL";
    }

    public String formatData(Object object, Column column, boolean bl) {
        String string = "NULL";
        if (object != null) {
            String string2 = object.toString();
            string2 = string2.replaceAll("'", "''");
            string = bl ? (column.getType().toUpperCase().equals("NCHAR") || column.getType().toUpperCase().equals("NVARCHAR2") ? "N'" + string2 + "'" : "'" + string2 + "'") : string2;
        }
        return string;
    }

    @Override
    public int getSqlType(String string) {
        if (string.equals("VARCHAR2")) {
            return 12;
        }
        if (string.equals("CHAR")) {
            return 1;
        }
        if (string.equals("NCHAR")) {
            return -15;
        }
        if (string.equals("NVARCHAR2")) {
            return -9;
        }
        return 0;
    }
}

