/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;

public final class Iterators {
    private static final Iterator EMPTY = Iterators.iterator(new Object[0]);

    private Iterators() {
    }

    public static <T> void add(Collection<T> collection, Iterator<? extends T> iterator) {
        Iterators.add(collection, iterator, false);
    }

    public static <T> void add(Collection<T> collection, Iterator<? extends T> iterator, boolean bl) {
        if (collection != null && iterator != null) {
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (Iterators.ignore(t, bl)) continue;
                collection.add(t);
            }
        }
    }

    public static <T> int compare(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!iterator2.hasNext()) {
                n = 1;
                break;
            }
            T t2 = iterator2.next();
            n = ((Comparable)t).compareTo(t2);
            if (n == 0) continue;
            break;
        }
        if (iterator2.hasNext()) {
            n = -1;
        }
        return n;
    }

    public static <T> int compare(Iterator<T> iterator, Iterator<T> iterator2, Comparator<T> comparator) {
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!iterator2.hasNext()) {
                n = 1;
                break;
            }
            T t2 = iterator2.next();
            n = comparator.compare(t, t2);
            if (n == 0) continue;
            break;
        }
        if (iterator2.hasNext()) {
            n = -1;
        }
        return n;
    }

    public static final <T> Iterator<T> empty() {
        return EMPTY;
    }

    public static final <T> Enumeration<T> enumeration(final Iterator<T> iterator) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }

            public String toString() {
                return iterator.toString();
            }
        };
    }

    public static <T> boolean equals(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!iterator2.hasNext()) {
                return false;
            }
            T t2 = iterator2.next();
            boolean bl = t == t2 || t.equals(t2);
            if (bl) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static final <T> Iterator<T> iterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return enumeration.toString();
            }
        };
    }

    public static <T> Iterator<T> iterator(final Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        final Iterator<? extends T> iterator = iterable.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            public String toString() {
                return iterable.toString();
            }
        };
    }

    public static final <T> Iterator<T> iterator(T ... TArray) {
        if (TArray == null) {
            return null;
        }
        return new ArrayIterator((Object[])TArray);
    }

    public static String join(Iterator<?> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            stringBuilder.append(obj);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static <T> T max(Iterator<? extends T> iterator) {
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static final <T> T next(Iterator<? extends T> iterator) {
        T t = Iterators.nextOrNull(iterator);
        if (t == null) {
            throw new IllegalStateException("no more items");
        }
        return t;
    }

    public static final <T> T nextOrNull(Iterator<? extends T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static <T> boolean ignore(T t, boolean bl) {
        return bl && t == null;
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] items;
        private int pos = 0;

        private ArrayIterator(T ... TArray) {
            this.items = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.items.length;
        }

        @Override
        public T next() {
            T t = this.items[this.pos];
            ++this.pos;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

