/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.PosType;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class PositionalRelation
extends IdentedPredicate {
    String a;
    PosType tA;
    String b;
    PosType tB;
    Program prog;
    boolean isReflexive;

    public PositionalRelation(String string, PosType posType, String string2, PosType posType2, boolean bl, Program program) {
        this.a = string;
        this.tA = posType;
        this.b = string2;
        this.tB = posType2;
        this.isReflexive = bl;
        this.prog = program;
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        if (this.isReflexive) {
            return this.evalPos(map, this.tA, this.a) <= this.evalPos(map, this.tB, this.b);
        }
        return this.evalPos(map, this.tA, this.a) < this.evalPos(map, this.tB, this.b);
    }

    private int evalPos(Map<String, ParseNode> map, PosType posType, String string) {
        if (posType == PosType.BINDVAR) {
            try {
                Field field = this.prog.getClass().getDeclaredField(string);
                field.setAccessible(true);
                return field.getInt(this.prog);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Bind var '" + string + "' not found: " + exception.getMessage()));
            }
        }
        ParseNode parseNode = this.getNode(string, map);
        if (posType == PosType.HEAD) {
            return parseNode.from;
        }
        if (posType == PosType.TAIL) {
            return parseNode.to;
        }
        throw new AssertionError((Object)"Impossible Case");
    }

    public String toString() {
        return this.a + (Object)((Object)this.tA) + " < " + this.b + (Object)((Object)this.tB);
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        if (this.tA != PosType.BINDVAR) {
            PositionalRelation.variables(this.a, set);
        }
        if (this.tB != PosType.BINDVAR) {
            PositionalRelation.variables(this.b, set);
        }
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        if (this.tA == PosType.BINDVAR || this.tB == PosType.BINDVAR) {
            return null;
        }
        Attribute attribute = map.get(this.a);
        Attribute attribute2 = map.get(this.b);
        if (attribute.isDependent(string, map) && attribute2.isDependent(string2, map) || attribute2.isDependent(string, map) && attribute.isDependent(string2, map)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        int n = this.a.indexOf(46);
        if (0 < n) {
            hashMap.put(this.a.substring(0, n), true);
        }
        if (0 < (n = this.b.indexOf(46))) {
            hashMap.put(this.b.substring(0, n), true);
        }
        return hashMap;
    }
}

