/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class AggregatePredicate
implements Predicate {
    private Type type;
    String attribute;
    Predicate predicate;

    public AggregatePredicate(String string, Predicate predicate, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            this.type = Type.OLD;
        } else if (!bl && bl2) {
            this.type = Type.ANCESTOR;
        } else if (bl && !bl2) {
            this.type = Type.DESCENDANT;
        } else if (bl && bl2) {
            this.type = Type.YOUNG;
        }
        this.attribute = string;
        this.predicate = predicate;
    }

    @Override
    public MaterializedPredicate eval(Parsed parsed) {
        MaterializedPredicate materializedPredicate = this.predicate.eval(parsed);
        Integer n = materializedPredicate.getAttribute(this.attribute);
        if (n == null) {
            throw new AssertionError((Object)("Predicate " + materializedPredicate.name + " doesn't have " + this.attribute + " attribute"));
        }
        MaterializedPredicate materializedPredicate2 = new MaterializedPredicate(materializedPredicate.attributes, parsed.getSrc(), materializedPredicate.name);
        for (ParseNode[] parseNodeArray : materializedPredicate.tuples) {
            this.eval(parseNodeArray, materializedPredicate2.tuples, n);
        }
        return materializedPredicate2;
    }

    private void eval(ParseNode[] parseNodeArray, ArrayList<ParseNode[]> arrayList, int n) {
        ParseNode[] parseNodeArray2 = null;
        ParseNode[] parseNodeArray3 = null;
        for (ParseNode[] parseNodeArray4 : arrayList) {
            boolean bl = true;
            ParseNode[] parseNodeArray5 = null;
            ParseNode[] parseNodeArray6 = null;
            for (int i = 0; i < parseNodeArray.length; ++i) {
                if (i == n) {
                    boolean bl2 = parseNodeArray[n].to < parseNodeArray4[n].to;
                    boolean bl3 = parseNodeArray[n].to == parseNodeArray4[n].to;
                    boolean bl4 = parseNodeArray4[n].to < parseNodeArray[n].to;
                    boolean bl5 = parseNodeArray[n].from < parseNodeArray4[n].from;
                    boolean bl6 = parseNodeArray[n].from == parseNodeArray4[n].from;
                    boolean bl7 = parseNodeArray4[n].from < parseNodeArray[n].from;
                    switch (this.type) {
                        case ANCESTOR: {
                            if ((bl4 || bl3 && bl5) && (bl5 || bl6 && bl4)) {
                                parseNodeArray5 = parseNodeArray4;
                            }
                            if (!bl2 && (!bl3 || !bl7) || !bl7 && (!bl6 || !bl2)) break;
                            parseNodeArray6 = parseNodeArray4;
                            break;
                        }
                        case DESCENDANT: {
                            if ((bl2 || bl3 && bl7) && (bl7 || bl6 && bl2)) {
                                parseNodeArray5 = parseNodeArray4;
                            }
                            if (!bl4 && (!bl3 || !bl5) || !bl5 && (!bl6 || !bl4)) break;
                            parseNodeArray6 = parseNodeArray4;
                            break;
                        }
                        case OLD: {
                            if ((bl2 || bl3) && (bl5 || bl6)) {
                                parseNodeArray5 = parseNodeArray4;
                            }
                            if (!bl4 && !bl3 || !bl7 && !bl6) break;
                            parseNodeArray6 = parseNodeArray4;
                            break;
                        }
                        case YOUNG: {
                            if ((bl4 || bl3) && (bl7 || bl6)) {
                                parseNodeArray5 = parseNodeArray4;
                            }
                            if (!bl2 && !bl3 || !bl5 && !bl6) break;
                            parseNodeArray6 = parseNodeArray4;
                        }
                    }
                    continue;
                }
                if (parseNodeArray4[i].from == parseNodeArray[i].from && parseNodeArray4[i].to == parseNodeArray[i].to) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (parseNodeArray2 == null) {
                parseNodeArray2 = parseNodeArray5;
            }
            if (parseNodeArray3 != null) continue;
            parseNodeArray3 = parseNodeArray6;
        }
        if (parseNodeArray2 != null) {
            arrayList.remove(parseNodeArray2);
        }
        if (parseNodeArray3 == null) {
            arrayList.add(parseNodeArray);
        }
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.attribute);
        switch (this.type) {
            case ANCESTOR: {
                stringBuffer.append("\\/");
                break;
            }
            case DESCENDANT: {
                stringBuffer.append("/\\");
                break;
            }
            case OLD: {
                stringBuffer.append("\\\\");
                break;
            }
            case YOUNG: {
                stringBuffer.append("//");
            }
        }
        stringBuffer.append(this.predicate.toString(n));
        return stringBuffer.toString();
    }

    @Override
    public boolean eval(Map<String, ParseNode> map, List<LexerToken> list) {
        throw new AssertionError((Object)"N/A");
    }

    @Override
    public void variables(Set<String> set, boolean bl) {
        this.predicate.variables(set, false);
    }

    @Override
    public Predicate isRelated(String string, String string2, Map<String, Attribute> map) {
        return this.predicate.isRelated(string, string2, map);
    }

    @Override
    public Map<String, Boolean> dependencies() {
        return this.predicate.dependencies();
    }

    public static enum Type {
        ANCESTOR,
        DESCENDANT,
        OLD,
        YOUNG;

    }
}

