/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver7;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServerMessages;

public abstract class SQLServer7AbstractCapturerPrivilegeExtra {
    protected static int s_overSize = 5000;

    protected abstract String capturePrivilegesString(String var1);

    protected abstract String captureRoleMembershipString(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capturePrivileges(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList, MdGroup mdGroup, MdUser mdUser, boolean bl) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = migrationStorer.getPersistenceUtility();
        String string = SQLServer7AbstractCapturerPrivilegeExtra.getDatabase((MigrationContext)captureContext);
        String string2 = this.capturePrivilegesString(string);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            String string3 = string2;
            preparedStatement = connection.prepareStatement(string3);
            boolean bl2 = true;
            String string4 = null;
            if (mdGroup == null) {
                bl2 = false;
                string4 = mdUser.getUsername();
            } else {
                string4 = mdGroup.getGroupName();
            }
            if (!bl) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string4);
            } else {
                preparedStatement.setString(1, string4);
            }
            resultSet = preparedStatement.executeQuery();
            block18: while (resultSet.next()) {
                BufferedInputStream bufferedInputStream;
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                if (string5.equals("GRANT_W_GRANT")) {
                    string5 = "GRANT_W_GRANT";
                } else if (string5.equals("GRANT")) {
                    string5 = "GRANT";
                } else if (string5.equals("DENY")) {
                    string5 = "DENY";
                }
                if (string6.equals("REFERENCES")) {
                    string6 = "REFERENCES";
                } else if (string6.equals("SELECT")) {
                    string6 = "SELECT";
                } else if (string6.equals("INSERT")) {
                    string6 = "INSERT";
                } else if (string6.equals("UPDATE")) {
                    string6 = "UPDATE";
                } else if (string6.equals("DELETE")) {
                    string6 = "DELETE";
                } else if (string6.equals("CREATE TABLE")) {
                    string6 = "CREATE TABLE";
                } else if (string6.equals("CREATE DATABASE")) {
                    string6 = "CREATE DATABASE";
                } else if (string6.equals("CREATE VIEW")) {
                    string6 = "CREATE VIEW";
                } else if (string6.equals("CREATE PROCEDURE")) {
                    string6 = "CREATE PROCEDURE";
                } else if (string6.equals("EXECUTE")) {
                    string6 = "EXECUTE";
                } else if (string6.equals("BACKUP DEFAULT")) {
                    string6 = "BACKUP DEFAULT";
                } else if (string6.equals("CREATE DEFAULT")) {
                    string6 = "CREATE DEFAULT";
                } else if (string6.equals("BACKUP LOG")) {
                    string6 = "BACKUP LOG";
                }
                if (string6.equalsIgnoreCase("CREATE RULE")) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "SQLSERVER.SKIP_CREATE_RULE");
                    continue;
                }
                InputStream inputStream = resultSet.getBinaryStream(9);
                int n = s_overSize;
                byte[] byArray = new byte[n];
                int n2 = 0;
                if (inputStream != null) {
                    boolean bl3 = false;
                    int n3 = 0;
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    while (!bl3) {
                        n3 = bufferedInputStream.read(byArray, n2, n - n2);
                        if (n3 == -1 || n3 + n2 == n) {
                            bl3 = true;
                            continue;
                        }
                        n2 += n3;
                    }
                }
                DBObjectId dBObjectId = null;
                DBObjectId dBObjectId2 = null;
                try {
                    dBObjectId = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), resultSet.getString(6));
                    dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), resultSet.getString(8));
                }
                catch (PersistenceException persistenceException) {
                    continue;
                }
                if (dBObjectId == null || dBObjectId2 == null) continue;
                prepareClobHelper = new PrepareClobHelper();
                prepareClobHelper.append(string5 + " " + string6 + " ON " + resultSet.getString(3) + " TO " + resultSet.getString(5));
                bufferedInputStream = null;
                if (resultSet.getString(4).trim().equals("U")) {
                    bufferedInputStream = new MdPrivilege(dBObjectId, resultSet.getString(1), "MD_TABLES", resultSet.getString(2), prepareClobHelper.getClobHelper());
                } else {
                    if (!resultSet.getString(4).trim().equals("V")) continue;
                    bufferedInputStream = new MdPrivilege(dBObjectId, resultSet.getString(1), "MD_VIEWS", resultSet.getString(2), prepareClobHelper.getClobHelper());
                }
                prepareClobHelper.close();
                if (string5.equals("GRANT_W_GRANT")) {
                    bufferedInputStream.setAdminOption("Y");
                } else {
                    bufferedInputStream.setAdminOption("N");
                }
                DBObjectId dBObjectId3 = null;
                try {
                    dBObjectId3 = SQLServer7AbstractCapturerPrivilegeExtra.getIdInRepo(persistenceUtility, resultSet.getString(4), dBObjectId2, resultSet.getString(7));
                    if (dBObjectId3 == null) {
                        continue;
                    }
                }
                catch (PersistenceException persistenceException) {
                    if (dBObjectId3 == null) continue;
                    throw persistenceException;
                }
                bufferedInputStream.setPrivelegeObjectId(dBObjectId3);
                if (resultSet.getString(4).trim().equals("U") && n2 > 0 && (n2 != 1 || byArray[0] != 1)) {
                    int n4 = 0;
                    boolean bl4 = false;
                    while (true) {
                        MdUserPrivilege mdUserPrivilege;
                        int n5 = ++n4 / 8;
                        int n6 = n4 % 8;
                        if (n5 > n2) continue block18;
                        int n7 = byArray[n5] >>> n6 & 1;
                        if (n7 != 1) continue;
                        MdPrivilege mdPrivilege = null;
                        try {
                            mdPrivilege = new MdPrivilege(dBObjectId, string5, "MD_COLUMNS", string6, prepareClobHelper.getClobHelper());
                        }
                        catch (IOException iOException) {
                            MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.24"), (Throwable)iOException);
                            continue;
                        }
                        mdPrivilege.setAdminOption(bufferedInputStream.getAdminOption());
                        try {
                            mdPrivilege.setPrivelegeObjectId(persistenceUtility.getIdForColumn(dBObjectId3, n4));
                        }
                        catch (PersistenceException persistenceException) {
                            continue;
                        }
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_PRIVILEGE"), resultSet.getString(7));
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdPrivilege = (MdPrivilege)migrationStorer.storeObject((PersistableObject)mdPrivilege);
                        bl4 = true;
                        captureEvent.setEventId(4);
                        if (bl2) {
                            mdUserPrivilege = new MdGroupPrivilege(mdGroup.getKey(), mdPrivilege.getKey());
                            mdUserPrivilege = (MdGroupPrivilege)migrationStorer.storeObject((PersistableObject)mdUserPrivilege);
                            continue;
                        }
                        mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
                        mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
                        mdUserPrivilege = (MdUserPrivilege)migrationStorer.storeObject((PersistableObject)mdUserPrivilege);
                    }
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_PRIVILEGE"), resultSet.getString(7));
                captureContext.getAudience().fireListeners(captureEvent);
                bufferedInputStream = (MdPrivilege)migrationStorer.storeObject((PersistableObject)bufferedInputStream);
                captureEvent.setEventId(4);
                if (bl2) {
                    MdGroupPrivilege mdGroupPrivilege = new MdGroupPrivilege(mdGroup.getKey(), bufferedInputStream.getKey());
                    mdGroupPrivilege = (MdGroupPrivilege)migrationStorer.storeObject((PersistableObject)mdGroupPrivilege);
                    continue;
                }
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
                mdUserPrivilege.setPrivilegeId(bufferedInputStream.getKey());
                mdUserPrivilege = (MdUserPrivilege)migrationStorer.storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (IOException iOException) {
            try {
                MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.25"), (Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (IOException iOException2) {
                        MigrationLogUtil.logThrowable((String)iOException2.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.26"), (Throwable)iOException2);
                    }
                }
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            if (prepareClobHelper != null) {
                try {
                    prepareClobHelper.close();
                }
                catch (IOException iOException3) {
                    MigrationLogUtil.logThrowable((String)iOException3.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.26"), (Throwable)iOException3);
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (IOException iOException) {
                MigrationLogUtil.logThrowable((String)iOException.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.26"), (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureRoleMembership(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList, boolean bl) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = migrationStorer.getPersistenceUtility();
        Statement statement = null;
        ResultSet resultSet = null;
        Object var9_9 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            String string = SQLServer7AbstractCapturerPrivilegeExtra.getDatabase((MigrationContext)captureContext);
            CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId((DBObjectId)captureContext.getContextVariable("CATALOGID"));
            ArrayList<MdGroup> arrayList2 = new ArrayList<MdGroup>();
            while (closeableIterator.hasNext()) {
                CloseableIterator closeableIterator2 = persistenceUtility.getUsersforSchemaId(((MdSchema)closeableIterator.next()).getKey());
                while (closeableIterator2.hasNext()) {
                    MdGroup mdGroup = (MdUser)closeableIterator2.next();
                    arrayList2.add(mdGroup);
                }
            }
            for (MdGroup mdGroup : arrayList) {
                CaptureEvent captureEvent;
                Object object;
                String string2 = mdGroup.getGroupName();
                if (string2.equals("public")) {
                    for (MdUser mdUser : arrayList2) {
                        object = new MdGroupMember(mdGroup.getKey());
                        object.setUserId(mdUser.getKey());
                        captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP_MEMBERS"), string2);
                        captureContext.getAudience().fireListeners(captureEvent);
                        object = (MdGroupMember)migrationStorer.storeObject((PersistableObject)object);
                        captureEvent.setEventId(4);
                    }
                    continue;
                }
                String string3 = this.captureRoleMembershipString(string);
                preparedStatement = null;
                resultSet2 = null;
                try {
                    Object object2 = string3;
                    preparedStatement = connection.prepareStatement((String)object2);
                    if (!bl) {
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, string2);
                    } else {
                        preparedStatement.setString(1, string2);
                    }
                    resultSet2 = preparedStatement.executeQuery();
                    while (resultSet2.next()) {
                        object = resultSet2.getString(1);
                        captureEvent = null;
                        DBObjectId dBObjectId = null;
                        for (MdUser mdUser : arrayList2) {
                            if (!mdUser.getUsername().equals(object)) continue;
                            captureEvent = mdUser.getKey();
                            break;
                        }
                        if (captureEvent == null) {
                            for (MdGroup mdGroup2 : arrayList) {
                                if (!mdGroup2.getGroupName().equals(object)) continue;
                                dBObjectId = mdGroup2.getKey();
                                break;
                            }
                        }
                        if (captureEvent == null && dBObjectId == null) continue;
                        Iterator<Object> iterator = new MdGroupMember(mdGroup.getKey());
                        if (captureEvent != null) {
                            iterator.setUserId((DBObjectId)captureEvent);
                        } else {
                            if (dBObjectId == null) continue;
                            iterator.setGroupMemberId(dBObjectId);
                        }
                        CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP_MEMBERS"), string2);
                        captureContext.getAudience().fireListeners(captureEvent2);
                        iterator = (MdGroupMember)migrationStorer.storeObject(iterator);
                        captureEvent2.setEventId(4);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet2);
                    throw throwable;
                    return;
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
            }
        }
        finally {
            CloseableResultSet.close(statement, resultSet);
            if (var9_9 != null) {
                try {
                    var9_9.close();
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturerPrivilegeExtra.28"), (Throwable)exception);
                }
            }
        }
    }

    public static DBObjectId getIdInRepo(PersistenceUtility persistenceUtility, String string, DBObjectId dBObjectId, String string2) throws PersistenceException {
        if (string.equals("FN") || string.equals("IF") || string.trim().equals("P") || string.equals("TF") || string.trim().equals("X")) {
            return persistenceUtility.getIdForStoredProgram(dBObjectId, string2);
        }
        if (string.trim().equals("U")) {
            return persistenceUtility.getIdForTable(dBObjectId, string2);
        }
        if (string.trim().equals("V")) {
            return persistenceUtility.getIdForView(dBObjectId, string2);
        }
        return null;
    }

    public static String getDatabase(MigrationContext migrationContext) throws SQLException {
        String string = null;
        MdCatalog mdCatalog = (MdCatalog)migrationContext.getContextVariable("CATALOG");
        string = mdCatalog.getCatalogName();
        return string;
    }
}

