/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2005;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005AbstractCapturer;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005OnlineCapturerPrivilegeExtra;

public class SQLServer2005CaptureObjectsOnlineCapturer
extends SQLServer2005AbstractCapturer {
    private static SQLServer2005CaptureQueries s_captureQueries;

    @Override
    protected String andExistsTablesOrProcedures() {
        return " and exists (select 1 from [{0}].sys.objects o where o.schema_id = s.schema_id) ";
    }

    @Override
    protected String getDatabasesString() {
        return "select d.name from master.sys.databases d where 1=1";
    }

    @Override
    protected String getSchemasString(String string) {
        return MessageFormat.format("select s.name from [{0}].sys.schemas s where s.schema_id<16384  and s.name!=''INFORMATION_SCHEMA'' and s.name!=''sys'' " + this.andExistsTablesOrProcedures(), string);
    }

    @Override
    protected String getSchemaOwnerString(String string) {
        return "select SCHEMA_OWNER from [" + string + "].INFORMATION_SCHEMA.SCHEMATA " + " where SCHEMA_NAME=? ";
    }

    @Override
    protected String getSchemaString(String string) {
        return "select d.name, s.name from [" + string + "].sys.database_principals " + " d,  [" + string + "].sys.server_principals s where " + " ((s.sid = d.sid )OR(d.name='dbo' and s.name='sa')) and d.default_schema_name= ? " + "and (d.type='U' or d.type='S')";
    }

    @Override
    protected String getTablesString(String string) {
        return "Select a.name, a.object_id from [" + string + "].sys.tables a, [" + string + "].sys.schemas b where b.name = ? and a.schema_id = b.schema_id";
    }

    @Override
    protected String getColumnsString(String string, int n) {
        return "select DISTINCT a.name, 'dummy',  c.name, c.column_id, d.name,  c.max_length, c.precision, c.scale, c.is_nullable,  c.user_type_id, c.system_type_id, c.default_object_id,  UPPER(a.name) from [" + string + "].sys.objects a, [" + string + "].sys.columns c, " + " [" + string + "].sys.types d" + " where a.\"TYPE\"='U' " + " and a.object_id = " + n + " and a.object_id = c.object_id " + " and d.user_type_id = c.user_type_id " + " order by UPPER(a.name), c.column_id ";
    }

    @Override
    protected String getIdentityString(String string, int n, int n2) {
        return "select cast(seed_value as bigint), cast(increment_value as bigint),  cast(last_value as bigint) from [" + string + "].sys.identity_columns i where i.object_id=" + n + " and i.column_id=" + n2;
    }

    @Override
    protected String getBaseTypeString(String string, int n) {
        return " SELECT a.name  FROM [" + string + "].sys.types a " + " WHERE a.system_type_id = " + n + " ORDER BY a.user_type_id ";
    }

    @Override
    protected String getColumnDefaultString(String string, int n) {
        return "SELECT a.definition  FROM [" + string + "].sys.default_constraints a " + " WHERE a.object_id = " + n + " UNION SELECT a.definition " + " FROM [" + string + "].sys.sql_modules a " + " WHERE a.object_id = " + n;
    }

    @Override
    protected String getCaptureIndexString(String string) {
        return " SELECT i.object_id, i.index_id, i.name,  i.is_unique, o.name, o.object_id  FROM  [" + string + "].sys.indexes i, [" + string + "].sys.objects o " + " WHERE " + this.getXTypeWhereInIndex() + " AND   o.object_id = i.object_id        " + " AND " + this.getForCaptureIndex() + " AND   o.schema_id=schema_id(?) AND o.name = ? and i.is_primary_key = 0 ";
    }

    @Override
    protected String getIndexString(String string, int n, int n2) {
        return " SELECT a.index_column_id, b.name, a.is_descending_key  FROM [" + string + "].sys.index_columns a , [" + string + "].sys.columns b " + " WHERE a.object_id = " + n + " AND b.object_id = a.object_id " + " AND b.column_id = a.column_id " + " AND a.index_id = " + n2;
    }

    @Override
    protected String captureUniqueAndPrimaryKeysString(String string) {
        return " SELECT a.name, a2.name,  a.object_id, c.index_column_id, d.name, c.object_id, b.index_id , a.type  /*, a.status */  FROM [" + string + "].sys.objects a2, [" + string + "].sys.objects a, [" + string + "].sys.indexes b, [" + string + "].sys.index_columns c, [" + string + "].sys.columns d, [" + string + "].sys.objects e  WHERE (a.type='PK' OR a.type='UQ') AND a2.object_id = a.parent_object_id " + " AND a.name=b.name and a2.name = ? " + " and e.schema_id = schema_id(?) AND c.object_id = b.object_id AND c.index_id = b.index_id " + " and  b.object_id=a.parent_object_id " + " AND d.object_id = c.object_id  AND d.column_id = c.column_id AND e.object_id = a.object_id " + " AND " + this.getXTypeWhere() + " ORDER BY a.object_id, c.column_id";
    }

    @Override
    protected String captureForeignKeysStringString(String string) {
        return "use [" + string + "] select fk.name, fkc.constraint_object_id, lc.name, " + " schema_name(rt.schema_id), rt.name, rc.name, fkc.constraint_column_id from [" + string + "].sys.foreign_keys fk, " + "[" + string + "].sys.foreign_key_columns fkc, [" + string + "].sys.columns lc, [" + string + "].sys.columns rc, [" + string + "].sys.tables rt, [" + string + "].sys.tables lt " + "where fk.object_id = fkc.constraint_object_id and lc.object_id = fkc.parent_object_id and " + "lc.column_id = fkc.parent_column_id and rc.object_id = fkc.referenced_object_id and " + "rc.column_id = fkc.referenced_column_id and fkc.referenced_object_id = rt.object_id and " + "rt.type = 'U' and fkc.parent_object_id = lt.object_id and schema_name(lt.schema_id)=? and " + "lt.name=? order by fkc.constraint_object_id, fkc.constraint_column_id ";
    }

    @Override
    protected String captureTableLevelCheckConstraintString(String string) {
        return "use [" + string + "] SELECT a.name, d.definition, d.object_id " + "FROM [" + string + "].sys.objects a, [" + string + "].sys.objects a2, [" + string + "].sys.objects c, [" + string + "].sys.check_constraints d " + " WHERE a.type='C' " + " AND a.object_id = c.object_id  " + " AND d.object_id = a.object_id " + " AND d.parent_column_id = 0 AND a.parent_object_id = a2.object_id and a2.name= ? " + " AND c.schema_id = schema_id(?) ";
    }

    @Override
    protected String captureColumnLevelCheckConstraintString(String string) {
        return "use [" + string + "] SELECT a.name, 1 , " + " d.parent_column_id, d.definition, d.object_id, " + " s.name FROM [" + string + "].sys.objects a, [" + string + "].sys.objects a2, [" + string + "].sys.objects c, [" + string + "].sys.check_constraints d " + " , [" + string + "].sys.columns s " + " WHERE a.type='C' " + " AND a.object_id = c.object_id  " + " AND d.object_id = a.object_id " + " AND d.parent_column_id <> 0 AND " + " a.parent_object_id = a2.object_id and a2.name= ? " + " AND c.schema_id = schema_id(?) and a2.object_id = s.object_id and " + " d.parent_column_id = s.column_id ";
    }

    @Override
    protected String captureRulesString(String string) {
        return " SELECT DISTINCT a.name,  b.name, b.name, b.rule_object_id  FROM [" + string + "].sys.objects a, [" + string + "].sys.columns b, [" + string + "].sys.objects c" + " WHERE a.name = ? AND c.schema_id = schema_id(?) " + " AND a.type = 'U' " + " AND b.object_id = a.object_id " + " AND c.object_id = a.object_id " + " AND b.rule_object_id >  0 ";
    }

    @Override
    protected String captureRulesTextString(String string) {
        return " SELECT definition FROM [" + string + "].sys.sql_modules " + " WHERE object_id = ? ";
    }

    @Override
    protected String captureViewOuterString(String string) {
        return "use [" + string + "] SELECT a.object_id, a.name " + " FROM [" + string + "].sys.objects a, [" + string + "].sys.objects b " + " WHERE a.type='V' " + " AND a.object_id = b.object_id " + " and b.schema_id=schema_id(?) and a.is_ms_shipped=0 ";
    }

    @Override
    protected String captureViewInnerString(String string) {
        return "SELECT DISTINCT a.name, 1, b.definition  FROM [" + string + "].sys.objects a, [" + string + "].sys.sql_modules b, [" + string + "].sys.objects c " + " WHERE a.type='V' AND a.object_id = b.object_id AND a.object_id = ? " + " AND a.object_id = c.object_id " + " AND a.object_id = b.object_id and a.is_ms_shipped=0  ";
    }

    @Override
    protected String captureStoredProgramOuterString(String string) {
        return " use [" + string + "] SELECT  a.object_id, a.name " + " FROM   [" + string + "].sys.objects a, [" + string + "].sys.objects b  " + " WHERE  " + this.getWhereForStoredPrograms() + " AND a.object_id = b.object_id  " + " AND a.is_ms_shipped=0 " + " AND b.schema_id = schema_id(?)";
    }

    @Override
    protected String captureStoredProgramInnerString(String string, String string2) {
        return " SELECT a.name, a.object_id, 1, b.definition, a.type   FROM   [" + string + "].sys.objects a, [" + string + "].sys.sql_modules b, [" + string + "].sys.objects c  " + " WHERE  " + this.getWhereForStoredPrograms() + " AND a.object_id = b.object_id  " + " AND a.object_id = c.object_id  " + " AND a.is_ms_shipped=0 " + " AND a.object_id = ? " + string2;
    }

    @Override
    protected String captureTriggersString(String string) {
        return " SELECT a.name, a.object_id, 1, b.definition  FROM   [" + string + "].sys.objects a, [" + string + "].sys.sql_modules b, [" + string + "].sys.objects c,  " + "[" + string + "].sys.objects d " + " WHERE  a.type = 'TR' " + " AND a.object_id = b.object_id  " + " AND d.object_id = c.object_id  " + " AND a.is_ms_shipped=0 " + " AND c.schema_id = schema_id(?) " + " AND d.name = ? " + " AND a.parent_object_id=d.object_id " + " order by a.object_id ";
    }

    @Override
    protected String captureRolesString(String string) {
        return "select b.name, a.default_schema_name from [" + string + "].sys.database_principals a, [" + string + "].sys.database_principals b where b.type = 'R' " + "and b.owning_principal_id=a.principal_id ";
    }

    @Override
    protected void capturePrivileges(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList, MdGroup mdGroup, MdUser mdUser) throws SQLException, PersistenceException {
        new SQLServer2005OnlineCapturerPrivilegeExtra().capturePrivileges(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList, mdGroup, mdUser, this.m_online);
    }

    @Override
    protected void captureRoleMembership(Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext, ArrayList<MdGroup> arrayList) throws SQLException, PersistenceException {
        new SQLServer2005OnlineCapturerPrivilegeExtra().captureRoleMembership(this.getRepositoryConnection(), migrationStorer, captureContext, arrayList, this.m_online);
    }

    @Override
    public String getModelName() throws CaptureException {
        return null;
    }

    public SQLServer2005CaptureObjectsOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        this.m_online = true;
        this.setStorer(migrationStorer);
        this.m_repositoryConnection = connection;
    }

    @Override
    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver2005";
    }

    @Override
    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    @Override
    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    @Override
    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    @Override
    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    @Override
    protected String captureCommentsString() {
        return "select value from sys.extended_properties where major_id=? and minor_id=?";
    }
}

