/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dashboard;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.dashboard.ArrayListGraphicIterator;
import ilog.views.dashboard.IlvDashboardContainer;
import ilog.views.dashboard.IlvDashboardContext;
import ilog.views.dashboard.IlvDashboardDiagram;
import ilog.views.dashboard.IlvDashboardDiagramIterator;
import ilog.views.dashboard.IlvDashboardEditor;
import ilog.views.dashboard.IlvDashboardIndexEdit;
import ilog.views.dashboard.IlvDashboardLayerPanel;
import ilog.views.dashboard.IlvDashboardManagerCompoundEdit;
import ilog.views.dashboard.IlvDashboardSymbol;
import ilog.views.dashboard.IlvDashboardSymbolIterator;
import ilog.views.dashboard.PanelAction;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.application.IlvDiagrammerAction;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.IlvSDMView;
import ilog.views.sdm.graphic.IlvURLGraphic;
import ilog.views.sdm.model.IlvDefaultSDMModel;
import ilog.views.sdm.model.IlvFilterSDMModel;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.context.ComponentAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;

public abstract class IlvDashboardAction
extends IlvDiagrammerAction {
    public static IlvDashboardAction importFile = new Import();
    public static IlvDashboardAction bringToFront = new BringToFront();
    public static IlvDashboardAction bringForward = new BringForward();
    public static IlvDashboardAction sendBackward = new SendBackward();
    public static IlvDashboardAction sendBack = new SendBack();
    public static IlvDashboardAction blinkingAllowed = new BlinkingAllowed();
    public static IlvDashboardAction generalPathEnabled = new GeneralPathEnabled();
    public static IlvDashboardAction linkLayoutEnabled = new LinkLayoutEnabled();
    public static IlvDashboardAction defaultMappingEnabled = new DefaultMappingEnabled();
    public static IlvDashboardAction showHiddenObjects = new ShowHiddenObjects();
    public static IlvDashboardAction saveAs = new SaveAs();
    public static IlvDashboardAction save = new Save();
    public static IlvDashboardAction open = new Open();
    public static IlvDashboardAction close = new Close();
    public static IlvDashboardAction layerPanel = new PanelAction("Dashboard.Action.LayerPanel", IlvDashboardLayerPanel.ID);
    public static IlvDashboardAction clearMapping = new ClearMapping();
    public static IlvDashboardAction setDefaultMapping = new SetDefaultMapping();
    private static ResourceBundle a;

    static int a(IlvDashboardDiagram ilvDashboardDiagram) {
        IlvSDMEngine ilvSDMEngine = ilvDashboardDiagram.getEngine();
        IlvStyleSheetRenderer ilvStyleSheetRenderer = IlvStyleSheetRenderer.getInstance(ilvSDMEngine);
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        int n = ilvGrapher.getLayersCount();
        if (ilvStyleSheetRenderer != null && ilvStyleSheetRenderer.getLinksLayer() < n) {
            n = ilvStyleSheetRenderer.getLinksLayer();
        }
        int n2 = -1;
        for (int i = n - 1; i >= 0; --i) {
            IlvManagerLayer ilvManagerLayer = ilvGrapher.getManagerLayer(i);
            if (ilvManagerLayer.getCardinal() != 0) continue;
            n2 = i;
        }
        if (n2 > 0) {
            return n2 - 1;
        }
        return n - 1;
    }

    protected static IlvDashboardEditor getEditor(IlvDiagrammer ilvDiagrammer) {
        if (ilvDiagrammer instanceof IlvDashboardDiagram) {
            return (IlvDashboardEditor)((IlvDashboardDiagram)ilvDiagrammer).getContext();
        }
        return null;
    }

    protected IlvDashboardAction(String string) {
        this(string, null);
    }

    protected IlvDashboardAction(String string, ResourceBundle resourceBundle) {
        super(string, resourceBundle);
    }

    protected ResourceBundle getDefaultResourceBundle() {
        if (a == null) {
            a = IlvResourceUtil.getBundle((String)"dashboard", IlvDashboardAction.class, (Locale)Locale.getDefault());
        }
        return a;
    }

    private static Component b(IlvDiagrammer ilvDiagrammer, ActionEvent actionEvent) {
        JComponent jComponent;
        if (ilvDiagrammer != null) {
            return IlvDashboardAction.getEditor(ilvDiagrammer).getDialogParent();
        }
        Object object = actionEvent.getSource();
        if (object instanceof JComponent && (jComponent = (JComponent)object).getRootPane() != null) {
            return jComponent.getRootPane();
        }
        if (object instanceof Component) {
            return (Component)object;
        }
        return null;
    }

    private static IlvDashboardDiagram b(IlvDashboardEditor ilvDashboardEditor, URL uRL) {
        IlvDashboardDiagramIterator ilvDashboardDiagramIterator = ilvDashboardEditor.getDiagrams();
        while (ilvDashboardDiagramIterator.hasNext()) {
            IlvDashboardDiagram ilvDashboardDiagram = ilvDashboardDiagramIterator.next();
            URL uRL2 = ilvDashboardDiagram.getURL();
            if (uRL2 == null || !uRL2.sameFile(uRL)) continue;
            return ilvDashboardDiagram;
        }
        return null;
    }

    private static URL b(URL uRL, String string) {
        URL uRL2 = null;
        String string2 = uRL.getPath() + string;
        try {
            uRL2 = IlvURLUtil.convertFilenameToAbsoluteURL((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL2;
    }

    private static class SetDefaultMapping
    extends SetMapping {
        SetDefaultMapping() {
            super("Dashboard.Action.SetDefaultMappings");
        }

        protected String getNewMapping(IlvDashboardSymbol ilvDashboardSymbol, IlvDashboardSymbol.Parameter parameter) {
            return parameter.getID();
        }
    }

    private static class ClearMapping
    extends SetMapping {
        ClearMapping() {
            super("Dashboard.Action.ClearMappings");
        }

        protected String getNewMapping(IlvDashboardSymbol ilvDashboardSymbol, IlvDashboardSymbol.Parameter parameter) {
            return null;
        }
    }

    private static abstract class SetMapping
    extends IlvDashboardAction {
        SetMapping(String string) {
            super(string);
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                IlvDashboardDiagram ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer;
                IlvDashboardSymbolIterator ilvDashboardSymbolIterator = ilvDashboardDiagram.getSelectedSymbols();
                CompoundEdit compoundEdit = new CompoundEdit();
                boolean bl = false;
                while (ilvDashboardSymbolIterator.hasNext()) {
                    IlvDashboardSymbol ilvDashboardSymbol = ilvDashboardSymbolIterator.next();
                    MappingEdit mappingEdit = new MappingEdit(ilvDashboardSymbol);
                    int n = ilvDashboardSymbol.getParameterCount();
                    for (int i = 0; i < n; ++i) {
                        IlvDashboardSymbol.Parameter parameter = ilvDashboardSymbol.getParameter(i);
                        String string = ilvDashboardSymbol.getParameterMapping(parameter);
                        String string2 = this.getNewMapping(ilvDashboardSymbol, parameter);
                        ilvDashboardSymbol.setParameterMapping(parameter, string2);
                        mappingEdit.a(parameter, string, string2);
                        if (bl) continue;
                        bl = true;
                    }
                    compoundEdit.addEdit(mappingEdit);
                }
                if (bl) {
                    compoundEdit.end();
                    ilvDashboardDiagram.addUndoableEdit(compoundEdit);
                    ilvDashboardDiagram.setModified(true);
                }
            }
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                return ((IlvDashboardDiagram)ilvDiagrammer).hasSelectedSymbols();
            }
            return false;
        }

        protected abstract String getNewMapping(IlvDashboardSymbol var1, IlvDashboardSymbol.Parameter var2);
    }

    private static class LinkLayoutEnabled
    extends IlvDashboardAction {
        LinkLayoutEnabled() {
            super("Dashboard.Action.LinkLayoutEnabled");
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                IlvDashboardDiagram ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer;
                boolean bl = ilvDashboardDiagram.isLinkLayoutEnabled();
                if (!bl && ilvDashboardDiagram.k()) {
                    ResourceBundle resourceBundle = ilvDashboardDiagram.getContext().getResourceBundle();
                    int n = JOptionPane.showConfirmDialog(ilvDashboardDiagram, resourceBundle.getString("Dashboard.Action.LinkLayoutEnabled.EnablingMessage"), resourceBundle.getString("Dashboard.Action.LinkLayoutEnabled.EnablingTitle"), 2);
                    if (n != 0) {
                        ((AbstractAction)((Object)this)).firePropertyChange("Selected", true, false);
                        return;
                    }
                }
                boolean bl2 = !bl;
                ilvDashboardDiagram.setLinkLayoutEnabled(bl2);
                this.setSelected(bl2);
            }
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer instanceof IlvDashboardDiagram;
        }

        public boolean isSelectable() {
            return true;
        }

        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                return ((IlvDashboardDiagram)ilvDiagrammer).isLinkLayoutEnabled();
            }
            return false;
        }
    }

    private static class MappingEdit
    extends AbstractUndoableEdit {
        private IlvDashboardSymbol a;
        private ArrayList<IlvDashboardSymbol.Parameter> b;
        private ArrayList<String> c;
        private ArrayList<String> d;

        MappingEdit(IlvDashboardSymbol ilvDashboardSymbol) {
            this.a = ilvDashboardSymbol;
            this.b = new ArrayList();
            this.c = new ArrayList();
            this.d = new ArrayList();
        }

        void a(IlvDashboardSymbol.Parameter parameter, String string, String string2) {
            this.b.add(parameter);
            this.c.add(string);
            this.d.add(string2);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            for (int i = 0; i < this.b.size(); ++i) {
                IlvDashboardSymbol.Parameter parameter = this.b.get(i);
                String string = this.d.get(i);
                this.a.setParameterMapping(parameter, string);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            for (int i = 0; i < this.b.size(); ++i) {
                IlvDashboardSymbol.Parameter parameter = this.b.get(i);
                String string = this.c.get(i);
                this.a.setParameterMapping(parameter, string);
            }
        }
    }

    private static class Close
    extends IlvDashboardAction {
        Close() {
            super("Dashboard.Action.Close");
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvDashboardContainer ilvDashboardContainer;
            IlvDashboardEditor ilvDashboardEditor;
            IlvDashboardDiagram ilvDashboardDiagram;
            if (ilvDiagrammer instanceof IlvDashboardDiagram && (ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer).h() && (ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDiagrammer)) != null && (ilvDashboardContainer = ilvDashboardEditor.getDashboardContainer()) != null) {
                ilvDashboardContainer.removeDashboardDiagram(ilvDashboardDiagram);
            }
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null;
        }
    }

    private static class Open
    extends IlvDashboardAction {
        FileFilter a = new FileFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (string.endsWith(".idbin")) return true;
                if (!string.endsWith(".idbd")) return false;
                return true;
            }

            public String getDescription() {
                return Open.this.getDefaultResourceBundle().getString("Dashboard.Action.Open.FileFilterDescription");
            }
        };

        Open() {
            super("Dashboard.Action.Open");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return true;
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            Object object;
            Serializable serializable;
            Object object2;
            Component component = IlvDashboardAction.b(ilvDiagrammer, actionEvent);
            Serializable serializable2 = this.a(component);
            if (serializable2 == null) {
                return;
            }
            boolean bl = false;
            if (this.c((URL)serializable2)) {
                bl = true;
            } else {
                object2 = ((URL)serializable2).getFile();
                if (!((String)object2).endsWith(".idbd")) {
                    if (!((String)object2).endsWith(".idbin")) {
                        serializable = IlvDashboardAction.b((URL)serializable2, ".idbin");
                        if (this.c((URL)serializable)) {
                            bl = true;
                            serializable2 = serializable;
                        } else if (this.c((URL)(serializable2 = IlvDashboardAction.b((URL)serializable2, ".idbd")))) {
                            bl = true;
                        }
                    }
                }
            }
            if (bl) {
                object2 = IlvDashboardAction.getEditor(ilvDiagrammer);
                if (object2 != null && (serializable = IlvDashboardAction.b((IlvDashboardEditor)object2, (URL)serializable2)) != null && (object = ((IlvDashboardEditor)object2).getDashboardContainer()) != null) {
                    object.setSelectedDashboardDiagram((IlvDashboardDiagram)serializable);
                    return;
                }
            } else {
                object2 = this.getResourceBundle().getString("Dashboard.Action.CouldNotOpenFile") + ": " + ((URL)serializable2).getPath();
                JOptionPane.showMessageDialog(component, object2);
                return;
            }
            if (ilvDiagrammer == null || !ilvDiagrammer.isEmpty()) {
                IlvDiagrammerAction._new.actionPerformed(actionEvent);
                ilvDiagrammer = IlvDiagrammer.getCurrentDiagrammer((Component)actionEvent.getSource());
            }
            object2 = (IlvDashboardDiagram)ilvDiagrammer;
            ((IlvDashboardDiagram)object2).setURL((URL)serializable2);
            try {
                if (((URL)serializable2).getFile().endsWith(".idbin")) {
                    ((IlvDashboardDiagram)object2).readBinary((URL)serializable2);
                } else {
                    ((IlvDashboardDiagram)object2).readDashboard((URL)serializable2);
                }
                ((IlvDashboardDiagram)object2).setModified(false);
            }
            catch (IlvDiagrammerException ilvDiagrammerException) {
                object = this.getResourceBundle().getString("Dashboard.Action.NotValidDashboardFile") + ": " + ((URL)serializable2).getPath();
                JOptionPane.showMessageDialog(component, object);
            }
        }

        private boolean c(URL uRL) {
            try {
                uRL.openStream();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private URL a(Component component) {
            URL uRL = null;
            JFileChooser jFileChooser = IlvDiagrammerAction.getActionFileChooser();
            jFileChooser.setDialogType(0);
            ResourceBundle resourceBundle = this.getDefaultResourceBundle();
            jFileChooser.setDialogTitle(resourceBundle.getString("Dashboard.FileChooser.Open"));
            File file = IlvDiagrammerAction.getFileChooserDirectory();
            if (file == null) {
                file = new File(".");
            }
            jFileChooser.setFileFilter(this.a);
            int n = jFileChooser.showOpenDialog(component);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                try {
                    uRL = IlvURLUtil.convertFilenameToAbsoluteURL((String)file2.getAbsolutePath(), (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IlvDiagrammerAction.setFileChooserDirectory(jFileChooser.getCurrentDirectory());
            return uRL;
        }
    }

    private static class Save
    extends SaveAs {
        Save() {
            super("Dashboard.Action.Save");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return super.isEnabled(ilvDiagrammer) && ilvDiagrammer.isModified();
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvDashboardDiagram ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer;
            if (!this.checkFallback(ilvDashboardDiagram)) {
                return;
            }
            URL uRL = ilvDashboardDiagram.getURL();
            if (uRL == null) {
                super.perform(actionEvent, ilvDiagrammer);
            } else {
                try {
                    if (uRL.getFile().endsWith(".idbin")) {
                        ilvDashboardDiagram.writeBinary(uRL);
                    } else {
                        ilvDashboardDiagram.writeDashboard(uRL);
                    }
                    ilvDashboardDiagram.setModified(false);
                }
                catch (Exception exception) {
                    IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDashboardDiagram);
                    String string = this.getResourceBundle().getString("Dashboard.Action.CouldNotWriteFile") + ": " + uRL.getPath();
                    JOptionPane.showMessageDialog(ilvDashboardEditor.getDialogParent(), string);
                }
            }
        }
    }

    private static class SaveAs
    extends IlvDashboardAction {
        SaveAs() {
            super("Dashboard.Action.SaveAs");
        }

        protected SaveAs(String string) {
            super(string);
        }

        protected boolean checkFallback(IlvDashboardDiagram ilvDashboardDiagram) {
            if (ilvDashboardDiagram.l()) {
                IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDashboardDiagram);
                String string = ilvDashboardEditor.getResourceBundle().getString("Dashboard.Action.SaveAs.FallbackWarning");
                JOptionPane.showMessageDialog(ilvDashboardEditor.getDialogParent(), string);
                return false;
            }
            return true;
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer == null) {
                return false;
            }
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkWrite("foo.txt");
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            Object object;
            IlvDashboardDiagram ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer;
            if (!this.checkFallback(ilvDashboardDiagram)) {
                return;
            }
            JFileChooser jFileChooser = IlvDiagrammerAction.getActionFileChooser();
            URL uRL = ilvDashboardDiagram.getURL();
            if (uRL != null) {
                object = IlvURLUtil.convertFileURLToFile((URL)uRL);
                jFileChooser.setSelectedFile((File)object);
                jFileChooser.setCurrentDirectory((File)object);
                IlvDiagrammerAction.setFileChooserDirectory((File)object);
            } else {
                IlvDiagrammerAction.setDefaultSelectedFile(null);
                jFileChooser.setSelectedFile(null);
            }
            object = ilvDashboardDiagram.getContext();
            ResourceBundle resourceBundle = ((IlvDashboardContext)object).getResourceBundle();
            String[] stringArray = new String[2];
            stringArray[0] = ".idbd";
            stringArray[1] = ".idbin";
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Dashboard.FileChooser.FileFilterDescription";
            stringArray2[1] = "Dashboard.FileChooser.FileFilterDescriptionBin";
            URL uRL2 = IlvDiagrammerAction.chooseFile(((IlvDashboardContext)object).getDialogParent(), true, resourceBundle, "Dashboard.FileChooser.SaveAs", stringArray, stringArray2);
            if (uRL2 == null) {
                return;
            }
            IlvDashboardDiagram ilvDashboardDiagram2 = IlvDashboardAction.b((IlvDashboardEditor)object, uRL2);
            if (ilvDashboardDiagram2 != null) {
                JOptionPane.showMessageDialog(ilvDiagrammer, this.getDefaultResourceBundle().getString("Dashboard.Action.SaveAs.FileAlreadyOpen"), this.getDefaultResourceBundle().getString("Dashboard.Action.SaveAs.Name"), 2, null);
                return;
            }
            if (uRL2.getProtocol().equals("file") && IlvURLUtil.convertFileURLToFile((URL)uRL2).exists()) {
                int n = JOptionPane.showOptionDialog(ilvDiagrammer, IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsLabel"), IlvDiagrammerAction.getString(this.getResourceBundle(), "Diagrammer.Action.FileExistsTitle"), 0, 2, null, null, null);
                ComponentAction.fireActionStarted((Action)((Object)this));
                if (n == 1) {
                    return;
                }
            }
            try {
                ilvDashboardDiagram.setURL(uRL2);
                if (uRL2.getFile().endsWith(".idbin")) {
                    ilvDashboardDiagram.writeBinary(uRL2);
                } else {
                    ilvDashboardDiagram.writeDashboard(uRL2);
                }
                ilvDashboardDiagram.setModified(false);
            }
            catch (Exception exception) {
                IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDashboardDiagram);
                String string = this.getResourceBundle().getString("Dashboard.Action.CouldNotWriteFile") + ": " + uRL2.getPath();
                JOptionPane.showMessageDialog(ilvDashboardEditor.getDialogParent(), string);
            }
        }
    }

    private static class DefaultMappingEnabled
    extends IlvDashboardAction {
        DefaultMappingEnabled() {
            super("Dashboard.Action.DefaultMappingEnabled");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer instanceof IlvDashboardDiagram;
        }

        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                return IlvDashboardAction.getEditor(ilvDiagrammer).isDefaultMappingEnabled();
            }
            return false;
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDiagrammer);
            boolean bl = !ilvDashboardEditor.isDefaultMappingEnabled();
            ilvDashboardEditor.setDefaultMappingEnabled(bl);
            this.setSelected(bl);
        }

        public boolean isSelectable() {
            return true;
        }
    }

    private static class GeneralPathEnabled
    extends IlvDashboardAction {
        GeneralPathEnabled() {
            super("Dashboard.Action.GeneralPathEnabled");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer instanceof IlvDashboardDiagram;
        }

        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                return IlvDashboardAction.getEditor(ilvDiagrammer).isGeneralPathEnabled();
            }
            return false;
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDiagrammer);
            boolean bl = !ilvDashboardEditor.isGeneralPathEnabled();
            ilvDashboardEditor.setGeneralPathEnabled(bl);
            this.setSelected(bl);
        }

        public boolean isSelectable() {
            return true;
        }
    }

    private static class BlinkingAllowed
    extends IlvDashboardAction {
        BlinkingAllowed() {
            super("Dashboard.Action.BlinkingAllowed");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer instanceof IlvDashboardDiagram;
        }

        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer instanceof IlvDashboardDiagram) {
                return ilvDiagrammer.getView().getBlinkingMode() != 2;
            }
            return false;
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvSDMView ilvSDMView = ilvDiagrammer.getView();
            if (ilvSDMView.getBlinkingMode() == 2) {
                ilvSDMView.setBlinkingMode(0);
                this.setSelected(true);
            } else {
                ilvSDMView.setBlinkingMode(2);
                this.setSelected(false);
            }
        }

        public boolean isSelectable() {
            return true;
        }
    }

    private static class ShowHiddenObjects
    extends IlvDashboardAction {
        ShowHiddenObjects() {
            super("Dashboard.Action.ShowHiddenObjects");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null && ilvDiagrammer.isEditable();
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            IlvGrapher ilvGrapher = ilvDiagrammer.getEngine().getGrapher();
            ilvGrapher.initReDraws();
            ilvGrapher.setContentsAdjusting(true);
            ilvGrapher.map(new IlvApplyObject((IlvManager)ilvGrapher){
                final /* synthetic */ IlvManager a;
                {
                    this.a = ilvManager;
                }

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    this.a.setVisible(ilvGraphic, true, true);
                }
            }, null);
            ilvGrapher.setContentsAdjusting(false);
            ilvGrapher.reDrawViews();
        }
    }

    private static class SendBack
    extends StackingOrderAction {
        SendBack() {
            super("Dashboard.Action.SendBack");
        }

        int a(IlvManagerLayer ilvManagerLayer, IlvGraphic ilvGraphic) {
            return 0;
        }

        int a(IlvDefaultSDMModel ilvDefaultSDMModel, Object object) {
            Enumeration enumeration = ilvDefaultSDMModel.getObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.isSameModelObjectKind(ilvDefaultSDMModel, e, object)) continue;
                return ilvDefaultSDMModel.getObjectIndex(e);
            }
            return ilvDefaultSDMModel.getObjectIndex(object);
        }

        int a(IlvDashboardDiagram ilvDashboardDiagram, IlvDashboardSymbol ilvDashboardSymbol) {
            int n = ilvDashboardDiagram.i();
            for (int i = 0; i < n; ++i) {
                if (!this.isSameSymbolKind(ilvDashboardDiagram.a(i), ilvDashboardSymbol)) continue;
                return i;
            }
            return ilvDashboardDiagram.getSymbolIndex(ilvDashboardSymbol);
        }
    }

    private static class SendBackward
    extends StackingOrderAction {
        SendBackward() {
            super("Dashboard.Action.SendBackward");
        }

        int a(IlvManagerLayer ilvManagerLayer, IlvGraphic ilvGraphic) {
            int n = ilvManagerLayer.getIndex(ilvGraphic);
            if (n > 0) {
                --n;
            }
            return n;
        }

        int a(IlvDefaultSDMModel ilvDefaultSDMModel, Object object) {
            Object e;
            Enumeration enumeration = ilvDefaultSDMModel.getObjects();
            Object object2 = object;
            while (enumeration.hasMoreElements() && (e = enumeration.nextElement()) != object) {
                if (!this.isSameModelObjectKind(ilvDefaultSDMModel, e, object)) continue;
                object2 = e;
            }
            return ilvDefaultSDMModel.getObjectIndex(object2);
        }

        int a(IlvDashboardDiagram ilvDashboardDiagram, IlvDashboardSymbol ilvDashboardSymbol) {
            int n = ilvDashboardDiagram.getSymbolIndex(ilvDashboardSymbol);
            for (int i = n - 1; i >= 0; --i) {
                if (!this.isSameSymbolKind(ilvDashboardDiagram.a(i), ilvDashboardSymbol)) continue;
                return i;
            }
            return n;
        }
    }

    private static class BringForward
    extends StackingOrderAction {
        BringForward() {
            super("Dashboard.Action.BringForward");
        }

        int a(IlvManagerLayer ilvManagerLayer, IlvGraphic ilvGraphic) {
            int n = ilvManagerLayer.getIndex(ilvGraphic);
            if (n < ilvManagerLayer.getCardinal() - 1) {
                ++n;
            }
            return n;
        }

        int a(IlvDefaultSDMModel ilvDefaultSDMModel, Object object) {
            Enumeration enumeration = ilvDefaultSDMModel.getObjects();
            while (enumeration.hasMoreElements() && enumeration.nextElement() != object) {
            }
            Object object2 = object;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.isSameModelObjectKind(ilvDefaultSDMModel, e, object)) continue;
                object2 = e;
                break;
            }
            return ilvDefaultSDMModel.getObjectIndex(object2);
        }

        int a(IlvDashboardDiagram ilvDashboardDiagram, IlvDashboardSymbol ilvDashboardSymbol) {
            int n = ilvDashboardDiagram.getSymbolIndex(ilvDashboardSymbol);
            int n2 = ilvDashboardDiagram.i();
            for (int i = n + 1; i < n2; ++i) {
                if (!this.isSameSymbolKind(ilvDashboardSymbol, ilvDashboardDiagram.a(i))) continue;
                return i;
            }
            return n;
        }
    }

    private static class BringToFront
    extends StackingOrderAction {
        BringToFront() {
            super("Dashboard.Action.BringToFront");
        }

        int a(IlvManagerLayer ilvManagerLayer, IlvGraphic ilvGraphic) {
            return ilvManagerLayer.getCardinal() - 1;
        }

        int a(IlvDefaultSDMModel ilvDefaultSDMModel, Object object) {
            Enumeration enumeration = ilvDefaultSDMModel.getObjects();
            Object object2 = object;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.isSameModelObjectKind(ilvDefaultSDMModel, object, e)) continue;
                object2 = e;
            }
            int n = ilvDefaultSDMModel.getObjectIndex(object2);
            return n;
        }

        int a(IlvDashboardDiagram ilvDashboardDiagram, IlvDashboardSymbol ilvDashboardSymbol) {
            for (int i = ilvDashboardDiagram.i() - 1; i >= 0; --i) {
                IlvDashboardSymbol ilvDashboardSymbol2 = ilvDashboardDiagram.a(i);
                if (!this.isSameSymbolKind(ilvDashboardSymbol, ilvDashboardSymbol2)) continue;
                return i;
            }
            return ilvDashboardDiagram.i() - 1;
        }
    }

    private static abstract class StackingOrderAction
    extends IlvDashboardAction {
        protected StackingOrderAction(String string) {
            super(string);
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer instanceof IlvDashboardDiagram && ((IlvDashboardDiagram)ilvDiagrammer).canEdit();
        }

        private static IlvDefaultSDMModel c(IlvDashboardDiagram ilvDashboardDiagram) {
            IlvSDMModel ilvSDMModel = ilvDashboardDiagram.getEngine().getModel();
            while (ilvSDMModel instanceof IlvFilterSDMModel) {
                ilvSDMModel = ((IlvFilterSDMModel)ilvSDMModel).getFilteredModel();
            }
            return ilvSDMModel instanceof IlvDefaultSDMModel ? (IlvDefaultSDMModel)ilvSDMModel : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            if (!(ilvDiagrammer instanceof IlvDashboardDiagram)) {
                return;
            }
            IlvDashboardDiagram ilvDashboardDiagram = (IlvDashboardDiagram)ilvDiagrammer;
            ArrayList<IlvGraphic> arrayList = ilvDashboardDiagram.d();
            if (arrayList.size() > 0) {
                IlvManager ilvManager = ilvDashboardDiagram.getView().getManager();
                ilvManager.initReDraws();
                ilvManager.setContentsAdjusting(true);
                try {
                    IlvDashboardManagerCompoundEdit ilvDashboardManagerCompoundEdit = new IlvDashboardManagerCompoundEdit(ilvManager);
                    ArrayListGraphicIterator arrayListGraphicIterator = new ArrayListGraphicIterator(arrayList);
                    while (arrayListGraphicIterator.hasNext()) {
                        IlvGraphic ilvGraphic = arrayListGraphicIterator.next();
                        IlvDashboardSymbol ilvDashboardSymbol = ilvDashboardDiagram.getGraphicSymbol(ilvGraphic);
                        IlvManagerLayer ilvManagerLayer = ilvManager.getManagerLayer(ilvGraphic);
                        int n = this.a(ilvManagerLayer, ilvGraphic);
                        int n2 = ilvManagerLayer.getIndex(ilvGraphic);
                        if (n2 != n) {
                            ilvManagerLayer.setIndex(ilvGraphic, n);
                            ilvDashboardManagerCompoundEdit.addEdit(new IlvDashboardIndexEdit(ilvGraphic, n2, n));
                        }
                        if (ilvDashboardSymbol != null) {
                            int n3;
                            Object object;
                            IlvDefaultSDMModel ilvDefaultSDMModel = StackingOrderAction.c(ilvDashboardDiagram);
                            int n4 = this.a(ilvDefaultSDMModel, object = ilvDashboardSymbol.getModelObject());
                            if (n4 != (n3 = ilvDefaultSDMModel.getObjectIndex(object))) {
                                ilvDefaultSDMModel.moveObjectTo(object, n4);
                            }
                            int n5 = ilvDashboardDiagram.getSymbolIndex(ilvDashboardSymbol);
                            int n6 = this.a(ilvDashboardDiagram, ilvDashboardSymbol);
                            if (n6 != n5) {
                                ilvDashboardDiagram.setSymbolIndex(ilvDashboardSymbol, n6);
                            }
                            ilvDashboardManagerCompoundEdit.addEdit(new SymbolIndexEdit(ilvDashboardSymbol, n5, n6, n3, n4));
                        }
                        ilvManager.invalidateRegion(ilvGraphic);
                    }
                    ilvDashboardManagerCompoundEdit.end();
                    ilvDashboardDiagram.addUndoableEdit(ilvDashboardManagerCompoundEdit);
                }
                catch (Exception exception) {
                }
                finally {
                    ilvManager.setContentsAdjusting(false);
                    ilvManager.reDrawViews();
                }
            }
        }

        abstract int a(IlvManagerLayer var1, IlvGraphic var2);

        abstract int a(IlvDefaultSDMModel var1, Object var2);

        abstract int a(IlvDashboardDiagram var1, IlvDashboardSymbol var2);

        protected boolean isSameSymbolKind(IlvDashboardSymbol ilvDashboardSymbol, IlvDashboardSymbol ilvDashboardSymbol2) {
            if (ilvDashboardSymbol.isLink()) {
                return ilvDashboardSymbol2.isLink();
            }
            return !ilvDashboardSymbol2.isLink();
        }

        protected boolean isSameModelObjectKind(IlvSDMModel ilvSDMModel, Object object, Object object2) {
            if (ilvSDMModel.isLink(object)) {
                return ilvSDMModel.isLink(object2);
            }
            return !ilvSDMModel.isLink(object2);
        }

        private static class SymbolIndexEdit
        extends AbstractUndoableEdit {
            private IlvDashboardSymbol a;
            private int b;
            private int c;
            private int d;
            private int e;

            SymbolIndexEdit(IlvDashboardSymbol ilvDashboardSymbol, int n, int n2, int n3, int n4) {
                this.a = ilvDashboardSymbol;
                this.b = n;
                this.c = n2;
                this.d = n3;
                this.e = n4;
            }

            public void redo() throws CannotRedoException {
                super.redo();
                IlvDashboardDiagram ilvDashboardDiagram = this.a.getDiagram();
                if (this.b != this.c) {
                    ilvDashboardDiagram.setSymbolIndex(this.a, this.c);
                }
                if (this.d != this.e) {
                    IlvDefaultSDMModel ilvDefaultSDMModel = StackingOrderAction.c(ilvDashboardDiagram);
                    ilvDefaultSDMModel.moveObjectTo(this.a.getModelObject(), this.e);
                }
            }

            public void undo() throws CannotUndoException {
                super.undo();
                IlvDashboardDiagram ilvDashboardDiagram = this.a.getDiagram();
                if (this.b != this.c) {
                    ilvDashboardDiagram.setSymbolIndex(this.a, this.b);
                }
                if (this.d != this.e) {
                    IlvDefaultSDMModel ilvDefaultSDMModel = StackingOrderAction.c(ilvDashboardDiagram);
                    ilvDefaultSDMModel.moveObjectTo(this.a.getModelObject(), this.d);
                }
            }
        }
    }

    private static class Import
    extends IlvDashboardAction {
        private JFileChooser a;
        private FileFilter b = new FileFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (string.endsWith(".ivl")) return true;
                if (string.endsWith(".svg")) return true;
                if (string.endsWith(".svgz")) return true;
                if (!string.endsWith(".dxf")) return false;
                return true;
            }

            public String getDescription() {
                return Import.this.getDefaultResourceBundle().getString("Dashboard.Action.Import.FileFilterDescription");
            }
        };

        Import() {
            super("Dashboard.Action.Import");
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null && ilvDiagrammer.isEditable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            File file;
            if (ilvDiagrammer == null) {
                return;
            }
            JFileChooser jFileChooser = this.d();
            int n = jFileChooser.showOpenDialog(ilvDiagrammer);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                IlvGraphic ilvGraphic = IlvURLGraphic.get("file:" + file.toString());
                if (ilvGraphic instanceof IlvGraphicSet) {
                    IlvGrapher ilvGrapher = ilvDiagrammer.getEngine().getGrapher();
                    ilvGraphic.move(0.0f, 0.0f);
                    IlvDashboardEditor ilvDashboardEditor = IlvDashboardAction.getEditor(ilvDiagrammer);
                    String string = ilvDashboardEditor.getResourceBundle().getString("Dashboard.Action.Import.UngroupMessage");
                    ilvGrapher.initReDraws();
                    try {
                        ilvGrapher.addObject(ilvGraphic, true);
                        ilvGrapher.setSelected(ilvGraphic, true, true);
                    }
                    finally {
                        ilvGrapher.reDrawViews();
                    }
                    JOptionPane.showMessageDialog(ilvDashboardEditor.getDialogParent(), string);
                } else {
                    ResourceBundle resourceBundle = IlvResourceUtil.getBundle((String)"application", IlvDiagrammerAction.class);
                    ComponentAction.error((Component)ilvDiagrammer, (ResourceBundle)resourceBundle, (String)"Diagrammer.Application.CannotOpenDataFile", (Object[])new Object[]{file}, null);
                }
            }
        }

        private JFileChooser d() {
            if (this.a == null) {
                this.a = new JFileChooser();
                this.a.setDialogType(0);
                ResourceBundle resourceBundle = this.getDefaultResourceBundle();
                this.a.setDialogTitle(resourceBundle.getString("Dashboard.Action.Import.ShortDescription"));
                this.a.setFileFilter(this.b);
            }
            return this.a;
        }
    }
}

