/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.olap.util.ButtonMenu;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.OLAPDVImagesArb;
import oracle.olapdv.app.ModelTableCellEditor;
import oracle.olapdv.app.ModelTableCellRenderer;
import oracle.olapdv.app.ModelValidation;
import oracle.olapdv.app.ModelViewer;
import oracle.olapdv.app.ProgressStatusDialog;
import oracle.olapdv.app.ProgressStatusPanel;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.util.MiscUtils;

public class ModelPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
ModelValidation {
    private JTable m_table;
    private DefaultTableModel m_tableModel;
    private Component m_parentComponent;
    private ModelViewer m_modelViewer;
    private ValidateModelDO m_validateModelDO;
    private ModelPanel m_modelPanel;
    private int m_lastRow;
    private int m_lastColumn;
    private JTabbedPane modelTab = new JTabbedPane();
    private List<JMenuItem> items = new ArrayList<JMenuItem>();
    private ModelTableCellRenderer cellRenderer;
    private ImageIcon errorIcon;
    private ImageIcon successIcon;
    private ImageIcon warningIcon;
    protected static final int STATUS_COL = 0;
    protected static final int DIMENSION_NAME_COL = 1;
    protected static final int HIERARCHY_NAME_COL = 2;
    protected static final int LEVEL_NAME_COL = 3;
    protected static final int LEVEL_DEPTH_COL = 4;
    protected static final int OWNER_NAME_COL = 5;
    protected static final int TABLE_NAME_COL = 6;
    protected static final int MEMBER_COL = 7;
    protected static final int DESCRIPTION_COL = 8;
    protected static final int PARENT_COL = 9;
    protected static final int TOTAL_MODEL_COLUMN_COUNT = 10;

    public ModelPanel(Component component, ModelViewer modelViewer, ValidateModelDO validateModelDO) {
        this.m_parentComponent = component;
        this.m_modelViewer = modelViewer;
        this.m_validateModelDO = validateModelDO;
        this.m_modelPanel = this;
        this.jbinit();
    }

    public void setModelDO(ValidateModelDO validateModelDO) {
        this.m_validateModelDO = validateModelDO;
    }

    public void refreshTableData() {
        Object[][] objectArray = this.getModelData();
        Object[] objectArray2 = this.getColumns();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_tableModel);
        this.setColumnWidths();
        this.m_lastRow = -1;
        this.m_lastColumn = -1;
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    public void refreshTopLabel(String string) {
        this.modelTab.setTitleAt(0, string);
    }

    private void jbinit() {
        this.errorIcon = new ImageIcon(OLAPDVImagesArb.getImage("ERROR_ICON"));
        this.successIcon = new ImageIcon(OLAPDVImagesArb.getImage("SUCCESS_ICON"));
        this.warningIcon = new ImageIcon(OLAPDVImagesArb.getImage("WARNING_ICON"));
        JPanel jPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        JToggleButton jToggleButton = ButtonMenu.createButtonMenu((String)OLAPDVArb.getString("ACTION_BUTTON"), null, this.items);
        jToggleButton.setMnemonic(65);
        ++gridBagConstraints.gridy;
        Object[][] objectArray = this.getModelData();
        Object[] objectArray2 = this.getColumns();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.cellRenderer = new ModelTableCellRenderer();
        this.m_table = new JTable(this.m_tableModel){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return ModelPanel.this.cellRenderer;
            }
        };
        this.cellRenderer.setModelReady(false);
        this.cellRenderer.setModelValidation(this);
        int n = this.m_table.getRowHeight();
        this.m_table.setRowHeight((int)((double)n * 1.5));
        this.m_table.setSelectionMode(0);
        this.m_table.setBackground(Color.WHITE);
        this.m_table.setAutoResizeMode(0);
        ModelTableCellEditor modelTableCellEditor = new ModelTableCellEditor();
        this.m_table.setDefaultEditor(Object.class, modelTableCellEditor);
        this.setColumnWidths();
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.m_lastRow = -1;
        this.m_lastColumn = -1;
        this.modelTab.add(OLAPDVArb.getString("MODEL_DETAILS"), jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)this.modelTab, gridBagConstraints);
    }

    public ModelViewer getModelViewer() {
        return this.m_modelViewer;
    }

    public JPopupMenu getPopupMenu() {
        this.items = new ArrayList<JMenuItem>();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(OLAPDVArb.getString("CHECK_MODEL_SOURCE_MAPPINGS"));
        jMenuItem.setActionCommand("VALIDATE_MAPPINGS");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.items.add(jMenuItem);
        return jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("VALIDATE_MAPPINGS")) {
            final ProgressStatusDialog progressStatusDialog = new ProgressStatusDialog((JDialog)this.m_parentComponent, OLAPDVArb.format("RUNNING_MODEL_VALIDATION_TITLE", this.m_validateModelDO.getName()), OLAPDVArb.format("RUNNING_MODEL_VALIDATION_MSG", this.m_validateModelDO.getName()), false);
            Rectangle rectangle = MiscUtils.centerWindow(this.m_parentComponent, 600, 200);
            progressStatusDialog.setBounds(rectangle);
            progressStatusDialog.initializeDialogPanel();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ModelPanel.this.doModelValidation(progressStatusDialog);
                }
            };
            thread.start();
            progressStatusDialog.setModal(true);
            progressStatusDialog.setVisible(true);
        }
    }

    public void doModelValidation(ProgressStatusDialog progressStatusDialog) {
        QueryManager queryManager = new QueryManager();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        LevelDO levelDO = null;
        ProgressStatusPanel progressStatusPanel = progressStatusDialog.getProgressStatusPanel();
        ArrayList<DimensionDO> arrayList3 = this.m_validateModelDO.getDimensionDOs();
        int n = arrayList3.size();
        int n2 = 1;
        for (DimensionDO dimensionDO : arrayList3) {
            boolean bl2;
            dimensionDO.setValidState(true);
            progressStatusPanel.updateProgressBar((int)((double)n2 / (double)n * 100.0));
            progressStatusPanel.updateProgressLabel(OLAPDVArb.format("RUNNING_MODEL_VALIDATION_DETAIL_MSG", dimensionDO.getName()));
            ArrayList<HierarchyDO> arrayList4 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList4) {
                ArrayList<LevelDO> arrayList5 = hierarchyDO.getLevelDOs();
                arrayList.clear();
                arrayList2.clear();
                for (LevelDO levelDO2 : arrayList5) {
                    LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
                    String string = levelMapDO.getOwner();
                    String string2 = levelMapDO.getTableName();
                    String string3 = levelMapDO.getColumnName();
                    String string4 = levelMapDO.getLongDescriptionColumnName();
                    String string5 = levelMapDO.getParentColumnName();
                    levelDO2.setValidState(LevelDO.ValidStates.VALID_OK);
                    levelMapDO.setOwnerNameValid(true);
                    levelMapDO.setTableNameValid(true);
                    levelMapDO.setKeyColumnValid(true);
                    levelMapDO.setDescColumnValid(true);
                    levelMapDO.setSnowflakeColumnValid(true);
                    if (string == null || string2 == null || string3 == null || string4 == null) {
                        if (string == null) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setOwnerNameValid(false);
                        }
                        if (string2 == null) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setTableNameValid(false);
                        }
                        if (!levelMapDO.isKeyColumnMapSupported()) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setKeyColumnValid(false);
                        }
                        if (string3 == null) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setKeyColumnValid(false);
                        }
                        if (!levelMapDO.isDescColumnMapSupported()) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setDescColumnValid(false);
                        }
                        if (string4 == null || string4.equals("null")) {
                            dimensionDO.setValidState(false);
                            levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setDescColumnValid(false);
                        }
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        continue;
                    }
                    if (arrayList.contains(string + "." + string2 + "." + string3)) {
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setKeyColumnValid(false);
                    } else {
                        arrayList.add(string + "." + string2 + "." + string3);
                    }
                    if (arrayList2.contains(string + "." + string2 + "." + string4)) {
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setDescColumnValid(false);
                    } else {
                        arrayList2.add(string + "." + string2 + "." + string4);
                    }
                    if (!queryManager.isOwnerValid(string)) {
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        continue;
                    }
                    if (!queryManager.isTableNameValid(string, string2)) {
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setTableNameValid(false);
                        continue;
                    }
                    if (levelMapDO.isKeyColumnValid() && !queryManager.isColumnNameValid(string, string2, string3)) {
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setKeyColumnValid(false);
                    }
                    if (levelMapDO.isDescColumnValid() && !queryManager.isColumnNameValid(string, string2, string4)) {
                        if (!bl) {
                            levelDO = levelDO2;
                        }
                        bl = true;
                        dimensionDO.setValidState(false);
                        levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setDescColumnValid(false);
                    }
                    if (string5 == null || string5.length() <= 0 || queryManager.isColumnNameValid(string, string2, string5)) continue;
                    if (!bl) {
                        levelDO = levelDO2;
                    }
                    bl = true;
                    dimensionDO.setValidState(false);
                    levelDO2.setValidState(LevelDO.ValidStates.VALID_ERROR);
                    levelMapDO.setSnowflakeColumnValid(false);
                }
            }
            ++n2;
            if (dimensionDO.getValidState() || !(bl2 = dimensionDO.supportPossibleTopLevelMemberLiteralMapping())) continue;
            dimensionDO.setValidState(true);
        }
        this.cellRenderer.setModelReady(true);
        progressStatusDialog.dispose();
    }

    public void repaintModelTable() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ModelPanel.this.repaintModelTableImpl();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintModelTableImpl();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void repaintModelTableImpl() {
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    public int findRowInTableForLevel(LevelDO levelDO) {
        int n = -1;
        int n2 = this.m_table.getRowCount();
        String string = levelDO.getOwningDimensionName();
        String string2 = levelDO.getOwningHierarchyName();
        String string3 = levelDO.getName();
        for (int i = 0; i < n2; ++i) {
            String string4 = (String)this.m_table.getValueAt(i, 1);
            String string5 = (String)this.m_table.getValueAt(i, 2);
            String string6 = (String)this.m_table.getValueAt(i, 3);
            if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5) || !string3.equalsIgnoreCase(string6)) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public LevelDO getLevelDOFromModelTableAtRow(int n) {
        LevelDO levelDO = null;
        int n2 = 0;
        boolean bl = false;
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        block0: for (DimensionDO dimensionDO : arrayList) {
            if (bl) break;
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            block1: for (HierarchyDO hierarchyDO : arrayList2) {
                if (bl) continue block0;
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO2 : arrayList3) {
                    if (n == n2) {
                        levelDO = levelDO2;
                        bl = true;
                        continue block1;
                    }
                    ++n2;
                }
            }
        }
        return levelDO;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_table.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (!bl) {
            if (n == this.m_lastRow && n2 == this.m_lastColumn) {
                return;
            }
            if (n < 0) {
                return;
            }
            this.m_lastRow = n;
            this.m_lastColumn = n2;
        }
    }

    private Object[][] getModelData() {
        Object[][] objectArray = null;
        if (this.m_validateModelDO == null) {
            return objectArray;
        }
        int n = !this.m_validateModelDO.isEmpty() ? this.m_validateModelDO.getModelRowCount() : 0;
        objectArray = n > 0 ? new Object[n][10] : new Object[1][10];
        int n2 = 0;
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    objectArray[n2][0] = levelDO.getValidState() == LevelDO.ValidStates.VALID_OK ? this.successIcon : (levelDO.getValidState() == LevelDO.ValidStates.VALID_WARNING ? this.successIcon : this.errorIcon);
                    objectArray[n2][1] = dimensionDO.getName();
                    objectArray[n2][2] = hierarchyDO.getName();
                    objectArray[n2][3] = levelDO.getName();
                    objectArray[n2][4] = Integer.valueOf(levelDO.getDepth()).toString();
                    objectArray[n2][5] = levelMapDO.getOwner();
                    objectArray[n2][6] = levelMapDO.getTableName();
                    objectArray[n2][7] = levelMapDO.getColumnName();
                    objectArray[n2][8] = levelMapDO.getLongDescriptionColumnName();
                    objectArray[n2][9] = levelMapDO.getParentColumnName();
                    ++n2;
                }
            }
        }
        return objectArray;
    }

    public String[] getColumns() {
        String[] stringArray = new String[]{OLAPDVArb.getString("STATUS_HEADER"), OLAPDVArb.getString("DIMENSION_HEADER"), OLAPDVArb.getString("HIERARCHY_HEADER"), OLAPDVArb.getString("LEVEL_HEADER"), OLAPDVArb.getString("DEPTH_HEADER"), OLAPDVArb.getString("OWNER_HEADER"), OLAPDVArb.getString("TABLE_NAME_HEADER"), OLAPDVArb.getString("KEY_COLUMN_HEADER"), OLAPDVArb.getString("DESCRIPTION_COLUMN_HEADER"), OLAPDVArb.getString("PARENT_COLUMN_SNOWFLAKE_HEADER")};
        return stringArray;
    }

    private void setColumnWidths() {
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(110);
        this.m_table.getColumnModel().getColumn(3).setPreferredWidth(110);
        this.m_table.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.m_table.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.m_table.getColumnModel().getColumn(6).setPreferredWidth(120);
        this.m_table.getColumnModel().getColumn(7).setPreferredWidth(130);
        this.m_table.getColumnModel().getColumn(8).setPreferredWidth(130);
        this.m_table.getColumnModel().getColumn(9).setPreferredWidth(150);
    }

    protected static Point getSuitableLocation(Point point, Dimension dimension, Component component) {
        Component component2;
        for (component2 = component; component2 != null && !(component2 instanceof JFrame) && !(component2 instanceof JDialog); component2 = component2.getParent()) {
        }
        if (component2 != null) {
            int n;
            int n2;
            Rectangle rectangle = component2.getBounds();
            SwingUtilities.convertPointToScreen(point, component);
            if (point.x + dimension.width > rectangle.x + rectangle.width) {
                n2 = rectangle.x + rectangle.width - dimension.width;
                if (n2 > 16) {
                    n2 -= 16;
                }
            } else {
                n2 = point.x;
            }
            if (point.y + dimension.height > rectangle.y + rectangle.height) {
                n = rectangle.y + rectangle.height - dimension.height;
                if (n > 16) {
                    n -= 16;
                }
            } else {
                n = point.y;
            }
            if (n2 >= 0 && n >= 0) {
                point.x = n2;
                point.y = n;
            }
        }
        SwingUtilities.convertPointFromScreen(point, component);
        return point;
    }

    public void notifyCellRendererReady() {
        this.cellRenderer.setModelReady(true);
    }
}

