/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.dbtools.raptor.usage.UsagesTracker;
import oracle.dbtools.raptor.usages.EditorTracker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;

public class UsageTrackerInitializer {
    private static EditorListener _editorListener = null;
    private static ConnectionListener _connListener;

    public static void init() {
        EditorManager.getEditorManager().addEditorListener(UsageTrackerInitializer.getEditorListener());
        Connections.getInstance().addConnectionListener(UsageTrackerInitializer.getConnectionListener());
    }

    private static ConnectionListener getConnectionListener() {
        if (_connListener == null) {
            _connListener = new ConnectionListener(){

                public void connectionAdded(ConnectionEvent connectionEvent) {
                }

                public void connectionRemoved(ConnectionEvent connectionEvent) {
                }

                public void connectionRenamed(ConnectionEvent connectionEvent) {
                }

                public void connectionModified(ConnectionEvent connectionEvent) {
                }

                public void connectionOpened(ConnectionEvent connectionEvent) {
                    try {
                        Connection connection = Connections.getInstance().getConnection(connectionEvent.getConnectionName());
                        if (connection != null) {
                            UsageData usageData = UsagesTracker.getUsagesTracker().createUsageData();
                            usageData.setEventId("connection-open");
                            usageData.setEventSource(connectionEvent.getConnectionName());
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("db-name", connection.getMetaData().getDatabaseProductName());
                            hashMap.put("db-version", connection.getMetaData().getDatabaseProductVersion());
                            hashMap.put("driver-version", connection.getMetaData().getDriverVersion());
                            usageData.addDataPoint("values", hashMap);
                            UsagesTracker.getUsagesTracker().report(usageData);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getAnonymousLogger().info(exception.getLocalizedMessage());
                    }
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                }
            };
        }
        return _connListener;
    }

    private static EditorListener getEditorListener() {
        if (_editorListener == null) {
            _editorListener = new EditorTracker();
        }
        return _editorListener;
    }
}

