/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.wiz.import_;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.util.FilePanel;

public class ImportLocationPanel
extends DefaultTraversablePanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblSource = new JLabel();
    private FilePanel srcFolder = new FilePanel();
    private JMultiLineLabel hintText = new JMultiLineLabel();
    private boolean populated = false;

    public ImportLocationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        if (!this.populated && dataContext.getDirection() == 1) {
            URL srcFld = (URL)dataContext.get("source_folder");
            this.srcFolder.setURL(srcFld);
            this.populated = true;
        }
        dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            URL srcURL = this.srcFolder.getURL();
            if (!URLFileSystem.exists((URL)srcURL)) {
                throw new TraversalException(PerforceArb.format("IMPORT_SRC_FLD_EXIST", URLFileSystem.getPlatformPathName((URL)srcURL)));
            }
            dataContext.put("source_folder", (Object)srcURL);
        }
    }

    private void jbInit() throws Exception {
        JPanel dummy = new JPanel();
        this.setLayout(this.gridBagLayout1);
        this.srcFolder.setChooseFolders(true);
        ResourceUtils.resLabel((JLabel)this.lblSource, (Component)this.srcFolder, (String)PerforceArb.get("IMPORT_LOCATION_SOURCE"));
        this.hintText.setText(PerforceArb.get("IMPORT_LOCATION_HINT"));
        this.add((Component)this.hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 15, 5), 0, 0));
        this.add(this.lblSource, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.srcFolder, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(dummy, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }
}

