/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.wiz;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.FSMWizard;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;

public abstract class PerforceWizard {
    VCSExceptionHandler exceptionHandler;

    public WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        WizardDialog wd;
        Dialog dlg = DialogUtil.getAncestorDialog((Component)parent);
        if (dlg != null) {
            wd = wizard.getDialog(dlg);
        } else {
            Frame f = DialogUtil.getAncestorFrame((Component)parent);
            wd = wizard.getDialog(f);
        }
        wizard.addCommitListener((CommitListener)new WizardCommitListener(wd));
        return wd;
    }

    protected VCSExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new VCSExceptionHandler();
        }
        return this.exceptionHandler;
    }

    protected abstract boolean commitWizard();

    private class WizardCommitListener
    implements CommitListener {
        private WizardDialog dialog;

        public WizardCommitListener(WizardDialog wd) {
            this.dialog = wd;
        }

        public void checkCommit(ApplyEvent applyevent) throws TraversalException {
        }

        public void commit(ApplyEvent event) throws TraversalException {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!PerforceWizard.this.commitWizard()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WizardCommitListener.this.dialog.dispose();
                        }
                    });
                }
            }, "Perforce Wizard Commit Thread").start();
        }

        public void rollback(ApplyEvent applyevent) {
        }

        public void cancel(ApplyEvent applyevent) {
        }
    }
}

