/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.PerforceChangeListName;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceSessionLostException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.ClientInfo;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;

public class PerforceUtil {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceUtil.class.getName());

    public static String getDefaultChangelist(PerforceConnectionProfile connect) throws Exception {
        PerforceUtil.getChangelistData(connect);
        return PerforceChangeListName.getDefaultChangelist();
    }

    public static Collection getFromServerChangelistNo(PerforceConnectionProfile connect) throws Exception {
        return PerforceUtil.getChangelistData(connect).getFromServerChangelistNo();
    }

    public static String getChangelistNo(PerforceConnectionProfile connect, String changelist) throws Exception {
        return PerforceUtil.getChangelistData(connect).getChangelistNo(changelist);
    }

    public static Collection<String> getChangelistNo(PerforceConnectionProfile connect) throws Exception {
        return PerforceUtil.getChangelistData(connect).getChangelistNo();
    }

    public static String getName(PerforceConnectionProfile connect, String changeNo) throws Exception {
        return PerforceUtil.getChangelistData(connect).getName(changeNo);
    }

    public static String getLongLabel(PerforceConnectionProfile connect, String changeNo) throws Exception {
        return PerforceUtil.getChangelistData(connect).getLongLabelName(changeNo);
    }

    public static void changelistModified(PerforceConnectionProfile connect, String changeNo) throws Exception {
        PerforceUtil.getChangelistData(connect).changelistModified(connect, changeNo);
    }

    public static void changelistSubmitted(PerforceConnectionProfile connect, String changeNo) throws Exception {
        PerforceUtil.getChangelistData(connect).changelistSubmitted(connect, changeNo);
    }

    public static void clear(PerforceConnectionProfile connect) throws Exception {
        PerforceChangeListName clName = PerforceUtil.getChangelistData(connect);
        if (clName != null) {
            clName.clear();
        }
    }

    public static void changelistCreate(PerforceConnectionProfile connect, String changelistNo) throws Exception {
        PerforceUtil.getChangelistData(connect).changelistCreate(connect, changelistNo);
    }

    public static void getWorkspaceFiles(PerforceConnectionProfile connect, Collection<ChangeListFile> CLFiles) throws VCSException {
        if (CLFiles.isEmpty()) {
            return;
        }
        LinkedHashMap<String, ChangeListFile> info = new LinkedHashMap<String, ChangeListFile>(CLFiles.size());
        ArrayList<String> files = new ArrayList<String>();
        for (ChangeListFile clFile : CLFiles) {
            String filename = clFile.getDepotFile();
            String[] parts = filename.split("#");
            files.add(parts[0]);
            info.put(parts[0], clFile);
        }
        PerforceFstatResult[] results = PerforceGetStatus.fstat(connect, files);
        if (results.length == 0) {
            sLogger.log(Level.WARNING, "Failed to find workspace files");
        }
        for (PerforceFstatResult result : results) {
            ChangeListFile changeFile = (ChangeListFile)info.get(result.getDepotFile());
            changeFile.setWorkspaceFile(result.getClientFile());
        }
    }

    public static boolean isPerforceClientValid(String username, String server, String client) {
        Map<String, ClientInfo> clients = null;
        try {
            clients = PerforceCommands.getUserClientSpec(username, server, true);
            return clients.containsKey(client);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String parseErrorMessage(String msg, String hostname) {
        if (msg == null) {
            return null;
        }
        if (msg.contains(hostname)) {
            return msg;
        }
        return PerforceArb.get("ERROR_USERNAME_OR_PASSWD");
    }

    public static void isErrorConnection(PerforceShellRunner runner, PerforceConnectionProfile connect, String title) throws PerforceSessionLostException {
        if (runner.connectionError()) {
            throw new PerforceSessionLostException(title, PerforceArb.get("ERROR_NOT_CONNECT"), runner.getErrorText(), connect);
        }
    }

    public static String getChangelistNo(PerforceConnectionProfile connect, URL url) throws Exception {
        PerforceFstatResult fstat = PerforceGetStatus.fstat(connect, URLFileSystem.getPlatformPathName((URL)url));
        String changeLst = fstat.getChangelist() != null ? fstat.getChangelist() : "default";
        return changeLst;
    }

    private static PerforceChangeListName getChangelistData(PerforceConnectionProfile connect) throws Exception {
        return PerforceChangelistManager.getInstance().getChangeListName(connect);
    }

    public static boolean connectionNameUsed(PerforceConnectionProfile tConnection) {
        if (tConnection.getName().isEmpty()) {
            return false;
        }
        try {
            Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
            Iterator<PerforceConnectionProfile> it = cons.iterator();
            while (it.hasNext()) {
                String name = it.next().getName();
                if (name.isEmpty() || !name.equals(tConnection.getName())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static PerforceConnectionProfile connectionUsed(PerforceConnectionProfile tConnection) {
        try {
            Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
            for (PerforceConnectionProfile used : cons) {
                if (!used.equals(tConnection)) continue;
                return used;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static void getMovedFileDetails(PerforceConnectionProfile connect, Collection<ChangeListFile> clFiles) {
        ArrayList<String> files = new ArrayList<String>();
        for (ChangeListFile clf : clFiles) {
            if (!clf.isMoveAddAction()) continue;
            files.add(clf.getWorkspaceFile());
        }
        if (files.size() == 0) {
            return;
        }
        PerforceFstatResult[] results = null;
        try {
            results = PerforceGetStatus.fstat(connect, files);
        }
        catch (VCSException vCSException) {
            // empty catch block
        }
        for (PerforceFstatResult result : results) {
            if (result.getMovedFile() == null) continue;
            for (ChangeListFile clf : clFiles) {
                if (!result.getClientFile().equals(clf.getWorkspaceFile())) continue;
                clf.setMovedFile(result.getMovedFile());
            }
        }
    }

    public static void usageTrackerLog() {
        UsagesTracker tracker = UsagesTracker.getUsagesTracker();
        UsageData data = tracker.createUsageData();
        data.setEventSource("SCM");
        data.setProperty("scm-type", "Perforce");
        data.setEventId("CREATE_CONNECTION");
        tracker.report(data);
    }

    public static final String[] getURLFileNamesAndConvertToAscii(URL[] urls) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (URL url : urls) {
            filenames.add(PerforceUtil.convertToAscii(URLFileSystem.getFileName((URL)url)));
        }
        return filenames.toArray(new String[0]);
    }

    public static String convertToAscii(String name) {
        name = name.replace("%", "%25");
        name = name.replace("@", "%40");
        name = name.replace("#", "%23");
        name = name.replace("*", "%2A");
        return name;
    }
}

