/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import oracle.ide.config.Preferences;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceLoginProcess {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceLoginProcess.class.getName());
    private static String P4_COMMAND = "p4";
    private String _terminateOn;
    private char[] _cmdPw;
    private Collection _startCmd = new ArrayList();
    private Process _process;
    private BufferedWriter _writer;
    private BufferMonitor _monitor;
    private boolean _keepRunning = true;
    private Long _iTimeOut = null;
    private boolean _exited;

    public PerforceLoginProcess(Collection cmds, String terminateOn) {
        this._startCmd.add(P4_COMMAND);
        this._startCmd.addAll(cmds);
        this._terminateOn = terminateOn;
        this.initializeProcess();
    }

    public final void destroyProcess() {
        if (this._writer != null) {
            try {
                this._writer.write("exit");
                this._writer.newLine();
                this._writer.close();
                this._keepRunning = false;
            }
            catch (IOException ioe) {
                sLogger.warning(ioe.getMessage());
            }
        }
        if (this._process != null) {
            try {
                this._process.getInputStream().close();
                this._process.getErrorStream().close();
            }
            catch (Exception e) {
                sLogger.warning(e.getMessage());
                Assert.printStackTrace((Throwable)e);
            }
            this._process.destroy();
        }
        this._process = null;
        this._writer = null;
    }

    public void setCmdPasswd(char[] cmd) {
        this._cmdPw = cmd;
    }

    public String getErrorMessage() {
        return this.getMonitor().getErrorText();
    }

    public String getOutputText() {
        return this.getMonitor().getOutputText();
    }

    public int execAndWait() {
        if (this._terminateOn == null) {
            throw new IllegalStateException(PerforceArb.get("FAIL_LOG_TERMINATE"));
        }
        if (this._exited) {
            return -1;
        }
        try {
            this.doExecSpi(this._cmdPw);
        }
        catch (IOException e) {
            sLogger.warning(e.getMessage());
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean isError() {
        return this.getMonitor().isError();
    }

    public boolean isExited() {
        return this._exited;
    }

    public void doExecSpi(char[] cmd) throws IOException {
        if (this._process == null || this._writer == null || this._monitor == null) {
            return;
        }
        char[] command = null;
        if (cmd != null) {
            command = cmd;
        }
        this.beginCommand();
        try {
            if (this._exited) {
                return;
            }
            if (command != null) {
                this._writer.write(command);
                this._writer.newLine();
                this._writer.flush();
            }
            this._monitor.waitForCommand();
        }
        catch (IOException ioe) {
            sLogger.warning(ioe.getMessage());
            this._exited = true;
        }
        if (!this._monitor.isTimedOut() && !this._monitor.isError()) {
            return;
        }
        if (this._monitor.isTimedOut()) {
            this._monitor.streamErrorLine("TimeOut" + this._monitor.isTimedOut());
        }
    }

    private Collection getStartCommand() {
        return this._startCmd;
    }

    private Process createProcess() throws IOException {
        String[] cmdarray = this.getStartCommand().toArray(new String[0]);
        return Runtime.getRuntime().exec(cmdarray);
    }

    private final void initializeProcess() {
        if (this._process != null) {
            this.destroyProcess();
        }
        this._monitor = new BufferMonitor();
        try {
            this._process = this.createProcess();
            new MonitorThread(this._process.getInputStream(), "Perforce Processor Output"){

                @Override
                protected final void gotLine(String line) {
                    if (!PerforceLoginProcess.this._exited) {
                        PerforceLoginProcess.this.getMonitor().streamOutputLine(line);
                    }
                }
            }.start();
            new MonitorThread(this._process.getErrorStream(), "Perforce Processor Error"){

                @Override
                protected final void gotLine(String line) {
                    PerforceLoginProcess.this.getMonitor().streamErrorLine(line);
                }
            }.start();
        }
        catch (IOException ioe) {
            sLogger.warning(ioe.getMessage());
            ioe.printStackTrace();
            return;
        }
        this._writer = new BufferedWriter(new OutputStreamWriter(this._process.getOutputStream()));
    }

    private BufferMonitor getMonitor() {
        return this._monitor;
    }

    private void beginCommand() {
        this._monitor.beginCommand();
    }

    private final class BufferMonitor {
        int _outputcount = 0;
        private final int SLEEP_DURATION = 25;
        private final StringBuffer _outputBuffer = new StringBuffer();
        private final StringBuffer _errorBuffer = new StringBuffer();
        private boolean _finished = true;
        private boolean _isTimedOut;
        private int _timeOut;

        private BufferMonitor() {
        }

        final boolean isError() {
            return this._errorBuffer.length() > 0;
        }

        final void beginCommand() {
            this._outputBuffer.setLength(0);
            this._errorBuffer.setLength(0);
            this._finished = false;
            this._isTimedOut = false;
            if (PerforceLoginProcess.this._iTimeOut == null) {
                this._timeOut = this.getPreferenceTimeOut();
            } else {
                this._timeOut = PerforceLoginProcess.this._iTimeOut.intValue();
                PerforceLoginProcess.this._iTimeOut = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void waitForCommand() {
            try {
                long elapsed = 0L;
                do {
                    Thread.sleep(25L);
                    if (this._finished || PerforceLoginProcess.this._exited) return;
                } while (this._timeOut <= -1 || (elapsed += 25L) <= (long)this._timeOut);
                this._isTimedOut = true;
                return;
            }
            catch (InterruptedException ie) {
                sLogger.warning(ie.getMessage());
                ie.printStackTrace();
            }
        }

        final synchronized String getOutputText() {
            return this._outputBuffer.toString();
        }

        final synchronized String getErrorText() {
            return this._errorBuffer.toString();
        }

        boolean isTimedOut() {
            return this._isTimedOut;
        }

        final void streamOutputLine(String line) {
            if (line.contains(PerforceLoginProcess.this._terminateOn)) {
                this._finished = true;
            }
        }

        final void streamErrorLine(String line) {
            this._errorBuffer.append(line);
            this._finished = true;
        }

        private int getPreferenceTimeOut() {
            int iTime = VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.perforce").getOperationTimeout();
            return (int)((double)iTime * Math.pow(10.0, 3.0));
        }
    }

    private abstract class MonitorThread
    extends Thread {
        private final InputStream _in;

        MonitorThread(InputStream in, String name) {
            super(name);
            this._in = in;
        }

        @Override
        public final void run() {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this._in));
                String line = null;
                while (PerforceLoginProcess.this._keepRunning) {
                    line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    this.gotLine(line);
                }
            }
            catch (IOException ioe) {
                sLogger.warning(ioe.getMessage());
                Assert.printStackTrace((Throwable)ioe);
            }
            finally {
                try {
                    reader.close();
                    PerforceLoginProcess.this._exited = true;
                }
                catch (Exception exception) {}
            }
        }

        protected abstract void gotLine(String var1);
    }
}

