/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRemoteFolder;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class SyncConnectPanel
extends JPanel {
    private JLabel _lblConnectName = new JLabel();
    private JComboBox _cmbConnection = new JComboBox();
    private JTree _trFolder = new JTree();

    public SyncConnectPanel(VCSOptionsCustomizer customizer) {
        try {
            this.setPerforceConnections();
            this.addListeners();
            ServerMutableTreeNode rootNode = new ServerMutableTreeNode();
            rootNode.setUserObject(new PerforceConnectionNode((PerforceConnectionProfile)this._cmbConnection.getSelectedItem()));
            rootNode.setAllowsChildren(true);
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            this._trFolder.setModel(treeModel);
            this._trFolder.getSelectionModel().setSelectionMode(1);
            if (this._trFolder.getRowCount() > 1) {
                this._trFolder.setSelectionRow(1);
            }
            this.jbInit(customizer.getComponent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getInitialFocus() {
        return this._cmbConnection;
    }

    public PerforceConnectionProfile getPerforceConnection() {
        return (PerforceConnectionProfile)this._cmbConnection.getSelectedItem();
    }

    private void jbInit(Component component) {
        JScrollPane scroll = new JScrollPane(this._trFolder);
        Insets ins = new Insets(5, 5, 5, 5);
        ResourceUtils.resLabel((JLabel)this._lblConnectName, (Component)this._cmbConnection, (String)PerforceArb.get("SYNC_ANY_CON_NAME"));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this._lblConnectName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this._cmbConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        panel.add((Component)scroll, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.add(component, "Center");
        scroll.setPreferredSize(new Dimension(100, 150));
    }

    private void setPerforceConnections() throws Exception {
        Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
        Iterator<PerforceConnectionProfile> it = cons.iterator();
        boolean selected = false;
        while (it.hasNext()) {
            PerforceConnectionProfile con = it.next();
            this._cmbConnection.addItem(con);
            if (selected || !PerforceSessionManager.getInstance().isConnected(con)) continue;
            this._cmbConnection.setSelectedItem(con);
        }
    }

    private void addListeners() {
        this._cmbConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                PerforceConnectionProfile con = (PerforceConnectionProfile)cmb.getSelectedItem();
                ServerMutableTreeNode root = (ServerMutableTreeNode)SyncConnectPanel.this._trFolder.getModel().getRoot();
                root.removeAllChildren();
                root.setUserObject(new PerforceConnectionNode(con));
                root.setAllowsChildren(true);
                ((DefaultTreeModel)SyncConnectPanel.this._trFolder.getModel()).reload();
                if (SyncConnectPanel.this._trFolder.getRowCount() > 1) {
                    SyncConnectPanel.this._trFolder.setSelectionRow(1);
                }
            }
        });
    }

    public Collection<RemoteItem> getDepotFolders() {
        if (this._trFolder.getSelectionCount() == 0) {
            return Collections.EMPTY_LIST;
        }
        TreePath[] paths = this._trFolder.getSelectionPaths();
        ArrayList<RemoteItem> items = new ArrayList<RemoteItem>();
        for (TreePath path : paths) {
            ServerMutableTreeNode node = (ServerMutableTreeNode)path.getLastPathComponent();
            items.add((RemoteItem)node.getUserObject());
        }
        return items;
    }

    private class ServerMutableTreeNode
    extends DefaultMutableTreeNode {
        boolean populated = false;

        private ServerMutableTreeNode() {
        }

        @Override
        public void setUserObject(Object obj) {
            super.setUserObject(obj);
            this.populated = false;
        }

        @Override
        public int getChildCount() {
            this.populate();
            return super.getChildCount();
        }

        public Enumeration children() {
            this.populate();
            return super.children();
        }

        @Override
        public boolean isLeaf() {
            return !(this.getUserObject() instanceof PerforceRemoteFolder);
        }

        private void populate() {
            if (this.populated) {
                return;
            }
            if (this.getUserObject() != null && this.getUserObject() instanceof PerforceRemoteFolder) {
                PerforceRemoteFolder folder = (PerforceRemoteFolder)this.getUserObject();
                Iterator it = folder.getChildren();
                this.populated = true;
                while (it.hasNext()) {
                    Object obj = it.next();
                    ServerMutableTreeNode node = new ServerMutableTreeNode();
                    node.setUserObject(obj);
                    if (obj instanceof PerforceRemoteFolder) {
                        node.setAllowsChildren(true);
                    } else {
                        node.setAllowsChildren(false);
                    }
                    this.add(node);
                }
            }
        }
    }
}

