/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceVersionToolsPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceVersionToolsTraversable
extends VCSPreferencesTraversable<PerforceVersionToolsPreferences> {
    private UI _customizerUI;

    public PerforceVersionToolsTraversable() {
        this.setHelpID("f1_pfcpreferencesversiontools_html");
    }

    protected PerforceVersionToolsPreferences getPreferences(PropertyStorage prefs) {
        return PerforceVersionToolsPreferences.getInstance(prefs);
    }

    protected Component getPage() {
        if (this._customizerUI == null) {
            this._customizerUI = new UI();
        }
        return this._customizerUI;
    }

    public void loadPreferences(PerforceVersionToolsPreferences prefs) {
        int useCID = prefs.getPendingChangesDialogUsage();
        this._customizerUI.getCIDAlways().setSelected(0 == useCID);
        this._customizerUI.getCIDComments().setSelected(1 == useCID);
        this._customizerUI.getCIDNever().setSelected(2 == useCID);
        this._customizerUI.setClientMerge(prefs.getUseClientMerge());
    }

    public void savePreferences(PerforceVersionToolsPreferences prefs) {
        int value = 1;
        if (this._customizerUI.getCIDAlways().isSelected()) {
            value = 0;
        } else if (this._customizerUI.getCIDNever().isSelected()) {
            value = 2;
        }
        prefs.setPendingChangesDialogUsage(value);
        prefs.setUseClientMerge(this._customizerUI.isClientMerge());
    }

    protected void validatePreferences() throws TraversalException {
    }

    public class UI
    extends JPanel {
        private JLabel _lblPendingFiles;
        private JLabel _lblUseSubmit;
        private JRadioButton _chkAlways;
        private JRadioButton _chkComments;
        private JRadioButton _chkNever;
        private ButtonGroup _bg;
        private ButtonGroup _bgMerge;
        private JLabel _lblMerge;
        private JRadioButton _rbMergeServer;
        private JRadioButton _rbMergeClient;

        public UI() {
            this.createComponents();
            this.layoutComponents();
            this._bg = new ButtonGroup();
            this._bg.add(this._chkAlways);
            this._bg.add(this._chkComments);
            this._bg.add(this._chkNever);
            this._bgMerge = new ButtonGroup();
            this._bgMerge.add(this._rbMergeClient);
            this._bgMerge.add(this._rbMergeServer);
            this.initialize();
        }

        private void createComponents() {
            this._lblPendingFiles = new JLabel();
            this._lblUseSubmit = new JLabel();
            this._chkAlways = new JRadioButton();
            this._chkComments = new JRadioButton();
            this._chkNever = new JRadioButton();
            this._lblMerge = new JLabel();
            this._rbMergeServer = new JRadioButton();
            this._rbMergeClient = new JRadioButton();
        }

        private void layoutComponents() {
            Insets lblIns = new Insets(2, 5, 3, 5);
            int row = 0;
            this.setLayout(new GridBagLayout());
            this.add((Component)this._lblPendingFiles, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
            this.add((Component)this._lblUseSubmit, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 5), 0, 0));
            this.add((Component)this._chkAlways, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 60, 5, 5), 0, 0));
            this.add((Component)this._chkComments, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 60, 5, 5), 0, 0));
            this.add((Component)this._chkNever, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 60, 5, 5), 0, 0));
            this.add((Component)this._lblMerge, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
            this.add((Component)this._rbMergeClient, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 5), 0, 0));
            this.add((Component)this._rbMergeServer, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 5), 0, 0));
        }

        public JRadioButton getCIDAlways() {
            return this._chkAlways;
        }

        public JRadioButton getCIDComments() {
            return this._chkComments;
        }

        public JRadioButton getCIDNever() {
            return this._chkNever;
        }

        private void initialize() {
            this._lblPendingFiles.setText(PerforceArb.get("VERSION_PENDING"));
            ResourceUtils.resLabel((JLabel)this._lblUseSubmit, (Component)this._chkAlways, (String)PerforceArb.get("VERSION_SUBMIT"));
            ResourceUtils.resButton((AbstractButton)this._chkAlways, (String)PerforceArb.get("VERSION_ALWAYS"));
            ResourceUtils.resButton((AbstractButton)this._chkComments, (String)PerforceArb.get("VERSION_COMMENTS"));
            ResourceUtils.resButton((AbstractButton)this._chkNever, (String)PerforceArb.get("VERSION_NEVER"));
            ResourceUtils.resLabel((JLabel)this._lblMerge, (Component)this._rbMergeClient, (String)PerforceArb.get("VERSION_MERGE_LABEL"));
            ResourceUtils.resButton((AbstractButton)this._rbMergeClient, (String)PerforceArb.get("VERSION_MERGE_CLIENT"));
            ResourceUtils.resButton((AbstractButton)this._rbMergeServer, (String)PerforceArb.get("VERSION_MERGE_SERVER"));
        }

        private boolean isClientMerge() {
            return this._rbMergeClient.isSelected();
        }

        private void setClientMerge(boolean client) {
            if (client) {
                this._rbMergeClient.setSelected(true);
            } else {
                this._rbMergeServer.setSelected(true);
            }
        }
    }
}

