/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotNavigatorAPI;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotsFilterNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRootNode;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceDeleteConnection;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceEditConnectionCommand;

public class PerforceNavigatorController
implements Controller {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceNavigatorController.class.getName());

    public boolean handleEvent(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        if (!ConnectionProvider.isVersioningConnectionView((View)context.getView())) {
            return false;
        }
        PerforceDepotNavigatorAPI navApi = PerforceDepotNavigatorAPI.getInstance();
        Node node = context.getNode();
        if (action.getCommandId() == 51 && navApi.canRefresh(node)) {
            RevertNodeCommand.reload((Context)context, (boolean)false);
            this.refreshNavigator(context);
            return true;
        }
        if (action.getCommandId() == 56 && node instanceof PerforceConnectionNode) {
            this.invokeCommand(context, (Command)new PerforceEditConnectionCommand());
            return true;
        }
        if (action.getCommandId() == 20 && node instanceof PerforceConnectionNode) {
            PerforceDeleteConnection command = new PerforceDeleteConnection();
            this.invokeCommand(context, (Command)command);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (!ConnectionProvider.isVersioningConnectionView((View)context.getView())) {
            return false;
        }
        PerforceDepotNavigatorAPI navApi = PerforceDepotNavigatorAPI.getInstance();
        Node node = context.getNode();
        if (action.getCommandId() == 20) {
            if (node instanceof PerforceConnectionNode) {
                action.setEnabled(true);
                return true;
            }
            if (node instanceof PerforceDepotsFilterNode || node instanceof RemoteItem || node instanceof PerforceRootNode) {
                action.setEnabled(false);
                return true;
            }
        } else if (action.getCommandId() == 51) {
            if (node instanceof RemoteItem) {
                action.setEnabled(navApi.canRefresh(node));
                return true;
            }
            if (node instanceof PerforceRootNode) {
                action.setEnabled(true);
                return true;
            }
            if (node instanceof PerforceDepotsFilterNode) {
                action.setEnabled(false);
                return true;
            }
        } else if (action.getCommandId() == 56 && node instanceof PerforceConnectionNode) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    private void invokeCommand(Context ctx, Command command) {
        try {
            command.setContext(ctx);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            PerforceProfile.getErrorHandler().handleException(e);
            sLogger.log(Level.WARNING, "Error " + e.getMessage());
        }
    }

    private void refreshNavigator(final Context context) {
        if (context.getView() instanceof NavigatorWindow) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExplorer explorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
                    TNode nodeT = explorer.searchTNode((Element)context.getNode(), explorer.getRoot());
                    explorer.expand(nodeT, false, true);
                }
            });
        }
    }
}

