/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdevimpl.vcs.perforce2.DefaultPerforceConnection;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotNavigatorManager;
import oracle.jdevimpl.vcs.perforce2.res.Bundle;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.ConnectionPanel;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceFinish;
import oracle.jdevimpl.vcs.perforce2.util.ClientInfo;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceLoginProcess;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceConnectionWizard
extends Wizard {
    public static String EDITING = "editing";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceConnectionWizard.class.getName());
    private Icon _icon;
    private boolean _edit;
    private PerforceConnectionProfile _connect = null;

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        if (!PerforceSessionManager.getInstance().isClientInstalled()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)PerforceArb.get("ERROR_P4_CLIENT"), (String)PerforceArb.get("PERFORCE_CONNECTION_TITLE"), null);
            return false;
        }
        try {
            if (this.connect(context)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getShortLabel() {
        return Bundle.get("NAV_CONNECTION_WIZARD_LABEL");
    }

    public String getLongLabel() {
        return Bundle.get("NAV_CONNECTION_WIZARD_DESCRIPTION");
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = ImageIconCache.get((URL)Bundle.class.getResource(Bundle.get("ACTION_CLIENT_ICON")));
        }
        return this._icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Context context) throws Exception {
        this._edit = context.getBoolean(EDITING);
        ConnectionPanel panel = new ConnectionPanel();
        if (this._edit) {
            this._connect = this.getConnectionProfile(context);
            this.setAuthenticationDetails(this._connect, panel);
        } else {
            this.setDefaultAuthentication(panel);
        }
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)PerforceArb.get("CONNECT_TITLE"));
        dialog.setMinimumSize(300, 360);
        panel.addFinishListener(new PerforceFinish(){

            @Override
            public void canFinish(boolean finish) {
                dialog.setOKButtonEnabled(finish);
            }
        });
        panel.initialize();
        dialog.addVetoableChangeListener((VetoableChangeListener)new ConnectionChangeListener());
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(PerforceArb.get("CONNECT_DESCRIPTION"));
        dialog.setDialogHeader((Component)header);
        try {
            if (VCSDialogRunner.runDialog((JDialog)dialog)) {
                PerforceSessionManager.getInstance().disconnect(this._connect, true);
                if (this._connect == null) {
                    this._connect = new PerforceConnectionProfile();
                }
                this._connect.setUser(panel.getUsername());
                this._connect.setPassword(panel.getPassword());
                this._connect.setServer(panel.getServer());
                this._connect.setClient(panel.getClient());
                this._connect.setName(panel.getConnectionName());
                boolean stat = PerforceSessionManager.getInstance().connect(this._connect);
                if (this._edit) {
                    this.updateNavigatorNode(this._connect, context);
                } else {
                    this.createNavigatorNode(this._connect);
                }
                PerforceUtil.usageTrackerLog();
                this._connect.setPassword(new char[0]);
                boolean bl = stat;
                return bl;
            }
        }
        finally {
            dialog.dispose();
        }
        return false;
    }

    private void createNavigatorNode(PerforceConnectionProfile connect) {
        PerforceDepotNavigatorManager.getInstance().createConnection(connect);
        PerforceDepotNavigatorManager.getInstance().showRepositoryNavigator();
    }

    private void updateNavigatorNode(PerforceConnectionProfile con, Context context) {
        PerforceConnectionNode node = (PerforceConnectionNode)context.getNode();
        PerforceDepotNavigatorManager.getInstance().removeConnection(node);
        PerforceDepotNavigatorManager.getInstance().createConnection(con);
    }

    private PerforceConnectionProfile getConnectionProfile(Context context) {
        if (context.getNode() instanceof PerforceConnectionNode) {
            return (PerforceConnectionProfile)((PerforceConnectionNode)context.getNode()).getData();
        }
        if (context.getElement() instanceof PerforceConnectionNode) {
            return (PerforceConnectionProfile)((PerforceConnectionNode)context.getElement()).getData();
        }
        return null;
    }

    private void setAuthenticationDetails(PerforceConnectionProfile con, ConnectionPanel panel) {
        panel.setUsername(con.getUser());
        panel.setPassword("");
        panel.setServer(con.getServer());
        panel.setClient(con.getClient());
        panel.setConnectionName(con.getName());
    }

    private void setDefaultAuthentication(ConnectionPanel panel) {
        DefaultPerforceConnection connect = new DefaultPerforceConnection();
        panel.setServer(connect.getServer());
        panel.setClient(connect.getClient());
        panel.setUsername(connect.getUser());
    }

    private class ClientHostMonitor
    extends VCSStreamMonitor {
        private String _hostname;
        private String _clientHost;

        private ClientHostMonitor() {
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            if (line.startsWith("Host") || line.startsWith(PerforceArb.get("HOST_STRING"))) {
                String[] parts = line.split(":");
                this._clientHost = parts[1].trim();
            }
        }

        private String isClientForHost() {
            return this._clientHost;
        }
    }

    private class ConnectionChangeListener
    implements VetoableChangeListener {
        private String _hostname;

        private ConnectionChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                JEWTDialog dialog = (JEWTDialog)pce.getSource();
                ConnectionPanel panel = (ConnectionPanel)dialog.getContent();
                this.validateDialog(pce, panel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateDialog(PropertyChangeEvent pce, ConnectionPanel panel) throws PropertyVetoException {
            if (panel.getUsername() == null || panel.getUsername().length() == 0) {
                this.errorMessage(pce, panel, PerforceArb.get("CONNECT_NO_USER"));
            }
            if (panel.getServer() == null || panel.getServer().length() == 0) {
                this.errorMessage(pce, panel, PerforceArb.get("CONNECT_NO_PORT"));
            }
            if (panel.getClient() == null || panel.getClient().length() == 0) {
                this.errorMessage(pce, panel, PerforceArb.get("CONNECT_NO_CLIENT"));
            }
            PerforceConnectionProfile tConnection = new PerforceConnectionProfile(panel.getConnectionName(), panel.getUsername(), panel.getPassword(), panel.getServer(), panel.getClient());
            if (PerforceConnectionWizard.this._edit) {
                this.editConnection(pce, panel, tConnection);
            } else {
                this.createConnection(pce, panel, tConnection);
            }
            PerforceLoginProcess process = null;
            try {
                boolean confirm;
                try {
                    process = PerforceCommands.getTestConnectionLogin(panel.getUsername(), panel.getPassword(), panel.getServer());
                }
                catch (Exception ex) {
                    this.errorMessage(pce, panel, ex.getMessage());
                }
                if (!process.getErrorMessage().isEmpty()) {
                    this.errorMessage(pce, panel, PerforceArb.get("CONNECT_TO_SERVER_FAILED"));
                }
                String client = panel.getClient();
                Map<String, ClientInfo> clInfo = null;
                try {
                    clInfo = PerforceCommands.getUserClientSpecForNamedFilter(panel.getServer(), panel.getUsername(), client);
                }
                catch (Exception ex) {
                    this.errorMessage(pce, panel, ex.getMessage());
                }
                if (clInfo.isEmpty()) {
                    this.errorMessage(pce, panel, PerforceArb.get("CONNECT_CLIENT_NOT_VALID"));
                }
                if (clInfo.size() > 1 && clInfo.containsKey(client)) {
                    this.errorMessage(pce, panel, PerforceArb.get("CONNECT_CLIENT_NOT_VALID"));
                    return;
                }
                try {
                    String clientHost = this.getHostOfClient(panel.getServer(), panel.getUsername(), client);
                    if (clientHost != null && !this.getHostName().equalsIgnoreCase(clientHost)) {
                        MessageDialog.information((Component)panel, (Object)PerforceArb.format("CONNECT_CLIENT_WRONG_HOST", client, clientHost, this.getHostName()), (String)PerforceArb.get("PERFORCE_CONNECTION_TITLE"), null);
                        throw new PropertyVetoException(PerforceArb.get("PERFORCE_CONNECTION_FAILED"), pce);
                    }
                }
                catch (PerforceOperationException clientHost) {
                    // empty catch block
                }
                String clientPath = clInfo.get(client).getClientRoot();
                URL url = URLFactory.newDirURL((String)clientPath);
                if (!URLFileSystem.exists((URL)url) && (confirm = MessageDialog.confirm((Component)panel, (Object)PerforceArb.format("CONNECT_CLIENT_ROOT_FOLDER", clientPath), (String)PerforceArb.get("PERFORCE_CONNECTION_TITLE"), null)) && !URLFileSystem.mkdirs((URL)url)) {
                    MessageDialog.information((Component)panel, (Object)PerforceArb.format("CONNECT_CREATE_FAILED_FOLDER", clientPath), (String)PerforceArb.get("PERFORCE_CONNECTION_TITLE"), null);
                }
            }
            finally {
                try {
                    PerforceCommands.logout(panel.getServer(), panel.getUsername());
                    process.destroyProcess();
                }
                catch (Exception ex) {}
            }
        }

        private void createConnection(PropertyChangeEvent pce, ConnectionPanel panel, PerforceConnectionProfile tConnection) throws PropertyVetoException {
            if (PerforceUtil.connectionNameUsed(tConnection)) {
                this.errorMessage(pce, panel, PerforceArb.get("ERROR_CONNECT_NAME"));
            }
            if (PerforceUtil.connectionUsed(tConnection) != null) {
                this.errorMessage(pce, panel, PerforceArb.get("ERROR_CONNECT_DETAILS"));
            }
        }

        private void editConnection(PropertyChangeEvent pce, ConnectionPanel panel, PerforceConnectionProfile tConnection) throws PropertyVetoException {
            if (!tConnection.getName().equals(PerforceConnectionWizard.this._connect.getName()) && PerforceUtil.connectionNameUsed(tConnection)) {
                this.errorMessage(pce, panel, PerforceArb.get("ERROR_CONNECT_NAME"));
            }
            if (!tConnection.equals(PerforceConnectionWizard.this._connect) && PerforceUtil.connectionUsed(tConnection) != null) {
                this.errorMessage(pce, panel, PerforceArb.get("ERROR_CONNECT_DETAILS"));
            }
        }

        private void errorMessage(PropertyChangeEvent pce, ConnectionPanel panel, String msg) throws PropertyVetoException {
            MessageDialog.information((Component)panel, (Object)msg, (String)PerforceArb.get("PERFORCE_CONNECTION_TITLE"), null);
            throw new PropertyVetoException(PerforceArb.get("PERFORCE_CONNECTION_FAILED"), pce);
        }

        private String getHostOfClient(String server, String user, String client) throws PerforceOperationException {
            PerforceShellRunner runner = new PerforceShellRunner();
            ClientHostMonitor monitor = new ClientHostMonitor();
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("-p");
            cmds.add(server);
            if (user != null && user.length() > 0) {
                cmds.add("-u");
                cmds.add(user);
            }
            cmds.add("client");
            cmds.add("-o");
            cmds.add(client);
            runner.setCmdList(cmds);
            runner.addOutputMonitor(monitor);
            runner.setQuiet(true);
            try {
                runner.exec();
            }
            catch (Exception ex) {
                sLogger.log(Level.WARNING, " Failed to determine if client " + client + " is for host " + this.getHostName());
                throw new PerforceOperationException(PerforceArb.format("ERROR_CLIENT_FOR_HOST", client));
            }
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                sLogger.log(Level.WARNING, " Failed to determine if client " + client + " is for host " + this.getHostName());
                throw new PerforceOperationException(runner.getErrorText());
            }
            return monitor.isClientForHost();
        }

        private String getHostName() {
            if (this._hostname == null) {
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    this._hostname = localMachine.getHostName();
                }
                catch (UnknownHostException e) {
                    this._hostname = "";
                }
            }
            return this._hostname;
        }
    }
}

